#install.packages('lmtest') 
#install.packages('spgs')
#install.packages('lattice')
#install.packages('ggplot2')
#install.packages("viridis")
#install.packages('parallelMap')
#install.packages('randtests') 
#install.packages('evd')
#install.packages('data.table')
#install.packages('nimble')
#install.packages('fGarch')
#install.packages('sarima')
#install.packages('forecast')
#install.packages('tsDyn')
#install.packages('synlik')
#install.packages('latex2exp')
#install.packages('rasterVis')
install.packages('gridExtra')
install.packages('pastecs')
install.packages('bigmemory')




library(tseries) #Runs-Test + #BDS-test
library(lmtest)  #Durbin-Watson + #Breusch Godfrey
library(devtools)
library(spgs) # Turning-Point-Test
library(randtests) #Difference-Runs-Test # VNR
library(GSignTest) #Vorzeichentiefe
library(lattice) #heatmap
library(viridis) # Farbpalette
library(parallelMap) # Parallelisierung am Heimrechner
library(evd) # gumbel verteilung
library(data.table) # Karthesisches Produkt
library(nimble) # Doppelexponentialverteilung
library(fGarch) # Garch-Simulationen
library(sarima) # saisonale arima-Modelle
library(forecast) #  auto-Arima-Funktion
library(tsDyn)
library(synlik)
library(latex2exp)
library(magicaxis)
library(gridExtra)
library(pastecs)
library(bigmemory)
#library(latticeExtra)
#library(rasterVis)


######### Laden der Vorzeichentiefe

#devtools::install_github("melaniehorn/GSignTest")


######### Setzen des seeds

set.seed(123)


#________________________________________________________________________________________________________
############################################## Funktionen ###############################################
#________________________________________________________________________________________________________


### Vorzeichen

sign_w0 <- function(x){                        
  x <- sign(x)
  if(length(which(x == 0)) > 0){
    x <- x[-which(x == 0)]}
  return(x)
}


### Testfunktionen 

Tests<- function(order=order,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= sample(c(-1,1),shockno,replace=T)*shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### Testfunktionen 

TestsVZT<- function(order=order,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= sample(c(-1,1),shockno,replace=T)*shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.00095||vz3>0.95095), '4-VZ'= as.numeric(vz4<0.00235||vz4>0.95235), '5-VZ'= as.numeric(vz5<0.00355||vz5>0.95355))
  return(test_list)
}



####### Tests Simplified

TestsSimp<- function(order=order,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= sample(c(-1,1),shockno,replace=T)*shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}



####### Tests Simplified

TestsSimpDif<- function(order=order,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n+1)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= sample(c(-1,1),shockno,replace=T)*shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n+1)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  sim_data= diff(sim_data)
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


####### Tests Simplified

TestsSimpS<- function(order=order,season=season,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= sample(c(-1,1),shockno,replace=T)*shockint
  sim_data=arima.sim(list(order=order, ar=c(rep(0,season-1),rho),mean=mean),innov=shock, n=n)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}



#### Einseitige Version

TestsES<- function(order=order,rho=rho,mean=mean,center=center,n=n,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'greater')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$statistic

  
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$statistic

  
  #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim), alternative="less")$p.value
  #difruns= difference.sign.test(sim_data)$p.value
  
  tp= turningpoint.test(sim_data)$statistic
 
  
  VNR=bartels.rank.test(sim_data, alternative="left.sided")$p.value
  
  if (center==FALSE){
    vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  }else{
    vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
    vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
    vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  }
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric((1-pnorm(bds))<0.05), 'Ljung-Box'=as.numeric((1-pchisq(lb,df=15))<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(pnorm(tp)<0.05), '3-VZ'= as.numeric(vz3<0.05), '4-VZ'= as.numeric(vz4<0.05), '5-VZ'= as.numeric(vz5<0.05))
  return(test_list)
}

### Mit Sprung

TestsSprung1<- function(order=order,rho=rho,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[floor(length(sim_data)/2):length(sim_data)]=sim_data[floor(length(sim_data)/2):length(sim_data)]+1.96/2
  sim_data[1:floor(length(sim_data)/2)-1]=sim_data[1:floor(length(sim_data)/2)-1]-1.96/2
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}

TestsSprung2<- function(order=order,rho=rho,mean=mean,n=n,hhe=hhe,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[floor(length(sim_data)/2):length(sim_data)]=sim_data[floor(length(sim_data)/2):length(sim_data)]+hhe/2
  sim_data[1:floor(length(sim_data)/2)-1]=sim_data[1:floor(length(sim_data)/2)-1]-hhe/2
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(res_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(res_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(res_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### Wachsende Varianz

TestsWVar<- function(order=order,rho=rho,mean=mean,Var=Var,center=center,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  shock= vector(mode='integer', length=n)
  sdw= seq(from=1,to=Var,length.out=n)
  for(i in 1:length(shock)){
    shock[i]=rnorm(mean=0,sd=sdw[i],n=1)
  }
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### TAR-Modell


TestsTAR<- function(order=order,rho=rho,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n+10)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  
  sim_data2= vector(mode='double', length=20)
  sim_data2[1]= shock[1]
  
  for(i in 2:(n+10)){
    if( sim_data2[i-1]<=0){
      sim_data2[i]= (-rho)*sim_data2[i-1] + shock[i]
    } else {
      sim_data2[i]= (rho)*sim_data2[i-1] + shock[i]
    }
  }
  
  sim_data=sim_data2[11:(n+10)]
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}




TestsTAR2<- function(order=order,rho=rho,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n+10)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  
  sim_data2= vector(mode='double', length=20)
  sim_data2[1]= shock[1]
  
  for(i in 2:(n+10)){
    if( sim_data2[i-1]<=0){
      sim_data2[i]= (rho)*sim_data2[i-1] + shock[i]
    } else {
      sim_data2[i]= (-rho)*sim_data2[i-1] + shock[i]
    }
  }
  
  sim_data=sim_data2[11:(n+10)]
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}





##### MA


TestsMA<- function(order=order,ma=ma,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_data=arima.sim(list(order=order, ma=ma,mean=mean),innov=shock, n=n)
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}



##### MA


TestsMASimp<- function(order=order,ma=ma,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_data=arima.sim(list(order=order, ma=ma,mean=mean),innov=shock, n=n)
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### NL-MA

TestsNLMA<- function(order=order,ma=ma,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n+10)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n +10, scale=scale))}
  }}
  
  
  
  shock[shocktime]= shockint
  
  sim_data2= vector(mode='double', length=n+10)
  sim_data2[1]= shock[1]
  
  for(i in 2:(n+10)){
    sim_data2[i]= shock[i-1]*(ma + shock[i])
    
  }
  sim_data= sim_data2[11:(n+10)]
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}


### BLAR

TestsBLAR<- function(order=order,rho=rho,a=a,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n+10)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n+10, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n +10, scale=scale))}
  }}
  
  
  
  shock[shocktime]= shockint
  
  sim_data2= vector(mode='double', length=n+10)
  sim_data2[1]= shock[1]
  
  for(i in 2:(n+10)){
    sim_data2[i]= sim_data2[i-1]*(rho + a*shock[i-1]) + shock[i]
    
  }
  sim_data= sim_data2[11:(n+10)]
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}


### ARMA

TestsARMA<- function(order=order,ma=ma,rho=rho,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  #print(rho)
  sim_data=arima.sim(list(order=order, ma=ma,ar=rho,mean=mean),innov=shock, n=n)
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}


###### Drift 

TestsD<- function(order,rho,drift=2,n,distr='norm',df=1,scale=1,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  sim_dataD=arima.sim(list(order=order, ar=rho),innov=shock, n=n)
  sim_dataD[konttime]= kontint
  sim_data= sim_dataD  + drift/n *seq(-n/2,n/2-1)
  

  
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


#### Oszillation

TestsO<- function(order=order,rho=rho,amp=amp,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint

  sim_data=arima.sim(list(order=c(1,0,0), ar=rho,mean=0), n=n)
  cospoints=seq(1,n/2,length=n)
  for(i in 1:n){
    sim_data[i]=sim_data[i]+ amp*cos(cospoints[i])
  }
  
  
  
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


TestsO2<- function(order=order,rho=rho,amp=amp,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  
  sim_data=arima.sim(list(order=c(1,0,0), ar=rho,mean=0), n=n)
  cospoints=seq(1,10,length=n)
  for(i in 1:n){
    sim_data[i]=sim_data[i]+ amp*cos(cospoints[i])
  }
  
  
  
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sim_data,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sim_data,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sim_data,K=5, transform=T),N=n,K=5, transform=T)
  
  ### Simplified K=2
  VZWK2= (1/(n-1))*sum(diff(sign(sim_data)) != 0)
  TestStatK2= sqrt(n-1)* ((VZWK2- (1/2)^(1))/ (sqrt((1/2)^(1) * (3- (1/2)^(0) * (1) - 3* (1/2)^(1)))))
  SimpK2=pnorm(TestStatK2)
  
  
  ### Simplified K=3
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  TestK3= (1/(n-2)) * sum(sumK3)
  TestStatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))))
  SimpK3=pnorm(TestStatK3)
  
  
  ### Simplified K=4
  sumK4=vector()
  for(i in 1:(n-3)){
    sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
  }
  TestK4= (1/(n-3)) * sum(sumK4)
  TestStatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))
  SimpK4=pnorm(TestStatK4)
  
  
  ### Simplified K=5
  sumK5=vector()
  for(i in 1:(n-4)){
    sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
  }
  TestK5= (1/(n-4)) * sum(sumK5)
  TestStatK5= sqrt(n-4)* ((TestK5- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))
  SimpK5=pnorm(TestStatK5)
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),'SimpVZTK2'=as.numeric(SimpK2<0.025||SimpK2>0.975), 'SimpVZTK3'=as.numeric(SimpK3<0.025||SimpK3>0.975), 'SimpVZTK4'=as.numeric(SimpK4<0.025||SimpK4>0.975),'SimpVZTK5'=as.numeric(SimpK5<0.025||SimpK5>0.975), 'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


#### Fr saisonalitt (keine innovationen)


TestsS<- function(rho=rho,season=season,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  
  
  if(rho!=0){
    sim_data=sim_sarima(n=n, model= list(ar=c(rep(0,season-1),rho)), innovs=shock)} else {
      sim_data= rnorm(n)
    }
  
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 3, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### SARIMA2

TestsS2<- function(rho=rho,rho2=rho2,a,b,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  if ((distr=='norm')){
    shock=rnorm(n)
  }  else
  {if (!(is.null(df))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, df=df))
  } else
  {if (!(missing(scale))){
    shock=do.call(paste("r",distr[[1]],sep=""),args=list(n=n, scale=scale))}
  }}
  
  shock[shocktime]= shockint
  
  
  if(rho!=0 && rho2!=0){
    sim_data=sim_sarima(n,model=list(ar=c(rep(0,(a-1)),rho,rep(0,(b-1)),rho2)))} else {
      sim_data= rnorm(n)
    }
  
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}





### Fr wechselnde Varianz

TestsH<- function(breakpointsd=breakpointsd,order=order,rho=rho,mean=mean,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  breakpoint= sample(1:n,1)
  
  innovations=c(rnorm(breakpoint),rnorm(n-breakpoint,sd=breakpointsd))
  
  sim_data=arima.sim(list(order=order, ar=rho,mean=mean),innov=innovations, n=n)
  sim_data[konttime]= kontint
  
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}

### Fr GARCH

TestsGARCH<- function(alpha=alpha,beta=beta,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  #Generieren + Residuen +Signs
  spec = garchSpec(model = list(alpha = alpha, beta = beta))
  sim_data=garchSim(spec, n = n) #Funktion aus dem Paket fGarch
  

  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 15, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### Tests fr nichtlineare Modelle


TestsNL<- function(alpha=alpha,beta=beta,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  

  
  sim_data= rep(NaN,n)
  while ((NaN %in% sim_data) | (Inf %in% sim_data )| (-Inf %in% sim_data)){
    innovs= as.complex(rnorm(n+10,sd=0.1))
    
    dats=complex(n+10)
    dats[1] <- 100
    dats[2] <- dats[1] + alpha* (dats[1]^beta) + innovs[2]
    
    for(i in (3:(n+10))){
      dats[i] =  dats[i-1] + alpha * (dats[i-1] ^beta) + innovs[i]
      
    }
    
    sim_data= Re(dats[11:(n+10)])
  }
  
  ### Residuen berechnen
  resids2=complex(n)
  resids2[1]= 1
  for(i in 2:length(sim_data)){
    resids2[i] = sim_data[i] - (sim_data[i-1] + 0.005*(sim_data[i-1]^(1.1)))
  }
  
  resids=Re(resids2)

  # plot(resids, ylab='Residuen')
  ###

  sign_sim= sign_w0(resids)
  
  
  #Tests
  dw= dwtest(resids~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(resids~1 + seq(1,n))$p.value
  lb=Box.test(resids, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(resids,m=2, eps= 0.5*sd(resids))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(factor(sign_sim, levels=c(1,-1)))$p.value
  difruns= difference.sign.test(resids)$p.value
  tp= turningpoint.test(resids)$p.value
  VNR=bartels.rank.test(resids)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=as.numeric(dw<0.05),'VonNeumannRang'= as.numeric(VNR<0.05), 'BDS'=as.numeric(bds<0.05), 'Ljung-Box'=as.numeric(lb<0.05), 'Runs'= as.numeric(runs<0.05),  'Turning-Point'=as.numeric(tp<0.05), '3-VZ'= as.numeric(vz3<0.025||vz3>0.975), '4-VZ'= as.numeric(vz4<0.025||vz4>0.975), '5-VZ'= as.numeric(vz5<0.025||vz5>0.975))
  return(test_list)
}


### INAR

inarsim <- function(n, lambda){
  Y= rep(0, (n+10))
  
  for(i in 2:(n+10)){
    Y[i]=rbinom(1,Y[(i-1)],rho)+rpois(1,lambda)}
  
  sim_data= Y[11:(n+10)]
  return(sim_data)
}

TestsINAR<- function(order=order,rho=rho,lambda=lambda,n=n,distr=distr,df=df,scale,shockno=shockno,shockint=shockint, shocktime=shocktime, kontno=kontno, kontint=kontint, konttime=konttime){
  
  sim_data= inarsim(n,lambda)
  
  
  sim_data[konttime]= kontint
  res_sim = sim_data - median(sim_data)
  sign_sim= sign_w0(res_sim)
  
  #Tests
  dw= dwtest(sim_data~ 1+seq(1,n), alternative= 'two.sided')$p
  bg=bgtest(sim_data~1 + seq(1,n))$p.value
  lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value
  bds=bds.test(sim_data,m=2, eps= 0.5*sd(sim_data))$p.value                 #S. BDS-Statistic 2.
  runs=tseries::runs.test(as.factor(sign_sim))$p.value
  difruns= difference.sign.test(sim_data)$p.value
  tp= turningpoint.test(sim_data)$p.value
  VNR=bartels.rank.test(sim_data)$p.value
  vz3=pdepth(calcDepth(sign_sim,K=3, transform=T),N=n,K=3, transform=T)
  vz4=pdepth(calcDepth(sign_sim,K=4, transform=T),N=n,K=4, transform=T)
  vz5=pdepth(calcDepth(sign_sim,K=5, transform=T),N=n,K=5, transform=T)
  
  
  #return
  test_list=list('Durbin-Watson'=c(dw,dw<0.05),'VonNeumannRang'= c(VNR,VNR<0.05), 'BDS'=c(bds,bds<0.05), 'Ljung-Box'=c(lb,lb<0.05), 'Box-Pearson'=c(bp,bp<0.05), 'Runs'= c(runs,runs<0.05), 'DifRuns'= c(difruns, difruns<0.05), 'Turning-Point'=c(tp,tp<0.05), '3-VZ'= c(vz3,vz3<0.025||vz3>0.975), '4-VZ'= c(vz4,vz4<0.025||vz4>0.975), '5-VZ'= c(vz5,vz5<0.025||vz5>0.975))
  return(test_list)
}




### Ablehnungsraten fr Gitter

#Normal

Rejrates <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) Tests(order,rho=as.numeric(testgrid[X,][2]),mean=as.numeric(testgrid[X,][1]),n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


RejratesES <- function(reps, n,center=FALSE, order, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsES(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


### MA

RejratesMA <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsMA(order,ma=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


### MA

RejratesMASimp <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsMASimp(order,ma=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}
### NLMA

RejratesNLMA <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsNLMA(order,ma=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}

### BLAR

RejratesBLAR <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsBLAR(order,rho=as.numeric(testgrid[X,][1]),a=as.numeric(testgrid[X,][2]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}



### Drift

RejratesD <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsD(order,rho=as.numeric(testgrid[X]),drift=2,n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)))))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}

RejratesD2 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsD(order,rho=as.numeric(testgrid[X,1]),drift=as.numeric(testgrid[X,2]),n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}


# Oszillation

RejratesO <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsO(order,rho=as.numeric(testgrid[X,1]),amp=as.numeric(testgrid[X,2]),n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test])))/reps)
  testgrid$Rej=Rates
  return(testgrid)
}

RejratesO2 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsO2(order,rho=as.numeric(testgrid[X,1]),amp=as.numeric(testgrid[X,2]),n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test])))/reps)
testgrid$Rej=Rates
  return(testgrid)
}

# TAR

RejratesTAR <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsTAR(order,rho=as.numeric(testgrid[X]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}

# TAR2

RejratesTAR2 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsTAR2(order,rho=as.numeric(testgrid[X]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# Einfaches Grid

Rejrates1 <- function(reps, n,center=FALSE, order, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(Tests(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# Annahmebereich

RejratesVZT <- function(reps, n,center=FALSE, order, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsVZT(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# Einfaches Grid

RejratesSimp <- function(reps, n,center=FALSE, order, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsSimp(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}

# Einfaches Grid Diff

RejratesSimpDif <- function(reps, n,center=FALSE, order, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsSimpDif(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# Saisonal
RejratesSimpS<- function(reps, n,center=FALSE,test, testgrid,distr= 'norm',mean=0,loc=0,scale=NULL,df=NULL,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    rowSums(parallelSapply(Y, function(Y) as.numeric(TestsSimpS(order=c(as.numeric(testgrid[X,2]),0,0),season=as.numeric(testgrid[X,2]),rho=as.numeric(testgrid[X,1]),center=center,n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)))))
  
  return(Rates)
}

# mit Sprung

RejratesSprung1 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsSprung1(order,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


RejratesSprung2 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    rowSums(parallelSapply(Y, function(Y) as.numeric(TestsSprung2(order,rho=as.numeric(testgrid[X,1]),hhe=as.numeric(testgrid[X,2]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test])))/reps)
  Z=length(test)
  for(i in 1:Z){
    name=paste0("Rej",test[i],sep="")
    testgrid[,name]= Rates[i,]
  }
  return(testgrid)
}

# Wachsende Varianz


RejratesWVar <- function(reps, n, order,Var=n/10, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    colSums(t(parallelSapply(Y, function(Y) as.numeric(TestsWVar(order,center=center,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime))))/reps))
  testgrid$Rej= Rates
  return(testgrid)
  return(testgrid)
}

RejratesWVar2 <- function(reps, n, order, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsWVar(order,center=center,rho=as.numeric(testgrid[X,1]),Var=as.numeric(testgrid[X,2]),n=n,mean=mean,distr=distr,df=df,scale=scale,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][1]))/reps))
  testgrid$Rej= Rates
  return(testgrid)

}
# INAR

RejratesINAR <- function(reps, n, order,lambda, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsINAR(order,lambda=lambda,rho=as.numeric(testgrid[X]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}

# wechselnde Varianz

RejratesH <- function(reps, n, order,breakpointsd=2, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsH(order,breakpointsd=breakpointsd,rho=as.numeric(testgrid[X]),n=n,mean=mean,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# Saisonales Modell

RejratesS <- function(reps, n, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsS(season=as.numeric(testgrid[X,2]),rho=as.numeric(testgrid[X,1]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}


# Saisonales Modell 2

RejratesS2 <- function(reps, n, testgrid,a,b,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsS2(a=a,b=b,rho=as.numeric(testgrid[X,2]),rho2=as.numeric(testgrid[X,1]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=konto, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}

# AR2

Rejrates2 <- function(reps, n, order, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(Tests(order=order,rho=as.numeric(testgrid[X,]),center=center,mean=0,scale=scale,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}


# AR2 WVar

Rejrates2WVar <- function(reps, n, order, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsWVar(order=order,rho=as.numeric(testgrid[X,]),center=center,mean=0,scale=scale,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}


# AR2

Rejrates2Simp <- function(reps, n, order, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsSimp(order=order,rho=as.numeric(testgrid[X,]),center=center,mean=0,scale=scale,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}

#AR2 Drift

Rejrates2D <- function(reps, n, order, testgrid,center=FALSE,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsD(order=order,rho=as.numeric(testgrid[X,]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]])))/reps)
  testgrid$Rej= Rates
  return(testgrid)
}


# MA2

RejratesMA2 <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsMA(order=order,ma=as.numeric(testgrid[X,]),mean=0,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# ARMA

RejratesARMA <- function(reps, n, order, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsARMA(order=order,rho=as.numeric(testgrid[X,1]),ma=as.numeric(testgrid[X,2]),mean=0,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# GARCH

RejratesGARCH<- function(reps, n, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsGARCH(alpha=as.numeric(testgrid[X,1]),beta=as.numeric(testgrid[X,2]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]]))/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# ARCH

RejratesARCH<- function(reps, n, testgrid,distr= 'norm',loc=0,scale=1,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:length(testgrid))
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) TestsGARCH(alpha=as.numeric(testgrid[X]),beta=0,n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][[1]][2])/reps))
  testgrid$Rej= Rates
  return(testgrid)
}


# NL-Modell

RejratesNL<- function(reps, n, testgrid,distr= 'norm',loc=0,df=NULL,test,shockno=1,shockint=rnorm(1), shocktime=sample(1:n,shockno), kontno=1, kontint=rnorm(1), konttime=sample(1:n,kontno)){
  X=seq(1:dim(testgrid)[1])
  Y=seq(1:reps)
  Rates=parallelSapply(X, function(X) 
    sum(parallelSapply(Y, function(Y) as.numeric(TestsNL(alpha=as.numeric(testgrid[X,1]),beta=as.numeric(testgrid[X,2]),n=n,distr=distr,df=df,shockno=shockno,shockint=shockint, shocktime=shocktime,kontno=kontno, kontint=kontint, konttime=konttime)[test][1]))/reps))
  testgrid$Rej= Rates
  
  return(testgrid)
}



----------------------------------------------------------------------------------------------------------
########################################### AR(1) Simulationen ###########################################
----------------------------------------------------------------------------------------------------------


### Definieren des Gitters

Grid_AR1=expand.grid(mean=seq(-2,2,by=0.1),rho=seq(-0.99,0.99,by=0.01))

Grid_AR1_Simple= seq(-0.99,0.99, by=0.01)



----------------------------------------------------------------------------------------------------------
################################# Normalbedingungen ######################################################
----------------------------------------------------------------------------------------------------------


#### Alles

###n=20

AR1_20_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_20 = AR1_20_Simple$Rej[7:9,]
rownames(Gem_AR1_20)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Levelplot=levelplot(t(Gem_AR1_20),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
              
windows(width=10,height=7)                                                                                  
plot(AR1_20_Levelplot)
update(AR1_20_Levelplot, aspect=0.5)


###n=50

AR1_50_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_50 = AR1_50_Simple$Rej[7:9,]
rownames(Gem_AR1_50)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Levelplot=levelplot(t(Gem_AR1_50),ylab=NULL,colorkey=FALSE,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Levelplot)
update(AR1_50_Levelplot, aspect=0.5)


### n=100

AR1_100_Simple=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_100 = AR1_100_Simple$Rej[7:9,]
rownames(Gem_AR1_100)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Levelplot=levelplot(t(Gem_AR1_100),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Levelplot)
update(AR1_100_Levelplot, aspect=0.5)



### n=500

AR1_500_Simple=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_500 = AR1_500_Simple$Rej[7:9,]
rownames(Gem_AR1_500)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Levelplot=levelplot(t(Gem_AR1_500),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Levelplot)
update(AR1_500_Levelplot, aspect=0.5)



### Mehr Wiederholungen:


Grid_AR1_Simple_1000= seq(-0.9,0.9, by=0.1)


AR1_500_Simple_1000=Rejrates1(reps=1000, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple_1000)

Gem_AR1_500 = AR1_500_Simple_1000$Rej
rownames(Gem_AR1_500)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500) <- c(seq(-0.9,0.9,by=0.1))


AR1_500_Levelplot=levelplot(t(Gem_AR1_500),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(1,length(Grid_AR1_Simple_1000),by=1),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Levelplot)
update(AR1_500_Levelplot, aspect=0.5)




----------------------------------------------------------------------------------------------------------
  ################################# Einseitig ######################################################
----------------------------------------------------------------------------------------------------------
  
Grid_AR1_Simple_ES= seq(0,0.99,by=0.01)

###n=20

AR1_20_Simple_1S=RejratesES(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple_ES)

Gem_AR1_20_1S = AR1_20_Simple_1S$Rej
rownames(Gem_AR1_20_1S)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_1S) <- c(seq(0,0.99,by=0.01))


AR1_20_ES_Levelplot=levelplot(t(Gem_AR1_20_1S),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(1,length(Grid_AR1_Simple_ES),by=10),labels=(seq(0,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_ES_Levelplot)
update(AR1_20_ES_Levelplot, aspect=0.5)

###n=50

AR1_50_Simple_1S=RejratesES(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple_ES)

Gem_AR1_50_1S = AR1_50_Simple_1S$Rej
rownames(Gem_AR1_50_1S)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_1S) <- c(seq(0,0.99,by=0.01))


AR1_50_ES_Levelplot=levelplot(t(Gem_AR1_50_1S),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(1,length(Grid_AR1_Simple_ES),by=10),labels=(seq(0,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_ES_Levelplot)
update(AR1_50_ES_Levelplot, aspect=0.5)


### n=100


AR1_100_Simple_1S=RejratesES(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple_ES)

Gem_AR1_100_1S = AR1_100_Simple_1S$Rej
rownames(Gem_AR1_100_1S)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_1S) <- c(seq(0,0.99,by=0.01))


AR1_100_ES_Levelplot=levelplot(t(Gem_AR1_100_1S),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(1,length(Grid_AR1_Simple_ES),by=10),labels=(seq(0,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_ES_Levelplot)
update(AR1_100_ES_Levelplot, aspect=0.5)


###n=500

AR1_500_Simple_1S=RejratesES(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple_ES)

Gem_AR1_500_1S = AR1_500_Simple_1S$Rej
rownames(Gem_AR1_500_1S)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_1S) <- c(seq(0,0.99,by=0.01))


AR1_500_ES_Levelplot=levelplot(t(Gem_AR1_500_1S),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(1,length(Grid_AR1_Simple_ES),by=10),labels=(seq(0,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_ES_Levelplot)
update(AR1_500_ES_Levelplot, aspect=0.5)


----------------------------------------------------------------------------------------------------------
  ################################# Annahmebereich ######################################################
----------------------------------------------------------------------------------------------------------
  
### n=20

AR1_20_VZT_Asy=RejratesVZT(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_20_Asy = AR1_20_VZT_Asy$Rej[7:9,]
rownames(Gem_AR1_20_Asy)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_Asy) <- c(seq(-0.99,0.99,by=0.01)[-100])

AR1_20_Asy_Levelplot=levelplot(t(Gem_AR1_20_Asy), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))


###

AR1_20_Levelplot=levelplot(t(Gem_AR1_20), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Levelplot)
update(AR1_20_Levelplot, aspect=0.5)


print(AR1_20_Asy_Levelplot, split=c(1,1,1,2), more=TRUE)
print(AR1_20_Levelplot, split=c(1,2,1,2))


### n=50

AR1_50_VZT_Asy=RejratesVZT(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)


Gem_AR1_50_Asy = AR1_50_VZT_Asy$Rej[7:9,]
rownames(Gem_AR1_50_Asy)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_Asy) <- c(seq(-0.99,0.99,by=0.01))[-100]


AR1_50_Asy_Levelplot=levelplot(t(Gem_AR1_50_Asy), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
  

###

AR1_50_Levelplot=levelplot(t(Gem_AR1_50), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))


windows(width=10,height=7)      
grid.arrange(AR1_50_Levelplot,AR1_50_Asy_Levelplot)
plot(AR1_50_Asy_Levelplot)
update(AR1_50_Asy_Levelplot, aspect=0.5)


### n=100

AR1_100_VZT_Asy=RejratesVZT(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)



Gem_AR1_100_Asy = AR1_100_VZT_Asy$Rej[7:9,]
rownames(Gem_AR1_100_Asy)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_Asy) <- c(seq(-0.99,0.99,by=0.01)[-100])


AR1_100_Levelplot=levelplot(t(Gem_AR1_100), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

AR1_100_Asy_Levelplot=levelplot(t(Gem_AR1_100_Asy), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))


windows(width=10,height=7)                                                                                  
plot(AR1_100_Levelplot)
update(AR1_100_Levelplot, aspect=0.5)




### n=500

AR1_500_VZT_Asy=RejratesVZT(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_500_Asy = AR1_500_VZT_Asy$Rej[7:9,]
rownames(Gem_AR1_500_Asy)<- c('3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_Asy) <- c(seq(-0.99,0.99,by=0.01)[-100])


AR1_500_Asy_Levelplot=levelplot(t(Gem_AR1_500_Asy),aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.5),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

AR1_500_Levelplot=levelplot(t(Gem_AR1_500), aspect="fill",colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.5),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=30),labels=(c(-0.9,-0.6,-0.3,0,0.3,0.6,0.9)),cex=0.9),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Levelplot)
update(AR1_500_Levelplot, aspect=0.5)




##### Plots
trellis.device(windows, height=15, width=13)
grid.arrange(AR1_20_Levelplot,AR1_20_Asy_Levelplot,AR1_50_Levelplot,AR1_50_Asy_Levelplot,AR1_100_Levelplot,AR1_100_Asy_Levelplot,AR1_500_Asy_Levelplot,AR1_500_Levelplot, ncol=2)



trellis.device(windows, height=25, width=20)
print(AR1_20_Levelplot, split=c(1,1,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_20_Asy_Levelplot, split=c(2,1,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_50_Levelplot, split=c(1,2,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_50_Asy_Levelplot, split=c(2,2,2,4),
      panel.height=list(x=1.15, units="in"),more=TRUE)
print(AR1_100_Levelplot, split=c(1,3,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_100_Asy_Levelplot, split=c(2,3,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_500_Levelplot, split=c(1,4,2,4),
      panel.height=list(x=1.15, units="in"), more=TRUE)
print(AR1_500_Asy_Levelplot, split=c(2,4,2,4),
      panel.height=list(x=1.15, units="in"))


----------------------------------------------------------------------------------------------------------
  ################################# Wachsende Varianz ######################################################
#_________________________________________________________________________________________________________  
  
### n=20
  
AR1_20_WVar_DW_Simple=RejratesWVar(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_WVar_3VZ_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_WVar_4VZ_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_WVar_5VZ_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_WVar_Sign_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_WVar_DifRuns_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_WVar_TP_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_WVar_BDS_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_WVar_LB_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_WVar_VNR_Simple= Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')



### Heatmap-Plot

Gem_AR1_WVar_20 = cbind(AR1_20_WVar_DW_Simple$Rej,AR1_20_WVar_LB_Simple$Rej,AR1_20_WVar_BDS_Simple$Rej,AR1_20_WVar_Sign_Simple$Rej,AR1_20_WVar_TP_Simple$Rej,AR1_20_WVar_VNR_Simple$Rej,AR1_20_WVar_3VZ_Simple$Rej,AR1_20_WVar_4VZ_Simple$Rej,AR1_20_WVar_5VZ_Simple$Rej)
colnames(Gem_AR1_WVar_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_WVar_20) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)

levelplot(Gem_AR1_WVar_20,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Wachsende Varianz')



### n=500



AR1_500_WVar_DW_Simple=RejratesWVar(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_500_WVar_3VZ_Simple=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_500_WVar_4VZ_Simple=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_500_WVar_5VZ_Simple=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_500_WVar_Sign_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_500_WVar_DifRuns_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_500_WVar_TP_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_500_WVar_BDS_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_500_WVar_LB_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_500_WVar_VNR_Simple= Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')



### Heatmap-Plot

Gem_AR1_WVar_500 = cbind(AR1_500_WVar_DW_Simple$Rej,AR1_500_WVar_LB_Simple$Rej,AR1_500_WVar_BDS_Simple$Rej,AR1_500_WVar_Sign_Simple$Rej,AR1_500_WVar_TP_Simple$Rej,AR1_500_WVar_VNR_Simple$Rej,AR1_500_WVar_3VZ_Simple$Rej,AR1_500_WVar_4VZ_Simple$Rej,AR1_500_WVar_5VZ_Simple$Rej)
colnames(Gem_AR1_WVar_500)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_WVar_500) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)

levelplot(Gem_AR1_WVar_500,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Wachsende Varianz')









### Alles

###n=20

AR1_20_WVar=RejratesWVar(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_20_WVar = AR1_20_WVar$Rej
rownames(Gem_AR1_20_WVar)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_WVar) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_WVar_Levelplot=levelplot(t(Gem_AR1_20_WVar),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_WVar_Levelplot)
update(AR1_20_WVar_Levelplot, aspect=0.5)

###n=50

AR1_50_WVar=RejratesWVar(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_50_WVar = AR1_50_WVar$Rej
rownames(Gem_AR1_50_WVar)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_WVar) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_WVar_Levelplot=levelplot(t(Gem_AR1_50_WVar),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_WVar_Levelplot)
update(AR1_50_WVar_Levelplot, aspect=0.5)

###n=100

AR1_100_WVar=RejratesWVar(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_100_WVar = AR1_100_WVar$Rej
rownames(Gem_AR1_100_WVar)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_WVar) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_WVar_Levelplot=levelplot(t(Gem_AR1_100_WVar),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_WVar_Levelplot)
update(AR1_100_WVar_Levelplot, aspect=0.5)


###n=500

AR1_500_WVar=RejratesWVar(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_500_WVar = AR1_500_WVar$Rej
rownames(Gem_AR1_500_WVar)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_WVar) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_WVar_Levelplot=levelplot(t(Gem_AR1_500_WVar),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_WVar_Levelplot)
update(AR1_500_WVar_Levelplot, aspect=0.5)


### Fr BDS

Grid_WVar=as.data.frame(CJ(rho1=c(seq(-0.99,0.99,by=0.01)),hhe= c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.91,seq(5,50,by=1))))

AR1_500_WVar2_BDS=RejratesWVar2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_WVar, test='BDS')



AR1_500_WVar_Levelplot=levelplot(Rej ~ rho1*hhe,colorkey=list(labels=list(cex=1.3,font=2)),scales=list(x=list(font=2,at=seq(-1,1,by=0.2),cex=1.3),y=list(font=2,cex=1.3,at=c(1,seq(5,50,by=5)))),  data=AR1_500_WVar2_BDS,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=2),ylab=list(label='maximale Varianz',cex=2), at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_WVar_Levelplot)

### Fr LB

Grid_WVar=as.data.frame(CJ(rho1=c(seq(-0.99,0.99,by=0.01)),hhe= c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1,seq(5,50,by=1))))

AR1_500_WVar2_LB=RejratesWVar2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_WVar, test='Ljung-Box')



AR1_500_WVar_Levelplot_LB=levelplot(Rej ~ rho1*hhe,colorkey=list(labels=list(cex=1.3,font=2)),scales=list(x=list(font=2,at=seq(-1,1,by=0.2),cex=1.3),y=list(font=2,cex=1.3,at=c(1,seq(5,50,by=5)))),  data=AR1_500_WVar2_LB,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=2),ylab=list(label='maximale Varianz',cex=2), at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_WVar_Levelplot_LB)



#___________________________________________________________________________________________________________
############################### Mit Sprung der Hhe 1###################################################
#___________________________________________________________________________________________________________

Grid_AR1_Sprung= as.data.frame(CJ(rho1=seq(-0.99,0.99,by=0.01),hhe= seq(-2,2,by=0.1)))

### n=20

AR1_20_Sprung_DW=RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Durbin-Watson')

AR1_20_Sprung_3VZ=RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='3-VZ')

AR1_20_Sprung_4VZ=RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='4-VZ')

AR1_20_Sprung_5VZ=RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='5-VZ')

AR1_20_Sprung_Sign= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Runs')

AR1_20_Sprung_DifRuns= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='DifRuns')

AR1_20_Sprung_TP= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Turning-Point')

AR1_20_Sprung_BDS= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='BDS')

AR1_20_Sprung_LB= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Ljung-Box')

AR1_20_Sprung_VNR= RejratesSprung(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='VonNeumannRang')



### Heatmap-Plot

L_AR1_20_Sprung_DW=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_DW  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_LB=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_LB  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                      main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_BDS=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_BDS, pretty=T,layers=1,xlab="rho", ylab="hhe",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_Sign=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_Sign, pretty=T,layers=1,xlab="rho", ylab="hhe",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sprung_TP=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_TP  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                      main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_VNR=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_VNR  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                       main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_3VZ=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_3VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                       main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_4VZ=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_4VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                       main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sprung_5VZ=levelplot(Rej ~ rho1*hhe, data=AR1_20_Sprung_5VZ  ,pretty=T, layers=1,xlab="rho", ylab="hhe",
                       main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_20_Sprung_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sprung_5VZ,split = c(3, 3, 3, 3), more = FALSE)




### n=50



AR1_50_Sprung_DW=RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Durbin-Watson')

AR1_50_Sprung_3VZ=RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='3-VZ')

AR1_50_Sprung_4VZ=RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='4-VZ')

AR1_50_Sprung_5VZ=RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='5-VZ')

AR1_50_Sprung_Sign= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Runs')

AR1_50_Sprung_DifRuns= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='DifRuns')

AR1_50_Sprung_TP= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Turning-Point')

AR1_50_Sprung_BDS= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='BDS')

AR1_50_Sprung_LB= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Ljung-Box')

AR1_50_Sprung_VNR= RejratesSprung(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='VonNeumannRang')



### Heatmap-Plot

L_AR1_50_Sprung_DW=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_DW  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_LB=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_LB  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_BDS=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_BDS, pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_Sign=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_Sign, pretty=T,layers=1,xlab="rho", ylab="hhe",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_50_Sprung_TP=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_TP  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_VNR=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_VNR  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_3VZ=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_3VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_4VZ=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_4VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Sprung_5VZ=levelplot(Rej ~ rho1*hhe, data=AR1_50_Sprung_5VZ  ,pretty=T, layers=1,xlab="rho", ylab="hhe",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_50_Sprung_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_50_Sprung_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=100



AR1_100_Sprung_DW=RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Durbin-Watson')

AR1_100_Sprung_3VZ=RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='3-VZ')

AR1_100_Sprung_4VZ=RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='4-VZ')

AR1_100_Sprung_5VZ=RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='5-VZ')

AR1_100_Sprung_Sign= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Runs')

AR1_100_Sprung_DifRuns= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='DifRuns')

AR1_100_Sprung_TP= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Turning-Point')

AR1_100_Sprung_BDS= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='BDS')

AR1_100_Sprung_LB= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Ljung-Box')

AR1_100_Sprung_VNR= RejratesSprung(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='VonNeumannRang')



### Heatmap-Plot

L_AR1_100_Sprung_DW=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_DW  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_LB=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_LB  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_BDS=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_BDS, pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_Sign=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_Sign, pretty=T,layers=1,xlab="rho", ylab="hhe",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sprung_TP=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_TP  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_VNR=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_VNR  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_3VZ=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_3VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_4VZ=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_4VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sprung_5VZ=levelplot(Rej ~ rho1*hhe, data=AR1_100_Sprung_5VZ  ,pretty=T, layers=1,xlab="rho", ylab="hhe",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_100_Sprung_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sprung_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=500



AR1_500_Sprung_DW=RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Durbin-Watson')

AR1_500_Sprung_3VZ=RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='3-VZ')

AR1_500_Sprung_4VZ=RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='4-VZ')

AR1_500_Sprung_5VZ=RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='5-VZ')

AR1_500_Sprung_Sign= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Runs')

AR1_500_Sprung_DifRuns= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='DifRuns')

AR1_500_Sprung_TP= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Turning-Point')

AR1_500_Sprung_BDS= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='BDS')

AR1_500_Sprung_LB= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='Ljung-Box')

AR1_500_Sprung_VNR= RejratesSprung(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test='VonNeumannRang')



### Heatmap-Plot

L_AR1_500_Sprung_DW=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_DW  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_LB=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_LB  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_BDS=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_BDS, pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_Sign=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_Sign, pretty=T,layers=1,xlab="rho", ylab="hhe",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_500_Sprung_TP=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_TP  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_VNR=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_VNR  ,pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_3VZ=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_3VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_4VZ=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_4VZ  , pretty=T,layers=1,xlab="rho", ylab="hhe",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sprung_5VZ=levelplot(Rej ~ rho1*hhe, data=AR1_500_Sprung_5VZ  ,pretty=T, layers=1,xlab="rho", ylab="hhe",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_500_Sprung_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_500_Sprung_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### Alles
### n=20
AR1_20_Sprung=RejratesSprung1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_20_Sprung = AR1_20_Sprung$Rej
rownames(Gem_AR1_20_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Sprung_Levelplot=levelplot(t(Gem_AR1_20_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Sprung_Levelplot)
update(AR1_20_Sprung_Levelplot, aspect=0.5)


###n=50
AR1_50_Sprung=RejratesSprung1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_50_Sprung = AR1_50_Sprung$Rej
rownames(Gem_AR1_50_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Sprung_Levelplot=levelplot(t(Gem_AR1_50_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Sprung_Levelplot)
update(AR1_50_Sprung_Levelplot, aspect=0.5)

###n=100

AR1_100_Sprung=RejratesSprung1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_100_Sprung = AR1_100_Sprung$Rej
rownames(Gem_AR1_100_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Sprung_Levelplot=levelplot(t(Gem_AR1_100_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Sprung_Levelplot)
update(AR1_100_Sprung_Levelplot, aspect=0.5)


###n=500
AR1_500_Sprung=RejratesSprung1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_500_Sprung = AR1_500_Sprung$Rej
rownames(Gem_AR1_500_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Sprung_Levelplot=levelplot(t(Gem_AR1_500_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Sprung_Levelplot)
update(AR1_500_Sprung_Levelplot, aspect=0.5)





##### Spezielle

AR1_500_Sprung_5VZ=RejratesSprung2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test="5-VZ")
L_AR1_500_5VZ=levelplot(Rej ~ rho1*hhe,colorkey=list(labels=list(cex=1.3,font=2)),scales=list(x=list(font=2,at=seq(-1,1,by=0.2),cex=1.3),y=list(font=2,cex=1.3,at=seq(-2,2,by=0.5))),  data=AR1_500_Sprung_5VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=2),ylab=list(label='Sprunghhe',cex=2), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_5VZ)


AR1_500_Sprung_BDS=RejratesSprung2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test="BDS")
L_AR1_20_BDS=levelplot(Rej ~ rho1*hhe,colorkey=list(labels=list(cex=1.3,font=2)),scales=list(x=list(font=2,at=seq(-1,1,by=0.2),cex=1.3),y=list(font=2,cex=1.3,at=seq(-2,2,by=0.5))),  data=AR1_500_Sprung_BDS,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=2),ylab=list(label='Sprunghhe',cex=2), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_20_BDS)


AR1_500_Sprung_LB=RejratesSprung2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test="Ljung-Box")
L_AR1_500_Sprung_LB=levelplot(Rej ~ rho1*hhe,colorkey=list(labels=list(cex=1.3,font=2)),scales=list(x=list(font=2,at=seq(-1,1,by=0.2),cex=1.3),y=list(font=2,cex=1.3,at=seq(-2,2,by=0.5))),  data=AR1_500_Sprung_LB,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=2),ylab=list(label='Sprunghhe',cex=2), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_Sprung_LB)




-----------------------------------------------------------------------------------------------------------
  ############################################### Mit Drift ###############################################
#___________________________________________________________________________________________________________-

Grid_AR1_Drift=as.data.frame(CJ(rho=seq(-0.99,0.99,by=0.01),drift= seq(-2,2,by=0.1)))


### Alles
###n=20

AR1_20_Drift=RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_20_Drift = AR1_20_Drift$Rej
rownames(Gem_AR1_20_Drift)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_Drift) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Drift_Levelplot=levelplot(t(Gem_AR1_20_Drift),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Drift_Levelplot)
update(AR1_20_Drift_Levelplot, aspect=0.5)

###n=50

AR1_50_Drift=RejratesD(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_50_Drift = AR1_50_Drift$Rej
rownames(Gem_AR1_50_Drift)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_Drift) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Drift_Levelplot=levelplot(t(Gem_AR1_50_Drift),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Drift_Levelplot)
update(AR1_50_Drift_Levelplot, aspect=0.5)


###n=100

AR1_100_Drift=RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_100_Drift = AR1_100_Drift$Rej
rownames(Gem_AR1_100_Drift)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_Drift) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Drift_Levelplot=levelplot(t(Gem_AR1_100_Drift),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Drift_Levelplot)
update(AR1_100_Drift_Levelplot, aspect=0.5)


###n=500

AR1_500_Drift=RejratesD(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_500_Drift = AR1_500_Drift$Rej
rownames(Gem_AR1_500_Drift)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_Drift) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Drift_Levelplot=levelplot(t(Gem_AR1_500_Drift),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Drift_Levelplot)
update(AR1_500_Drift_Levelplot, aspect=0.5)


### Spezielle
AR1_500_Drift_5VZ=RejratesD2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Drift, test="5-VZ")
AR1_500_Drift_5VZ_Sel=AR1_500_Drift_5VZ[which(abs(AR1_500_Drift_5VZ$drift)<=2),]
L_AR1_500_5VZ=levelplot(Rej ~ rho*drift,scales=list(x=list(font=2,at=seq(-0.9,0.9,by=0.1),cex=1),y=list(font=2,cex=1,at=seq(-2,2,by=0.5),labels=seq(-2,2,by=0.5)/500)),  data=AR1_500_Drift_5VZ_Sel,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_5VZ)


### LB
AR1_500_Drift_LB=RejratesD2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Drift, test="Ljung-Box")
AR1_500_Drift_LB_Sel=AR1_500_Drift_LB[which(abs(AR1_500_Drift_LB$drift)<=2),]
L_AR1_500_LB=levelplot(Rej ~ rho*drift,scales=list(x=list(font=2,at=seq(-0.9,0.9,by=0.1),cex=1),y=list(font=2,cex=1,at=seq(-2,2,by=0.5),labels=seq(-2,2,by=0.5)/500)),  data=AR1_500_Drift_LB_Sel,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_LB)



-----------------------------------------------------------------------------------------------------------
  ############################### Mit 5% Zufallsschock der Intensitt 5 #####################################
#___________________________________________________________________________________________________________-


#### n=20

AR1_20_S5.5=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=1, shockint=5)

Gem_AR1_20_S5.5 = AR1_20_S5.5$Rej
rownames(Gem_AR1_20_S5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S5.5_Levelplot=levelplot(t(Gem_AR1_20_S5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S5.5_Levelplot)
update(AR1_20_S5.5_Levelplot, aspect=0.5)



#### n=50

AR1_50_S5.5=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=3, shockint=5)

Gem_AR1_50_S5.5 = AR1_50_S5.5$Rej
rownames(Gem_AR1_50_S5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_S5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_S5.5_Levelplot=levelplot(t(Gem_AR1_50_S5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_S5.5_Levelplot)
update(AR1_50_S5.5_Levelplot, aspect=0.5)



#### n=100

AR1_100_S5.5=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=5, shockint=5)

Gem_AR1_100_S5.5 = AR1_100_S5.5$Rej
rownames(Gem_AR1_100_S5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_S5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_S5.5_Levelplot=levelplot(t(Gem_AR1_100_S5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_S5.5_Levelplot)
update(AR1_100_S5.5_Levelplot, aspect=0.5)



#### n=500

AR1_500_S5.5=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=25, shockint=5)

Gem_AR1_500_S5.5 = AR1_500_S5.5$Rej
rownames(Gem_AR1_500_S5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_S5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_S5.5_Levelplot=levelplot(t(Gem_AR1_500_S5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_S5.5_Levelplot)
update(AR1_500_S5.5_Levelplot, aspect=0.5)

-----------------------------------------------------------------------------------------------------------
############################### Mit 5% Zufallsschock der Intensitt 10 #####################################
#___________________________________________________________________________________________________________-
  

#### n=20

AR1_20_S20.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=4, shockint=10)

Gem_AR1_20_S20.10 = AR1_20_S20.10$Rej
rownames(Gem_AR1_20_S20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S20.10_Levelplot=levelplot(t(Gem_AR1_20_S20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S20.10_Levelplot)
update(AR1_20_S20.10_Levelplot, aspect=0.5)



#### n=50

AR1_50_S5.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=3, shockint=10)

Gem_AR1_50_S5.10 = AR1_50_S5.10$Rej
rownames(Gem_AR1_50_S5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_S5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_S5.10_Levelplot=levelplot(t(Gem_AR1_50_S5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_S5.10_Levelplot)
update(AR1_50_S5.10_Levelplot, aspect=0.5)



#### n=100

AR1_100_S20.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=20, shockint=10)

Gem_AR1_100_S20.10 = AR1_100_S20.10$Rej
rownames(Gem_AR1_100_S20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_S20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_S20.10_Levelplot=levelplot(t(Gem_AR1_100_S20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_S20.10_Levelplot)
update(AR1_100_S20.10_Levelplot, aspect=0.5)



#### n=500

AR1_500_S5.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=25, shockint=10)

Gem_AR1_500_S5.10 = AR1_500_S5.10$Rej
rownames(Gem_AR1_500_S5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_S5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_S5.10_Levelplot=levelplot(t(Gem_AR1_500_S5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_S5.10_Levelplot)
update(AR1_500_S5.10_Levelplot, aspect=0.5)

####
AR1_20_S10.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=2, shockint=10)

AR1_50_S10.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=5, shockint=10)

AR1_100_S10.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=10, shockint=10)

AR1_500_S10.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=50, shockint=10)


####
AR1_20_S20.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=4, shockint=10)

AR1_50_S20.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=10, shockint=10)

AR1_100_S20.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=20, shockint=10)

AR1_500_S20.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=100, shockint=10)



Gem_AR1_20_S20.10 = AR1_20_S20.10$Rej
rownames(Gem_AR1_20_S20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S20.10_Levelplot=levelplot(t(Gem_AR1_20_S20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S20.10_Levelplot)
update(AR1_20_S20.10_Levelplot, aspect=0.5)

###### Vereinfacht

AR1_20_DW_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson', shockint=10)

AR1_20_LB_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box', shockint=10)

AR1_20_Sign_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs', shockint=10)

AR1_20_TP_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point', shockint=10)

AR1_20_BDS_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS', shockint=10)

AR1_20_VNR_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang', shockint=10)

AR1_20_3VZ_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ', shockint=10)

AR1_20_4VZ_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ', shockint=10)

AR1_20_5VZ_S1.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ', shockint=10)


#### Heatmap Plots



L_AR1_20_DW_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_DW_S1.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_LB_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_LB_S1.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_BDS_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_BDS_S1.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="BDS",col.regions=magma, at=seq(0,1,by=0.01), at= seq(0,1, by=0.05))

L_AR1_20_Sign_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_Sign_S1.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_TP_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_TP_S1.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_VNR_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_VNR_S1.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_3VZ_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_3VZ_S1.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_4VZ_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_4VZ_S1.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_5VZ_S1.10=levelplot(Rej ~ mean*rho, data=AR1_20_5VZ_S1.10  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



print(L_AR1_20_DW_S1.10, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_LB_S1.10, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_BDS_S1.10, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sign_S1.10,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_TP_S1.10, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_VNR_S1.10, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_3VZ_S1.10, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_4VZ_S1.10, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_5VZ_S1.10,split = c(3, 3, 3, 3), more = FALSE)




##### Vereinfachter Plot

Gem_AR1_20_S1.10 = cbind(AR1_20_DW_S1.10_Simple$Rej,AR1_20_LB_S1.10_Simple$Rej,AR1_20_BDS_S1.10_Simple$Rej,AR1_20_Sign_S1.10_Simple$Rej,AR1_20_TP_S1.10_Simple$Rej,AR1_20_VNR_S1.10_Simple$Rej,AR1_20_3VZ_S1.10_Simple$Rej,AR1_20_4VZ_S1.10_Simple$Rej,AR1_20_5VZ_S1.10_Simple$Rej)
colnames(Gem_AR1_20_S1.10)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_S1.10) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_S1.10,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Schock der Intensitt 10')



###n=20 

AR1_20_Sprung=RejratesSprung1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_20_Sprung = AR1_20_Sprung$Rej
rownames(Gem_AR1_20_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Levelplot_Sprung=levelplot(t(Gem_AR1_20_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Levelplot_Sprung)
update(AR1_20_Levelplot_Sprung, aspect=0.5)


###n=50 

AR1_50_Sprung=RejratesSprung1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_50_Sprung = AR1_50_Sprung$Rej
rownames(Gem_AR1_50_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Levelplot_Sprung=levelplot(t(Gem_AR1_50_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Levelplot_Sprung)
update(AR1_50_Levelplot_Sprung, aspect=0.5)

###n=100 

AR1_100_Sprung=RejratesSprung1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_100_Sprung = AR1_100_Sprung$Rej
rownames(Gem_AR1_100_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Levelplot_Sprung=levelplot(t(Gem_AR1_100_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Levelplot_Sprung)
update(AR1_100_Levelplot_Sprung, aspect=0.5)

###n=500 

AR1_500_Sprung=RejratesSprung1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_500_Sprung = AR1_500_Sprung$Rej
rownames(Gem_AR1_500_Sprung)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_Sprung) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Levelplot_Sprung=levelplot(t(Gem_AR1_500_Sprung),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Levelplot_Sprung)
update(AR1_500_Levelplot_Sprung, aspect=0.5)


#### Speziell:

AR1_500_Sprung_5VZ=
  
  
  
  
  -----------------------------------------------------------------------------------------------------------
  ############################### Mit 5% Zufallsschock der Intensitt 20 #####################################
#___________________________________________________________________________________________________________-


#### n=20

AR1_20_S5.20=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=1, shockint=20)

Gem_AR1_20_S5.20 = AR1_20_S5.20$Rej
rownames(Gem_AR1_20_S5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S5.20_Levelplot=levelplot(t(Gem_AR1_20_S5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S5.20_Levelplot)
update(AR1_20_S5.20_Levelplot, aspect=0.5)



#### n=50

AR1_50_S5.20=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=3, shockint=20)

Gem_AR1_50_S5.20 = AR1_50_S5.20$Rej
rownames(Gem_AR1_50_S5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_S5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_S5.20_Levelplot=levelplot(t(Gem_AR1_50_S5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_S5.20_Levelplot)
update(AR1_50_S5.20_Levelplot, aspect=0.5)



#### n=100

AR1_100_S5.20=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=5, shockint=20)

Gem_AR1_100_S5.20 = AR1_100_S5.20$Rej
rownames(Gem_AR1_100_S5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_S5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_S5.20_Levelplot=levelplot(t(Gem_AR1_100_S5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_S5.20_Levelplot)
update(AR1_100_S5.20_Levelplot, aspect=0.5)



#### n=500

AR1_500_S5.20=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=25, shockint=20)

Gem_AR1_500_S5.20 = AR1_500_S5.20$Rej
rownames(Gem_AR1_500_S5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_S5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_S5.20_Levelplot=levelplot(t(Gem_AR1_500_S5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_S5.20_Levelplot)
update(AR1_500_S5.20_Levelplot, aspect=0.5)
  
  
  -----------------------------------------------------------------------------------------------------------
  ############################### Mit 5% Zufallsschock der Intensitt 50 #####################################
#___________________________________________________________________________________________________________-


#### n=20

AR1_20_S5.50=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=1, shockint=50)

Gem_AR1_20_S5.50 = AR1_20_S5.50$Rej
rownames(Gem_AR1_20_S5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S5.50_Levelplot=levelplot(t(Gem_AR1_20_S5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S5.50_Levelplot)
update(AR1_20_S5.50_Levelplot, aspect=0.5)



#### n=50

AR1_50_S5.50=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=3, shockint=50)

Gem_AR1_50_S5.50 = AR1_50_S5.50$Rej
rownames(Gem_AR1_50_S5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_S5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_S5.50_Levelplot=levelplot(t(Gem_AR1_50_S5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_S5.50_Levelplot)
update(AR1_50_S5.50_Levelplot, aspect=0.5)



#### n=100

AR1_100_S5.50=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=5, shockint=50)

Gem_AR1_100_S5.50 = AR1_100_S5.50$Rej
rownames(Gem_AR1_100_S5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_S5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_S5.50_Levelplot=levelplot(t(Gem_AR1_100_S5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_S5.50_Levelplot)
update(AR1_100_S5.50_Levelplot, aspect=0.5)



#### n=500

AR1_500_S5.50=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=25, shockint=50)

Gem_AR1_500_S5.50 = AR1_500_S5.50$Rej
rownames(Gem_AR1_500_S5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_S5.50) <- c(seq(-0.99,0.99,by=0.01))[-100]


AR1_500_S5.50_Levelplot=levelplot(t(Gem_AR1_500_S5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_S5.50_Levelplot)
update(AR1_500_S5.50_Levelplot, aspect=0.5)


-----------------------------------------------------------------------------------------------------------
  ############################### Mit 5% Zufallsschock der Intensitt 100 #####################################
#___________________________________________________________________________________________________________-


#### n=20

AR1_20_S5.100=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=1, shockint=100)

Gem_AR1_20_S5.100 = AR1_20_S5.100$Rej
rownames(Gem_AR1_20_S5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_S5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_S5.100_Levelplot=levelplot(t(Gem_AR1_20_S5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_S5.100_Levelplot)
update(AR1_20_S5.100_Levelplot, aspect=0.5)



#### n=50

AR1_50_S5.100=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=3, shockint=100)

Gem_AR1_50_S5.100 = AR1_50_S5.100$Rej
rownames(Gem_AR1_50_S5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_S5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_S5.100_Levelplot=levelplot(t(Gem_AR1_50_S5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_S5.100_Levelplot)
update(AR1_50_S5.100_Levelplot, aspect=0.5)



#### n=100

AR1_100_S5.100=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=5, shockint=100)

Gem_AR1_100_S5.100 = AR1_100_S5.100$Rej
rownames(Gem_AR1_100_S5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_S5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_S5.100_Levelplot=levelplot(t(Gem_AR1_100_S5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_S5.100_Levelplot)
update(AR1_100_S5.100_Levelplot, aspect=0.5)



#### n=500

AR1_500_S5.100=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,shockno=25, shockint=100)

Gem_AR1_500_S5.100 = AR1_500_S5.100$Rej
rownames(Gem_AR1_500_S5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_S5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_S5.100_Levelplot=levelplot(t(Gem_AR1_500_S5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_S5.100_Levelplot)
update(AR1_500_S5.100_Levelplot, aspect=0.5)


-----------------------------------------------------------------------------------------------------------
################################### Mit 3 Zufallschocks der Intensitt 10 #################################
-----------------------------------------------------------------------------------------------------------
  
AR1_20_DW_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson', shockint=10, shockno=3)

AR1_20_LB_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box', shockint=10, shockno=3)

AR1_20_Sign_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Runs', shockint=10, shockno=3)

AR1_20_TP_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point', shockint=10, shockno=3)

AR1_20_BDS_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='BDS', shockint=10, shockno=3)

AR1_20_VNR_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang', shockint=10, shockno=3)

AR1_20_3VZ_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ', shockint=10, shockno=3)

AR1_20_4VZ_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ', shockint=10, shockno=3)

AR1_20_5VZ_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ', shockint=10, shockno=3)


###### Vereinfacht


### n=20

AR1_20_DW_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson', shockint=10, shockno=3)

AR1_20_LB_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box', shockint=10, shockno=3)

AR1_20_Sign_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs', shockint=10, shockno=3)

AR1_20_TP_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point', shockint=10, shockno=3)

AR1_20_BDS_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS', shockint=10, shockno=3)

AR1_20_VNR_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang', shockint=10, shockno=3)

AR1_20_3VZ_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ', shockint=10, shockno=3)

AR1_20_4VZ_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ', shockint=10, shockno=3)

AR1_20_5VZ_S3.10_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ', shockint=10, shockno=3)


### n=50

AR1_50_DW_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson', shockint=10, shockno=3)

AR1_50_LB_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box', shockint=10, shockno=3)

AR1_50_Sign_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs', shockint=10, shockno=3)

AR1_50_TP_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point', shockint=10, shockno=3)

AR1_50_BDS_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS', shockint=10, shockno=3)

AR1_50_VNR_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang', shockint=10, shockno=3)

AR1_50_3VZ_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ', shockint=10, shockno=3)

AR1_50_4VZ_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ', shockint=10, shockno=3)

AR1_50_5VZ_S3.10_Simple=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ', shockint=10, shockno=3)



#### Heatmap Plots



L_AR1_20_DW_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_DW_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_LB_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_LB_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_BDS_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_BDS_S3.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="BDS",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sign_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_Sign_S3.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_TP_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_TP_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_VNR_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_VNR_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_3VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_3VZ_S3.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_4VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_4VZ_S3.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_5VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_5VZ_S3.10  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_20_DW_S3.10, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_LB_S3.10, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_BDS_S3.10, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sign_S3.10,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_TP_S3.10, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_VNR_S3.10, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_3VZ_S3.10, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_4VZ_S3.10, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_5VZ_S3.10,split = c(3, 3, 3, 3), more = FALSE)


########## Vereinfacht

### n=20

Gem_AR1_20_S3.10 = cbind(AR1_20_DW_S3.10_Simple$Rej,AR1_20_LB_S3.10_Simple$Rej,AR1_20_BDS_S3.10_Simple$Rej,AR1_20_Sign_S3.10_Simple$Rej,AR1_20_TP_S3.10_Simple$Rej,AR1_20_VNR_S3.10_Simple$Rej,AR1_20_3VZ_S3.10_Simple$Rej,AR1_20_4VZ_S3.10_Simple$Rej,AR1_20_5VZ_S3.10_Simple$Rej)
colnames(Gem_AR1_20_S3.10)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_S3.10) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_S3.10,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='3 Schocks der Intensitt 10')


### n=50

Gem_AR1_50_S3.10 = cbind(AR1_50_DW_S3.10_Simple$Rej,AR1_50_LB_S3.10_Simple$Rej,AR1_50_BDS_S3.10_Simple$Rej,AR1_50_Sign_S3.10_Simple$Rej,AR1_50_TP_S3.10_Simple$Rej,AR1_50_VNR_S3.10_Simple$Rej,AR1_50_3VZ_S3.10_Simple$Rej,AR1_50_4VZ_S3.10_Simple$Rej,AR1_50_5VZ_S3.10_Simple$Rej)
colnames(Gem_AR1_50_S3.10)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_50_S3.10) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_50_S3.10,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='3 Schocks der Intensitt 10')



-----------------------------------------------------------------------------------------------------------
################################# Mit einem Zufallsschock der Intensitt 30 ###############################
-----------------------------------------------------------------------------------------------------------

AR1_20_DW_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson', shockint=30)

AR1_20_LB_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box', shockint=30)

AR1_20_Sign_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Runs', shockint=30)

AR1_20_TP_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point', shockint=30)

AR1_20_BDS_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='BDS', shockint=30)

AR1_20_VNR_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang', shockint=30)

AR1_20_3VZ_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ', shockint=30)

AR1_20_4VZ_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ', shockint=30)

AR1_20_5VZ_S1.30=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ', shockint=30)


#### Vereinfacht

AR1_20_DW_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson', shockint=30)

AR1_20_LB_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box', shockint=30)

AR1_20_Sign_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs', shockint=30)

AR1_20_TP_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point', shockint=30)

AR1_20_BDS_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS', shockint=30)

AR1_20_VNR_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang', shockint=30)

AR1_20_3VZ_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ', shockint=30)

AR1_20_4VZ_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ', shockint=30)

AR1_20_5VZ_S1.30_Simple=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ', shockint=30)


#### Heatmap Plots

L_AR1_20_DW_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_DW_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_LB_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_LB_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_BDS_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_BDS_S3.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="BDS",col.regions=magma,  at= seq(0,1, by=0.01))

L_AR1_20_Sign_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_Sign_S3.10, pretty=T,layers=1,xlab="mean", ylab="rho",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_TP_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_TP_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_VNR_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_VNR_S3.10  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_3VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_3VZ_S3.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_4VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_4VZ_S3.10  , pretty=T,layers=1,xlab="mean", ylab="rho",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_5VZ_S3.10=levelplot(Rej ~ mean*rho, data=AR1_20_5VZ_S3.10  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_20_DW_S3.10, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_LB_S3.10, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_BDS_S3.10, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sign_S3.10,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_TP_S3.10, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_VNR_S3.10, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_3VZ_S3.10, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_4VZ_S3.10, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_5VZ_S3.10,split = c(3, 3, 3, 3), more = FALSE)


#### Vereinfacht

Gem_AR1_20_S1.30 = cbind(AR1_20_DW_S1.30_Simple$Rej,AR1_20_LB_S1.30_Simple$Rej,AR1_20_BDS_S1.30_Simple$Rej,AR1_20_Sign_S1.30_Simple$Rej,AR1_20_TP_S1.30_Simple$Rej,AR1_20_VNR_S1.30_Simple$Rej,AR1_20_3VZ_S1.30_Simple$Rej,AR1_20_4VZ_S1.30_Simple$Rej,AR1_20_5VZ_S1.30_Simple$Rej)
colnames(Gem_AR1_20_S1.30)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_S1.30) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_S1.30,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='1 Schock der Intensitt 30')



------------------------------------------------------------------------------------------------------------
##################################### Mit 5% Kontamination der Strke 10 ################################
------------------------------------------------------------------------------------------------------------

###n=20

AR1_20_K5.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=1, kontint=10)

Gem_AR1_20_K5.10 = AR1_20_K5.10$Rej
rownames(Gem_AR1_20_K5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K5.10_Levelplot=levelplot(t(Gem_AR1_20_K5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K5.10_Levelplot)
update(AR1_20_K5.10_Levelplot, aspect=0.5)


###n=50
AR1_50_K5.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=3, kontint=10)

Gem_AR1_50_K5.10 = AR1_50_K5.10$Rej
rownames(Gem_AR1_50_K5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K5.10_Levelplot=levelplot(t(Gem_AR1_50_K5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K5.10_Levelplot)
update(AR1_50_K5.10_Levelplot, aspect=0.5)


###n=100
AR1_100_K5.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=10)

Gem_AR1_100_K5.10 = AR1_100_K5.10$Rej
rownames(Gem_AR1_100_K5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K5.10_Levelplot=levelplot(t(Gem_AR1_100_K5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K5.10_Levelplot)
update(AR1_100_K5.10_Levelplot, aspect=0.5)


###n=500
AR1_500_K5.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=25, kontint=10)

Gem_AR1_500_K5.10 = AR1_500_K5.10$Rej
rownames(Gem_AR1_500_K5.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K5.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K5.10_Levelplot=levelplot(t(Gem_AR1_500_K5.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K5.10_Levelplot)
update(AR1_500_K5.10_Levelplot, aspect=0.5)



------------------------------------------------------------------------------------------------------------
  ##################################### Mit 10% Kontamination der Strke 10 ################################
------------------------------------------------------------------------------------------------------------
  
###n=20
  
AR1_20_K10.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=2, kontint=10, konttime= sample(1:20,2))

Gem_AR1_20_K10.10 = AR1_20_K10.10$Rej
rownames(Gem_AR1_20_K10.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K10.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K10.10_Levelplot=levelplot(t(Gem_AR1_20_K10.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K10.10_Levelplot)
update(AR1_20_K10.10_Levelplot, aspect=0.5)


###n=50
AR1_50_K10.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=10)

Gem_AR1_50_K10.10 = AR1_50_K10.10$Rej
rownames(Gem_AR1_50_K10.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K10.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K10.10_Levelplot=levelplot(t(Gem_AR1_50_K10.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K10.10_Levelplot)
update(AR1_50_K10.10_Levelplot, aspect=0.5)


###n=100
AR1_100_K10.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=10, kontint=10)

Gem_AR1_100_K10.10 = AR1_100_K10.10$Rej
rownames(Gem_AR1_100_K10.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K10.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K10.10_Levelplot=levelplot(t(Gem_AR1_100_K10.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K10.10_Levelplot)
update(AR1_100_K10.10_Levelplot, aspect=0.5)


###n=500
AR1_500_K10.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=50, kontint=10)

Gem_AR1_500_K10.10 = AR1_500_K10.10$Rej
rownames(Gem_AR1_500_K10.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K10.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K10.10_Levelplot=levelplot(t(Gem_AR1_500_K10.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K10.10_Levelplot)
update(AR1_500_K10.10_Levelplot, aspect=0.5)



------------------------------------------------------------------------------------------------------------
  ##################################### Mit 20% Kontamination der Strke 10 ################################
------------------------------------------------------------------------------------------------------------
  
 ###n=20
  
AR1_20_K20.10=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=4, kontint=10)

Gem_AR1_20_K20.10 = AR1_20_K20.10$Rej
rownames(Gem_AR1_20_K20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K20.10_Levelplot=levelplot(t(Gem_AR1_20_K20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K20.10_Levelplot)
update(AR1_20_K20.10_Levelplot, aspect=0.5)


###n=50
AR1_50_K20.10=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=10, kontint=10)

Gem_AR1_50_K20.10 = AR1_50_K20.10$Rej
rownames(Gem_AR1_50_K20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K20.10_Levelplot=levelplot(t(Gem_AR1_50_K20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K20.10_Levelplot)
update(AR1_50_K20.10_Levelplot, aspect=0.5)


###n=100
AR1_100_K20.10=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=20, kontint=10)

Gem_AR1_100_K20.10 = AR1_100_K20.10$Rej
rownames(Gem_AR1_100_K20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K20.10_Levelplot=levelplot(t(Gem_AR1_100_K20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K20.10_Levelplot)
update(AR1_100_K20.10_Levelplot, aspect=0.5)


###n=500
AR1_500_K20.10=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=100, kontint=10)

Gem_AR1_500_K20.10 = AR1_500_K20.10$Rej
rownames(Gem_AR1_500_K20.10)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K20.10) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K20.10_Levelplot=levelplot(t(Gem_AR1_500_K20.10),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K20.10_Levelplot)
update(AR1_500_K20.10_Levelplot, aspect=0.5)


------------------------------------------------------------------------------------------------------------
  ##################################### Mit 5% Kontamination der Strke 5 ################################
------------------------------------------------------------------------------------------------------------
  
  ###n=20
  
  AR1_20_K5.5=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=1, kontint=5, konttime= sample(1:20,2))

Gem_AR1_20_K5.5 = AR1_20_K5.5$Rej
rownames(Gem_AR1_20_K5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K5.5_Levelplot=levelplot(t(Gem_AR1_20_K5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K5.5_Levelplot)
update(AR1_20_K5.5_Levelplot, aspect=0.5)


###n=50
AR1_50_K5.5=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=3, kontint=5)

Gem_AR1_50_K5.5 = AR1_50_K5.5$Rej
rownames(Gem_AR1_50_K5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K5.5_Levelplot=levelplot(t(Gem_AR1_50_K5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K5.5_Levelplot)
update(AR1_50_K5.5_Levelplot, aspect=0.5)


###n=100
AR1_100_K5.5=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=5)

Gem_AR1_100_K5.5 = AR1_100_K5.5$Rej
rownames(Gem_AR1_100_K5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K5.5_Levelplot=levelplot(t(Gem_AR1_100_K5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K5.5_Levelplot)
update(AR1_100_K5.5_Levelplot, aspect=0.5)


###n=500
AR1_500_K5.5=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=25, kontint=5)

Gem_AR1_500_K5.5 = AR1_500_K5.5$Rej
rownames(Gem_AR1_500_K5.5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K5.5) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K5.5_Levelplot=levelplot(t(Gem_AR1_500_K5.5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K5.5_Levelplot)
update(AR1_500_K5.5_Levelplot, aspect=0.5)


------------------------------------------------------------------------------------------------------------
  ##################################### Mit 5% Kontamination der Strke 50 ################################
------------------------------------------------------------------------------------------------------------
  
###n=20
  
 AR1_20_K5.50=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=1, kontint=50, konttime= sample(1:20,2))

Gem_AR1_20_K5.50 = AR1_20_K5.50$Rej
rownames(Gem_AR1_20_K5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K5.50_Levelplot=levelplot(t(Gem_AR1_20_K5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K5.50_Levelplot)
update(AR1_20_K5.50_Levelplot, aspect=0.5)


###n=50
AR1_50_K5.50=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=3, kontint=50)

Gem_AR1_50_K5.50 = AR1_50_K5.50$Rej
rownames(Gem_AR1_50_K5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K5.50_Levelplot=levelplot(t(Gem_AR1_50_K5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K5.50_Levelplot)
update(AR1_50_K5.50_Levelplot, aspect=0.5)


###n=100
AR1_100_K5.50=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=50)

Gem_AR1_100_K5.50 = AR1_100_K5.50$Rej
rownames(Gem_AR1_100_K5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K5.50_Levelplot=levelplot(t(Gem_AR1_100_K5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K5.50_Levelplot)
update(AR1_100_K5.50_Levelplot, aspect=0.5)


###n=500
AR1_500_K5.50=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=25, kontint=50)

Gem_AR1_500_K5.50 = AR1_500_K5.50$Rej
rownames(Gem_AR1_500_K5.50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K5.50) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K5.50_Levelplot=levelplot(t(Gem_AR1_500_K5.50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K5.50_Levelplot)
update(AR1_500_K5.50_Levelplot, aspect=0.5)



------------------------------------------------------------------------------------------------------------
  ##################################### Mit 5% Kontamination der Strke 20 ################################
------------------------------------------------------------------------------------------------------------
  
  ###n=20
  
  AR1_20_K5.20=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=1, kontint=20, konttime= sample(1:20,2))

Gem_AR1_20_K5.20 = AR1_20_K5.20$Rej
rownames(Gem_AR1_20_K5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K5.20_Levelplot=levelplot(t(Gem_AR1_20_K5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K5.20_Levelplot)
update(AR1_20_K5.20_Levelplot, aspect=0.5)


###n=50
AR1_50_K5.20=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=3, kontint=20)

Gem_AR1_50_K5.20 = AR1_50_K5.20$Rej
rownames(Gem_AR1_50_K5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K5.20_Levelplot=levelplot(t(Gem_AR1_50_K5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K5.20_Levelplot)
update(AR1_50_K5.20_Levelplot, aspect=0.5)


###n=100
AR1_100_K5.20=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=20)

Gem_AR1_100_K5.20 = AR1_100_K5.20$Rej
rownames(Gem_AR1_100_K5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K5.20_Levelplot=levelplot(t(Gem_AR1_100_K5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K5.20_Levelplot)
update(AR1_100_K5.20_Levelplot, aspect=0.5)


###n=500
AR1_500_K5.20=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=25, kontint=20)

Gem_AR1_500_K5.20 = AR1_500_K5.20$Rej
rownames(Gem_AR1_500_K5.20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K5.20) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K5.20_Levelplot=levelplot(t(Gem_AR1_500_K5.20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K5.20_Levelplot)
update(AR1_500_K5.20_Levelplot, aspect=0.5)


------------------------------------------------------------------------------------------------------------
  ##################################### Mit 5% Kontamination der Strke 100 ################################
------------------------------------------------------------------------------------------------------------
  
  ###n=20
  
  AR1_20_K5.100=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=1, kontint=100, konttime= sample(1:20,2))

Gem_AR1_20_K5.100 = AR1_20_K5.100$Rej
rownames(Gem_AR1_20_K5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_K5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_K5.100_Levelplot=levelplot(t(Gem_AR1_20_K5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_K5.100_Levelplot)
update(AR1_20_K5.100_Levelplot, aspect=0.5)


###n=50
AR1_50_K5.100=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=3, kontint=100)

Gem_AR1_50_K5.100 = AR1_50_K5.100$Rej
rownames(Gem_AR1_50_K5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_K5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_K5.100_Levelplot=levelplot(t(Gem_AR1_50_K5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_K5.100_Levelplot)
update(AR1_50_K5.100_Levelplot, aspect=0.5)


###n=100
AR1_100_K5.100=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=5, kontint=100)

Gem_AR1_100_K5.100 = AR1_100_K5.100$Rej
rownames(Gem_AR1_100_K5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_K5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_K5.100_Levelplot=levelplot(t(Gem_AR1_100_K5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_K5.100_Levelplot)
update(AR1_100_K5.100_Levelplot, aspect=0.5)


###n=500
AR1_500_K5.100=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,kontno=25, kontint=100)

Gem_AR1_500_K5.100 = AR1_500_K5.100$Rej
rownames(Gem_AR1_500_K5.100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_K5.100) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_K5.100_Levelplot=levelplot(t(Gem_AR1_500_K5.100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_K5.100_Levelplot)
update(AR1_500_K5.100_Levelplot, aspect=0.5)

-----------------------------------------------------------------------------------------------------------
  ################################ Mit t-verteilten Innovationen mit df=5 ###################################
-----------------------------------------------------------------------------------------------------------
  
AR1_20_t5_DW=Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson')

AR1_20_t5_3VZ=Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ')

AR1_20_t5_4VZ=Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ')

AR1_20_t5_5VZ=Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ')

AR1_20_t5_Sign= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='Runs')

AR1_20_t5_DifRuns= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='DifRuns')

AR1_20_t5_TP= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point')

AR1_20_t5_BDS= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='BDS')

AR1_20_t5_LB= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box')

AR1_20_t5_VNR= Rejrates(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang')





########### Heatmap Plots


L_AR1_20_t5_DW=levelplot(Rej ~ mean*rho, data=AR1_20_t5_DW  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_LB=levelplot(Rej ~ mean*rho, data=AR1_20_t5_LB  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_BDS=levelplot(Rej ~ mean*rho, data=AR1_20_t5_BDS, pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="BDS",col.regions=magma,  at= seq(0,1, by=0.05))

L_AR1_20_t5_Sign=levelplot(Rej ~ mean*rho, data=AR1_20_t5_Sign, pretty=T,layers=1,xlab="mean", ylab="rho",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_TP=levelplot(Rej ~ mean*rho, data=AR1_20_t5_TP  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_VNR=levelplot(Rej ~ mean*rho, data=AR1_20_t5_VNR  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_3VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t5_3VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_4VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t5_4VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t5_5VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t5_5VZ  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                          main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



print(L_AR1_20_t5_DW, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_t5_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_t5_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_t5_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_t5_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_t5_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_t5_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_t5_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_t5_5VZ,split = c(3, 3, 3, 3), more = FALSE)

#### Vereinfacht

AR1_20_t5_DW_Simple=Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_t5_3VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_t5_4VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_t5_5VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_t5_Sign_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_t5_DifRuns_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_t5_TP_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_t5_BDS_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_t5_LB_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_t5_VNR_Simple= Rejrates1(reps=100, n=20,distr='t',df=5,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')


### Vereinfacht

Gem_AR1_20_t5 = cbind(AR1_20_t5_DW_Simple$Rej,AR1_20_t5_LB_Simple$Rej,AR1_20_t5_BDS_Simple$Rej,AR1_20_t5_Sign_Simple$Rej,AR1_20_t5_TP_Simple$Rej,AR1_20_t5_VNR_Simple$Rej,AR1_20_t5_3VZ_Simple$Rej,AR1_20_t5_4VZ_Simple$Rej,AR1_20_t5_5VZ_Simple$Rej)
colnames(Gem_AR1_20_t5)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_t5) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_t5,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Innovationen mit t-verteilung (df=5)')



###Alles

### n=20

AR1_20_t5=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=5)

Gem_AR1_20_t5 = AR1_20_t5$Rej
rownames(Gem_AR1_20_t5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_t5) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_t5_Levelplot=levelplot(t(Gem_AR1_20_t5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_t5_Levelplot)
update(AR1_20_t5_Levelplot, aspect=0.5)



### n=50

AR1_50_t5=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=5)

Gem_AR1_50_t5 = AR1_50_t5$Rej
rownames(Gem_AR1_50_t5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_t5) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_t5_Levelplot=levelplot(t(Gem_AR1_50_t5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_t5_Levelplot)
update(AR1_50_t5_Levelplot, aspect=0.5)



### n=100

AR1_100_t5=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=5)

Gem_AR1_100_t5 = AR1_100_t5$Rej
rownames(Gem_AR1_100_t5)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_t5) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_t5_Levelplot=levelplot(t(Gem_AR1_100_t5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_t5_Levelplot)
update(AR1_100_t5_Levelplot, aspect=0.5)



### n=500

AR1_500_t5=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=5)

Gem_AR1_500_t5 = AR1_500_t5$Rej
rownames(Gem_AR1_500_t5)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_t5) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_t5_Levelplot=levelplot(t(Gem_AR1_500_t5),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_t5_Levelplot)
update(AR1_500_t5_Levelplot, aspect=0.5)

----------------------------------------------------------------------------------------------------------
####################### Mit Cauchy-verteilten Innovationen (t-Verteilung df=1) ###########################
----------------------------------------------------------------------------------------------------------

AR1_20_t_DW=Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson')

AR1_20_t_3VZ=Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ')

AR1_20_t_4VZ=Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ')

AR1_20_t_5VZ=Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ')

AR1_20_t_Sign= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='Runs')

AR1_20_t_DifRuns= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='DifRuns')

AR1_20_t_TP= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point')

AR1_20_g_BDS= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='BDS')

AR1_20_g_LB= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box')

AR1_20_t_VNR= Rejrates(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang')



#### Vereinfacht

AR1_20_t_DW_Simple=Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_t_3VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_t_4VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_t_5VZ_Simple=Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_t_Sign_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_t_DifRuns_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_t_TP_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_t_BDS_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_t_LB_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_t_VNR_Simple= Rejrates1(reps=100, n=20,distr='t',df=1,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')




##### Heatmap Plots

L_AR1_20_t_DW=levelplot(Rej ~ mean*rho, data=AR1_20_t_DW  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_LB=levelplot(Rej ~ mean*rho, data=AR1_20_t_LB  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_BDS=levelplot(Rej ~ mean*rho, data=AR1_20_t_BDS, pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="BDS",col.regions=magma,  at= seq(0,1, by=0.05))

L_AR1_20_t_Sign=levelplot(Rej ~ mean*rho, data=AR1_20_t_Sign, pretty=T,layers=1,xlab="mean", ylab="rho",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_TP=levelplot(Rej ~ mean*rho, data=AR1_20_t_TP  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_VNR=levelplot(Rej ~ mean*rho, data=AR1_20_t_VNR  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_3VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t_3VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_4VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t_4VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_t_5VZ=levelplot(Rej ~ mean*rho, data=AR1_20_t_5VZ  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                          main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



print(L_AR1_20_t_DW, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_t_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_t_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_t_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_t_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_t_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_t_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_t_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_t_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### Vereinfacht 

Gem_AR1_20_t = cbind(AR1_20_t_DW_Simple$Rej,AR1_20_t_LB_Simple$Rej,AR1_20_t_BDS_Simple$Rej,AR1_20_t_Sign_Simple$Rej,AR1_20_t_TP_Simple$Rej,AR1_20_t_VNR_Simple$Rej,AR1_20_t_3VZ_Simple$Rej,AR1_20_t_4VZ_Simple$Rej,AR1_20_t_5VZ_Simple$Rej)
colnames(Gem_AR1_20_t)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_t) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_t,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Innovationen mit Cauchy-verteilung (df=1)')




### Alles

### n=20

AR1_20_t1=Rejrates1(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=1)

Gem_AR1_20_t1 = AR1_20_t1$Rej
rownames(Gem_AR1_20_t1)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','1-VZ')
colnames(Gem_AR1_20_t1) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_t1_Levelplot=levelplot(t(Gem_AR1_20_t1),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.01))

windows(width=10,height=7)                                                                                  
plot(AR1_20_t1_Levelplot)
update(AR1_20_t1_Levelplot, aspect=0.1)



### n=50

AR1_50_t1=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=1)

Gem_AR1_50_t1 = AR1_50_t1$Rej
rownames(Gem_AR1_50_t1)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_t1) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_t1_Levelplot=levelplot(t(Gem_AR1_50_t1),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_t1_Levelplot)
update(AR1_50_t1_Levelplot, aspect=0.5)



### n=100

AR1_100_t1=Rejrates1(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=1)

Gem_AR1_100_t1 = AR1_100_t1$Rej
rownames(Gem_AR1_100_t1)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','1-VZ')
colnames(Gem_AR1_100_t1) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_t1_Levelplot=levelplot(t(Gem_AR1_100_t1),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.01))

windows(width=10,height=7)                                                                                  
plot(AR1_100_t1_Levelplot)
update(AR1_100_t1_Levelplot, aspect=0.1)



### n=500

AR1_500_t1=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='t',df=1)

Gem_AR1_500_t1 = AR1_500_t1$Rej
rownames(Gem_AR1_500_t1)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_t1) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_t1_Levelplot=levelplot(t(Gem_AR1_500_t1),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_t1_Levelplot)
update(AR1_500_t1_Levelplot, aspect=0.5)


---------------------------------------------------------------------------------------------------------
############################### Mit gumbel-verteilte Innovationen mit scale=3 ###########################
---------------------------------------------------------------------------------------------------------
  
AR1_20_g_DW=Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson')

AR1_20_g_3VZ=Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ')

AR1_20_g_4VZ=Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ')

AR1_20_g_5VZ=Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ')

AR1_20_g_Sign= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Runs')

AR1_20_g_DifRuns= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='DifRuns')

AR1_20_g_TP= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point')

AR1_20_g_BDS= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='BDS')

AR1_20_g_LB= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box')

AR1_20_g_VNR= Rejrates(reps=100, n=20,distr='gumbel',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang')



#### Vereinfacht

AR1_20_g_DW_Simple=Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_g_3VZ_Simple=Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_g_4VZ_Simple=Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_g_5VZ_Simple=Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_g_Sign_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_g_DifRuns_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_g_TP_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_g_BDS_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_g_LB_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_g_VNR_Simple= Rejrates1(reps=100, n=20,distr='gumbel',order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')



##### Heatmap Plots

L_AR2_20_g_DW=levelplot(Rej ~ mean*rho, data=AR1_20_g_DW  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_LB=levelplot(Rej ~ mean*rho, data=AR1_20_g_LB  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                        main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_BDS=levelplot(Rej ~ mean*rho, data=AR1_20_g_BDS, pretty=T,layers=1,xlab="mean", ylab="rho",
                        main="BDS",col.regions=magma,  at= seq(0,1, by=0.05))

L_AR1_20_g_Sign=levelplot(Rej ~ mean*rho, data=AR1_20_g_Sign, pretty=T,layers=1,xlab="mean", ylab="rho",
                          main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_TP=levelplot(Rej ~ mean*rho, data=AR1_20_g_TP  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                        main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_VNR=levelplot(Rej ~ mean*rho, data=AR1_20_g_VNR  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_3VZ=levelplot(Rej ~ mean*rho, data=AR1_20_g_3VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_4VZ=levelplot(Rej ~ mean*rho, data=AR1_20_g_4VZ  , pretty=T,layers=1,xlab="mean", ylab="rho",
                         main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_g_5VZ=levelplot(Rej ~ mean*rho, data=AR1_20_g_5VZ  ,pretty=T, layers=1,xlab="mean", ylab="rho",
                         main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



print(L_AR1_20_g_DW, split = c(1, 1, 3,3), more = TRUE)
print(L_AR1_20_g_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_g_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_g_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_g_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_g_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_g_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_g_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_g_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### Vereinfacht 

Gem_AR1_20_g = cbind(AR1_20_g_DW_Simple$Rej,AR1_20_g_LB_Simple$Rej,AR1_20_g_BDS_Simple$Rej,AR1_20_g_Sign_Simple$Rej,AR1_20_g_TP_Simple$Rej,AR1_20_g_VNR_Simple$Rej,AR1_20_g_3VZ_Simple$Rej,AR1_20_g_4VZ_Simple$Rej,AR1_20_g_5VZ_Simple$Rej)
colnames(Gem_AR1_20_g)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_g) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_g,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Innovationen mit Gumbel-verteilung (scale=2)')



### Alles


### n=20

AR1_20_gumbel=Rejrates1(reps=100,center=TRUE, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='gumbel',scale=2)

Gem_AR1_20_gumbel = AR1_20_gumbel$Rej
rownames(Gem_AR1_20_gumbel)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_20_gumbel) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_gumbel_Levelplot=levelplot(t(Gem_AR1_20_gumbel),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_gumbel_Levelplot)
update(AR1_20_gumbel_Levelplot, aspect=0.5)


### n=50

AR1_50_gumbel=Rejrates1(reps=100, n=50,center=TRUE,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='gumbel',scale=3)

Gem_AR1_50_gumbel = AR1_50_gumbel$Rej
rownames(Gem_AR1_50_gumbel)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_gumbel) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_gumbel_Levelplot=levelplot(t(Gem_AR1_50_gumbel),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_gumbel_Levelplot)
update(AR1_50_gumbel_Levelplot, aspect=0.5)


###n=100

AR1_100_gumbel=Rejrates1(reps=100, n=100,center=TRUE,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='gumbel',scale=3)

Gem_AR1_100_gumbel = AR1_100_gumbel$Rej
rownames(Gem_AR1_100_gumbel)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_100_gumbel) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_gumbel_Levelplot=levelplot(t(Gem_AR1_100_gumbel),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_gumbel_Levelplot)
update(AR1_100_gumbel_Levelplot, aspect=0.5)


### n=500

AR1_500_gumbel=Rejrates1(reps=100, n=500,order=c(1,0,0),center=TRUE,testgrid= Grid_AR1_Simple,distr='gumbel',scale=3)

Gem_AR1_500_gumbel = AR1_500_gumbel$Rej
rownames(Gem_AR1_500_gumbel)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_gumbel) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_gumbel_Levelplot=levelplot(t(Gem_AR1_500_gumbel),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_gumbel_Levelplot)
update(AR1_500_gumbel_Levelplot, aspect=0.5)

----------------------------------------------------------------------------------------------------------
################ Mit doppeltexponential-verteilten Innovationen  mit scale=2 #############################
----------------------------------------------------------------------------------------------------------

AR1_20_dexp_DW=Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson')

AR1_20_dexp_3VZ=Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='3-VZ')

AR1_20_dexp_4VZ=Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='4-VZ')

AR1_20_dexp_5VZ=Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='5-VZ')

AR1_20_dexp_Sign= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Runs')

AR1_20_dexp_DifRuns= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='DifRuns')

AR1_20_dexp_TP= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Turning-Point')

AR1_20_dexp_BDS= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='BDS')

AR1_20_dexp_LB= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='Ljung-Box')

AR1_20_dexp_VNR= Rejrates(reps=100, n=20,distr='dexp',scale=2,order=c(1,0,0),testgrid= Grid_AR1, test='VonNeumannRang')


### Heatmap Plots

L_AR1_20_dexp_DW=levelplot(Rej ~ mean*rho, data=AR1_20_dexp_DW  ,pretty=T,layers=1,xlab="mean", ylab="rho",
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))





### Alles

### n=50

AR1_50_dexp=Rejrates1(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='dexp',scale=2)

Gem_AR1_50_dexp = AR1_50_dexp$Rej
rownames(Gem_AR1_50_dexp)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_50_dexp) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_dexp_Levelplot=levelplot(t(Gem_AR1_50_dexp),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_dexp_Levelplot)
update(AR1_50_dexp_Levelplot, aspect=0.5)

### n=500

AR1_500_dexp=Rejrates1(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple,distr='dexp',scale=2)

Gem_AR1_500_dexp = AR1_500_dexp$Rej
rownames(Gem_AR1_500_dexp)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_AR1_500_dexp) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_dexp_Levelplot=levelplot(t(Gem_AR1_500_dexp),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_dexp_Levelplot)
update(AR1_500_dexp_Levelplot, aspect=0.5)

#_________________________________________________________________________________________________________
######################################### MA(1) - Simulationen ###########################################
#_________________________________________________________________________________________________________
  
Grid_MA= seq(-5,5,by=0.1)

###Alles

###n=20
Ma1_20=RejratesMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_20 = Ma1_20$Rej
rownames(Gem_Ma1_20)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_Ma1_20) <- seq(-5,5,by=0.1)


Gem_Ma1_20_Levelplot=levelplot(t(Gem_Ma1_20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_20_Levelplot)
update(Gem_Ma1_20_Levelplot, aspect=0.5)


###n=50
Ma1_50=RejratesMA(reps=100, n=50,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_50 = Ma1_50$Rej
rownames(Gem_Ma1_50)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_Ma1_50) <- seq(-5,5,by=0.1)


Gem_Ma1_50_Levelplot=levelplot(t(Gem_Ma1_50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_50_Levelplot)
update(Gem_Ma1_50_Levelplot, aspect=0.5)


###n=100
Ma1_100=RejratesMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_100 = Ma1_100$Rej
rownames(Gem_Ma1_100)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_Ma1_100) <- seq(-5,5,by=0.1)


Gem_Ma1_100_Levelplot=levelplot(t(Gem_Ma1_100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_100_Levelplot)
update(Gem_Ma1_100_Levelplot, aspect=0.5)


###n=500
Ma1_500=RejratesMA(reps=100, n=500,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_500 = Ma1_500$Rej
rownames(Gem_Ma1_500)<- c('Durbin-Watson','Von-Neumann', 'BDS', 'Ljung-Box', 'Runs','Turning-Point','3-VZ','4-VZ','5-VZ')
colnames(Gem_Ma1_500) <- seq(-5,5,by=0.1)


Gem_Ma1_500_Levelplot=levelplot(t(Gem_Ma1_500),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_500_Levelplot)
update(Gem_Ma1_500_Levelplot, aspect=0.5)


#_________________________________________________________________________________________________________
######################################### Mit Gumbel-verteilten Innovationen ###########################################
#_________________________________________________________________________________________________________

### n=100


MA1_100_g_DW_Simple=RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='Durbin-Watson')

MA1_100_g_3VZ_Simple=RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='3-VZ')

MA1_100_g_4VZ_Simple=RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='4-VZ')

MA1_100_g_5VZ_Simple=RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='5-VZ')

MA1_100_g_Sign_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='Runs')

MA1_100_g_DifRuns_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='DifRuns')

MA1_100_g_TP_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='Turning-Point')

MA1_100_g_BDS_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='BDS')

MA1_100_g_LB_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='Ljung-Box')

MA1_100_g_VNR_Simple= RejratesMA(reps=100, n=100,distr='gumbel',scale=2,order=c(0,0,1),testgrid= Grid_MA, test='VonNeumannRang')


#Heatmap-Plots


Gem_MA1_100 = cbind(MA1_100_g_DW_Simple$Rej,MA1_100_g_LB_Simple$Rej,MA1_100_g_BDS_Simple$Rej,MA1_100_g_Sign_Simple$Rej,MA1_100_g_TP_Simple$Rej,MA1_100_g_VNR_Simple$Rej,MA1_100_g_3VZ_Simple$Rej,MA1_100_g_4VZ_Simple$Rej,MA1_100_g_5VZ_Simple$Rej)
colnames(Gem_MA1_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_MA1_100) <- round(seq(-2,2,by=0.1),digits=1)


levelplot(Gem_MA1_100,pretty=T,col.regions=magma,xlab="phi", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen MA(1)')



###Alles
Ma1_20=RejratesMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_MA)




#_________________________________________________________________________________________________________
######################################### Mit Oszillationen ###########################################
#_________________________________________________________________________________________________________

Grid_Osz= as.data.frame(CJ(rho=c(-0.99,seq(-0.95,0.95,by=0.05),0.99),Amp= seq(-4,4,by=0.25)))


### n=20

AR1_Osz_20_DW=RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')

AR1_Osz_20_3VZ=RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')

AR1_Osz_20_4VZ=RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')

AR1_Osz_20_5VZ=RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')

AR1_Osz_20_Sign= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')

AR1_Osz_20_DifRuns= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='DifRuns')

AR1_Osz_20_TP= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')

AR1_Osz_20_BDS= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')

AR1_Osz_20_LB= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')

AR1_Osz_20_VNR= RejratesO(reps=100, n=20,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')




L_AR1_Osz_20_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                       main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                       main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                       main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                        main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                      main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                      main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_20_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz_20_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                       main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz_20_DW,L_AR1_Osz_20_LB,L_AR1_Osz_20_BDS,L_AR1_Osz_20_Sign,L_AR1_Osz_20_TP,L_AR1_Osz_20_VNR,L_AR1_Osz_20_3VZ,L_AR1_Osz_20_4VZ,L_AR1_Osz_20_5VZ,ncol=3)


### n=50

AR1_Osz_50_DW=RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')

AR1_Osz_50_3VZ=RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')

AR1_Osz_50_4VZ=RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')

AR1_Osz_50_5VZ=RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')

AR1_Osz_50_Sign= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')

AR1_Osz_50_DifRuns= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='DifRuns')

AR1_Osz_50_TP= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')

AR1_Osz_50_BDS= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')

AR1_Osz_50_LB= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')

AR1_Osz_50_VNR= RejratesO(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')





L_AR1_Osz_50_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                            main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_50_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz_50_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz_50_DW,L_AR1_Osz_50_LB,L_AR1_Osz_50_BDS,L_AR1_Osz_50_Sign,L_AR1_Osz_50_TP,L_AR1_Osz_50_VNR,L_AR1_Osz_50_3VZ,L_AR1_Osz_50_4VZ,L_AR1_Osz_50_5VZ,ncol=3)



### n=100

AR1_Osz_100_DW=RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')

AR1_Osz_100_3VZ=RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')

AR1_Osz_100_4VZ=RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')

AR1_Osz_100_5VZ=RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')

AR1_Osz_100_Sign= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')

AR1_Osz_100_DifRuns= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='DifRuns')

AR1_Osz_100_TP= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')

AR1_Osz_100_BDS= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')

AR1_Osz_100_LB= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')

AR1_Osz_100_VNR= RejratesO(reps=100, n=100,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')




L_AR1_Osz_100_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                            main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_100_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz_100_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz_100_DW,L_AR1_Osz_100_LB,L_AR1_Osz_100_BDS,L_AR1_Osz_100_Sign,L_AR1_Osz_100_TP,L_AR1_Osz_100_VNR,L_AR1_Osz_100_3VZ,L_AR1_Osz_100_4VZ,L_AR1_Osz_100_5VZ,ncol=3)


### n=500

AR1_Osz_500_DW=RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')

AR1_Osz_500_3VZ=RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')

AR1_Osz_500_4VZ=RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')

AR1_Osz_500_5VZ=RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')

AR1_Osz_500_Sign= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')

AR1_Osz_500_DifRuns= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='DifRuns')

AR1_Osz_500_TP= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')

AR1_Osz_500_BDS= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')

AR1_Osz_500_LB= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')

AR1_Osz_500_VNR= RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')



L_AR1_Osz_500_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                            main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz_500_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz_500_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz_500_DW,L_AR1_Osz_500_LB,L_AR1_Osz_500_BDS,L_AR1_Osz_500_Sign,L_AR1_Osz_500_TP,L_AR1_Osz_500_VNR,L_AR1_Osz_500_3VZ,L_AR1_Osz_500_4VZ,L_AR1_Osz_500_5VZ,ncol=3)

############################# ndernde Periode



###n=50



AR1_Osz2_50_DW=RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')
colnames(AR1_Osz2_50_DW)[3]="Rej"

AR1_Osz2_50_3VZ=RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')
colnames(AR1_Osz2_50_3VZ)[3]="Rej"

AR1_Osz2_50_4VZ=RejratesO2(reps=5, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')
colnames(AR1_Osz2_50_4VZ)[3]="Rej"

AR1_Osz2_50_5VZ=RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')
colnames(AR1_Osz2_50_5VZ)[3]="Rej"

AR1_Osz2_50_Sign= RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')
colnames(AR1_Osz2_50_Sign)[3]="Rej"

AR1_Osz2_50_TP= RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')
colnames(AR1_Osz2_50_TP)[3]="Rej"

AR1_Osz2_50_BDS= RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')
colnames(AR1_Osz2_50_BDS)[3]="Rej"

AR1_Osz2_50_LB= RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')
colnames(AR1_Osz2_50_LB)[3]="Rej"

AR1_Osz2_50_VNR= RejratesO2(reps=100, n=50,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')
colnames(AR1_Osz2_50_VNR)[3]="Rej"


L_AR1_Osz2_50_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                            main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_50_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_50_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz2_50_DW,L_AR1_Osz2_50_LB,L_AR1_Osz2_50_BDS,L_AR1_Osz2_50_Sign,L_AR1_Osz2_50_TP,L_AR1_Osz2_50_VNR,L_AR1_Osz2_50_3VZ,L_AR1_Osz2_50_4VZ,L_AR1_Osz2_50_5VZ,ncol=3)


###n=500

AR1_Osz2_500_DW=RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Durbin-Watson')

AR1_Osz2_500_3VZ=RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='3-VZ')

AR1_Osz2_500_4VZ=RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='4-VZ')

AR1_Osz2_500_5VZ=RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='5-VZ')

AR1_Osz2_500_Sign= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Runs')

AR1_Osz2_500_DifRuns= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='DifRuns')

AR1_Osz2_500_TP= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Turning-Point')

AR1_Osz2_500_BDS= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='BDS')

AR1_Osz2_500_LB= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='Ljung-Box')

AR1_Osz2_500_VNR= RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test='VonNeumannRang')



L_AR1_Osz2_500_DW=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_3VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_4VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_5VZ=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_Sign=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                            main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_TP=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_BDS=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_LB=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                          main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_Osz2_500_VNR=levelplot(Rej ~ rho*Amp, data=AR1_Osz2_500_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}}$'),cex=1.3), ylab=list(label="Amplitude",cex=1.3),colorkey=FALSE,
                           main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_Osz2_500_DW,L_AR1_Osz2_500_LB,L_AR1_Osz2_500_BDS,L_AR1_Osz2_500_Sign,L_AR1_Osz2_500_TP,L_AR1_Osz2_500_VNR,L_AR1_Osz2_500_3VZ,L_AR1_Osz2_500_4VZ,L_AR1_Osz2_500_5VZ,ncol=3)



#_________________________________________________________________________________________________________
######################################### MA(2) - Simulationen ###########################################
#_________________________________________________________________________________________________________


Grid_MA2= as.data.frame(CJ(rho1=seq(-2,2,by=0.1),rho2= seq(-2,2,by=0.1)))

### n=20

MA2_20_DW=RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='Durbin-Watson')

MA2_20_3VZ=RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='3-VZ')

MA2_20_4VZ=RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='4-VZ')

MA2_20_5VZ=RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='5-VZ')

MA2_20_Sign= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='Runs')

MA2_20_DifRuns= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='DifRuns')

MA2_20_TP= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='Turning-Point')

MA2_20_BDS= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='BDS')

MA2_20_LB= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='Ljung-Box')

MA2_20_VNR= RejratesMA2(reps=100, n=20,order=c(0,0,2),testgrid= Grid_MA2, test='VonNeumannRang')


### 

L_MA2_20_DW=levelplot(Rej ~ rho1*rho2, data=MA2_20_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_3VZ=levelplot(Rej ~ rho1*rho2, data=MA2_20_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_4VZ=levelplot(Rej ~ rho1*rho2, data=MA2_20_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_5VZ=levelplot(Rej ~ rho1*rho2, data=MA2_20_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_Sign=levelplot(Rej ~ rho1*rho2, data=MA2_20_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_DifRuns=levelplot(Rej ~ rho1*rho2, data=MA2_20_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_TP=levelplot(Rej ~ rho1*rho2, data=MA2_20_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_BDS=levelplot(Rej ~ rho1*rho2, data=MA2_20_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_LB=levelplot(Rej ~ rho1*rho2, data=MA2_20_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_20_VNR=levelplot(Rej ~ rho1*rho2, data=MA2_20_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))



### n=50

MA2_50_DW=RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='Durbin-Watson')

MA2_50_3VZ=RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='3-VZ')

MA2_50_4VZ=RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='4-VZ')

MA2_50_5VZ=RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='5-VZ')

MA2_50_Sign= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='Runs')

MA2_50_DifRuns= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='DifRuns')

MA2_50_TP= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='Turning-Point')

MA2_50_BDS= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='BDS')

MA2_50_LB= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='Ljung-Box')

MA2_50_VNR= RejratesMA2(reps=100, n=50,order=c(0,0,2),testgrid= Grid_MA2, test='VonNeumannRang')

### 

L_MA2_50_DW=levelplot(Rej ~ rho1*rho2, data=MA2_50_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_3VZ=levelplot(Rej ~ rho1*rho2, data=MA2_50_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_4VZ=levelplot(Rej ~ rho1*rho2, data=MA2_50_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_5VZ=levelplot(Rej ~ rho1*rho2, data=MA2_50_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_Sign=levelplot(Rej ~ rho1*rho2, data=MA2_50_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_DifRuns=levelplot(Rej ~ rho1*rho2, data=MA2_50_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_TP=levelplot(Rej ~ rho1*rho2, data=MA2_50_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_BDS=levelplot(Rej ~ rho1*rho2, data=MA2_50_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_LB=levelplot(Rej ~ rho1*rho2, data=MA2_50_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_50_VNR=levelplot(Rej ~ rho1*rho2, data=MA2_50_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


### n=100

MA2_100_DW=RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='Durbin-Watson')

MA2_100_3VZ=RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='3-VZ')

MA2_100_4VZ=RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='4-VZ')

MA2_100_5VZ=RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='5-VZ')

MA2_100_Sign= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='Runs')

MA2_100_DifRuns= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='DifRuns')

MA2_100_TP= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='Turning-Point')

MA2_100_BDS= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='BDS')

MA2_100_LB= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='Ljung-Box')

MA2_100_VNR= RejratesMA2(reps=100, n=100,order=c(0,0,2),testgrid= Grid_MA2, test='VonNeumannRang')

### 

L_MA2_100_DW=levelplot(Rej ~ rho1*rho2, data=MA2_100_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_3VZ=levelplot(Rej ~ rho1*rho2, data=MA2_100_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_4VZ=levelplot(Rej ~ rho1*rho2, data=MA2_100_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_5VZ=levelplot(Rej ~ rho1*rho2, data=MA2_100_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_Sign=levelplot(Rej ~ rho1*rho2, data=MA2_100_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_DifRuns=levelplot(Rej ~ rho1*rho2, data=MA2_100_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_TP=levelplot(Rej ~ rho1*rho2, data=MA2_100_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_BDS=levelplot(Rej ~ rho1*rho2, data=MA2_100_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_LB=levelplot(Rej ~ rho1*rho2, data=MA2_100_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_MA2_100_VNR=levelplot(Rej ~ rho1*rho2, data=MA2_100_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))



#### Heatmap-Plots

### n=20

print(L_MA2_20_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_MA2_20_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_MA2_20_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_MA2_20_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_MA2_20_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_MA2_20_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_MA2_20_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_MA2_20_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_MA2_20_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=50

print(L_MA2_50_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_MA2_50_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_MA2_50_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_MA2_50_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_MA2_50_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_MA2_50_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_MA2_50_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_MA2_50_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_MA2_50_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=100

print(L_MA2_100_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_MA2_100_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_MA2_100_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_MA2_100_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_MA2_100_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_MA2_100_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_MA2_100_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_MA2_100_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_MA2_100_5VZ,split = c(3, 3, 3, 3), more = FALSE)



#_________________________________________________________________________________________________________
######################################### ARMA Simulationen ############################################
#_________________________________________________________________________________________________________


Grid_ARMA= as.data.frame(CJ(rho1=c(-0.99,seq(-0.9,0.9,by=0.1),0.99),rho2= seq(-2,2,by=0.1)))


### n=20

ARMA_20_DW=RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='Durbin-Watson')

ARMA_20_3VZ=RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='3-VZ')

ARMA_20_4VZ=RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='4-VZ')

ARMA_20_5VZ=RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='5-VZ')

ARMA_20_Sign= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='Runs')

ARMA_20_DifRuns= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='DifRuns')

ARMA_20_TP= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='Turning-Point')

ARMA_20_BDS= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='BDS')

ARMA_20_LB= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='Ljung-Box')

ARMA_20_VNR= RejratesARMA(reps=100, n=20,order=c(1,0,1),testgrid= Grid_ARMA, test='VonNeumannRang')

###

L_ARMA_20_DW=levelplot(Rej ~ rho1*rho2, data=ARMA_20_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_3VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_20_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_4VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_20_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_5VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_20_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_Sign=levelplot(Rej ~ rho1*rho2, data=ARMA_20_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_DifRuns=levelplot(Rej ~ rho1*rho2, data=ARMA_20_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_TP=levelplot(Rej ~ rho1*rho2, data=ARMA_20_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_BDS=levelplot(Rej ~ rho1*rho2, data=ARMA_20_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_LB=levelplot(Rej ~ rho1*rho2, data=ARMA_20_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                      main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_20_VNR=levelplot(Rej ~ rho1*rho2, data=ARMA_20_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


#### Heatmap-Plots


print(L_ARMA_20_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_ARMA_20_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_ARMA_20_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_ARMA_20_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_ARMA_20_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_ARMA_20_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_ARMA_20_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_ARMA_20_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_ARMA_20_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=50

ARMA_50_DW=RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='Durbin-Watson')

ARMA_50_3VZ=RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='3-VZ')

ARMA_50_4VZ=RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='4-VZ')

ARMA_50_5VZ=RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='5-VZ')

ARMA_50_Sign= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='Runs')

ARMA_50_DifRuns= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='DifRuns')

ARMA_50_TP= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='Turning-Point')

ARMA_50_BDS= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='BDS')

ARMA_50_LB= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='Ljung-Box')

ARMA_50_VNR= RejratesARMA(reps=100, n=50,order=c(1,0,1),testgrid= Grid_ARMA, test='VonNeumannRang')

###

L_ARMA_50_DW=levelplot(Rej ~ rho1*rho2, data=ARMA_50_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_3VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_50_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_4VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_50_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_5VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_50_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_Sign=levelplot(Rej ~ rho1*rho2, data=ARMA_50_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                         main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_DifRuns=levelplot(Rej ~ rho1*rho2, data=ARMA_50_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_TP=levelplot(Rej ~ rho1*rho2, data=ARMA_50_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_BDS=levelplot(Rej ~ rho1*rho2, data=ARMA_50_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_LB=levelplot(Rej ~ rho1*rho2, data=ARMA_50_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_50_VNR=levelplot(Rej ~ rho1*rho2, data=ARMA_50_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


#### Heatmap-Plots


print(L_ARMA_50_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_ARMA_50_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_ARMA_50_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_ARMA_50_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_ARMA_50_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_ARMA_50_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_ARMA_50_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_ARMA_50_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_ARMA_50_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=100

ARMA_100_DW=RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='Durbin-Watson')

ARMA_100_3VZ=RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='3-VZ')

ARMA_100_4VZ=RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='4-VZ')

ARMA_100_5VZ=RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='5-VZ')

ARMA_100_Sign= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='Runs')

ARMA_100_DifRuns= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='DifRuns')

ARMA_100_TP= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='Turning-Point')

ARMA_100_BDS= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='BDS')

ARMA_100_LB= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='Ljung-Box')

ARMA_100_VNR= RejratesARMA(reps=100, n=100,order=c(1,0,1),testgrid= Grid_ARMA, test='VonNeumannRang')

###

L_ARMA_100_DW=levelplot(Rej ~ rho1*rho2, data=ARMA_100_DW  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_3VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_100_3VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="3-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_4VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_100_4VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="4-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_5VZ=levelplot(Rej ~ rho1*rho2, data=ARMA_100_5VZ  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="5-Vorzeichen",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_Sign=levelplot(Rej ~ rho1*rho2, data=ARMA_100_Sign  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                         main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_DifRuns=levelplot(Rej ~ rho1*rho2, data=ARMA_100_DifRuns  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_TP=levelplot(Rej ~ rho1*rho2, data=ARMA_100_TP  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="TurningPoint",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_BDS=levelplot(Rej ~ rho1*rho2, data=ARMA_100_BDS  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_LB=levelplot(Rej ~ rho1*rho2, data=ARMA_100_LB  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                       main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_ARMA_100_VNR=levelplot(Rej ~ rho1*rho2, data=ARMA_100_VNR  ,pretty=T,layers=1,xlab="phi2", ylab="phi",
                        main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


#### Heatmap-Plots


print(L_ARMA_100_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_ARMA_100_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_ARMA_100_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_ARMA_100_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_ARMA_100_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_ARMA_100_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_ARMA_100_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_ARMA_100_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_ARMA_100_5VZ,split = c(3, 3, 3, 3), more = FALSE)


#_________________________________________________________________________________________________________
######################################### Sarima Simulationen ############################################
#_________________________________________________________________________________________________________

#### Gitter

Grid_Sarima= as.data.frame(CJ(rho=seq(-0.99,0.99,by=0.01),season= c(seq(1,6))))



### Speziell:

Grid_SarimaSp= as.data.frame(CJ(rho=c(-0.99,seq(-0.9,0.9,by=0.1),0.99),season= c(seq(7,30))))

Sarima1_50_5VZ_Sp=RejratesS(reps=100, n=500,testgrid= Grid_SarimaSp, test='5-VZ')

Sarima1_50_LB_Sp=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Ljung-Box')


L_Sarima1_50_5VZ=levelplot(Rej ~ rho*season, data=Sarima1_50_5VZ_Sp  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_LB=levelplot(Rej ~ rho*season, data=Sarima1_50_LB_Sp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                          main='',col.regions=magma, at=seq(0,1,by=0.05))

windows(height=5, width=7)
plot(L_Sarima1_50_LB)

### n=50

Sarima1_50_DW=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='Durbin-Watson')

Sarima1_50_3VZ=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='3-VZ')

Sarima1_50_4VZ=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='4-VZ')

Sarima1_50_5VZ=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='5-VZ')

Sarima1_50_Sign=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='Runs')

Sarima1_50_TP=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='Turning-Point')

Sarima1_50_BDS=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='BDS')

Sarima1_50_LB=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='Ljung-Box')

Sarima1_50_VNR=RejratesS(reps=100, n=50,testgrid= Grid_Sarima, test='VonNeumannRang')






L_Sarima1_50_DW=levelplot(Rej ~ rho*season, data=Sarima1_50_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05) )

L_Sarima1_50_LB=levelplot(Rej ~ rho*season, data=Sarima1_50_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_BDS=levelplot(Rej ~ rho*season, data=Sarima1_50_BDS, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_Sign=levelplot(Rej ~ rho*season, data=Sarima1_50_Sign, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                             main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_TP=levelplot(Rej ~ rho*season, data=Sarima1_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_VNR=levelplot(Rej ~ rho*season, data=Sarima1_50_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_3VZ=levelplot(Rej ~ rho*season, data=Sarima1_50_3VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_4VZ=levelplot(Rej ~ rho*season, data=Sarima1_50_4VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_50_5VZ=levelplot(Rej ~ rho*season, data=Sarima1_50_5VZ  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_Sarima1_50_DW,L_Sarima1_50_LB,L_Sarima1_50_BDS,L_Sarima1_50_Sign,L_Sarima1_50_TP,L_Sarima1_50_VNR,L_Sarima1_50_3VZ,L_Sarima1_50_4VZ,L_Sarima1_50_5VZ,ncol=3)




### n=500

Sarima1_500_DW=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Durbin-Watson')

Sarima1_500_3VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='3-VZ')

Sarima1_500_4VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='4-VZ')

Sarima1_500_5VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='5-VZ')

Sarima1_500_Sign=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Runs')

Sarima1_500_TP=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Turning-Point')

Sarima1_500_BDS=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='BDS')

Sarima1_500_LB=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Ljung-Box')

Sarima1_500_VNR=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='VonNeumannRang')






L_Sarima1_500_DW=levelplot(Rej ~ rho*season, data=Sarima1_500_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05) )

L_Sarima1_500_LB=levelplot(Rej ~ rho*season, data=Sarima1_500_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_BDS=levelplot(Rej ~ rho*season, data=Sarima1_500_BDS, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_Sign=levelplot(Rej ~ rho*season, data=Sarima1_500_Sign, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                               main="Runs",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_TP=levelplot(Rej ~ rho*season, data=Sarima1_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_VNR=levelplot(Rej ~ rho*season, data=Sarima1_500_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                              main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_3VZ=levelplot(Rej ~ rho*season, data=Sarima1_500_3VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                              main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_4VZ=levelplot(Rej ~ rho*season, data=Sarima1_500_4VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                              main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_500_5VZ=levelplot(Rej ~ rho*season, data=Sarima1_500_5VZ  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                              main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_Sarima1_500_DW,L_Sarima1_500_LB,L_Sarima1_500_BDS,L_Sarima1_500_Sign,L_Sarima1_500_TP,L_Sarima1_500_VNR,L_Sarima1_500_3VZ,L_Sarima1_500_4VZ,L_Sarima1_500_5VZ,ncol=3)




### n=10000

Sarima1_10000_DW=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='Durbin-Watson')

Sarima1_10000_3VZ=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='3-VZ')

Sarima1_10000_4VZ=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='4-VZ')

Sarima1_10000_5VZ=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='5-VZ')

#__ 

Sarima1_10000_Sign=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='Runs')

Sarima1_10000_TP=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='Turning-Point')

Sarima1_10000_BDS=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='BDS')

Sarima1_10000_LB=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='Ljung-Box')

Sarima1_10000_VNR=RejratesS(reps=100, n=10000,testgrid= Grid_Sarima, test='VonNeumannRang')






L_Sarima1_10000_DW=levelplot(Rej ~ rho*season, data=Sarima1_10000_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05) )

L_Sarima1_10000_LB=levelplot(Rej ~ rho*season, data=Sarima1_10000_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_BDS=levelplot(Rej ~ rho*season, data=Sarima1_10000_BDS, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_Sign=levelplot(Rej ~ rho*season, data=Sarima1_10000_Sign, pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                             main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_TP=levelplot(Rej ~ rho*season, data=Sarima1_10000_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                           main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_VNR=levelplot(Rej ~ rho*season, data=Sarima1_10000_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_3VZ=levelplot(Rej ~ rho*season, data=Sarima1_10000_3VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_4VZ=levelplot(Rej ~ rho*season, data=Sarima1_10000_4VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_Sarima1_10000_5VZ=levelplot(Rej ~ rho*season, data=Sarima1_10000_5VZ  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho_{S}$'),cex=1.3), ylab=list(label='Saison [S]',cex=1.3),colorkey= FALSE,
                            main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_Sarima1_5000_DW,L_Sarima1_5000_LB,L_Sarima1_5000_BDS,L_Sarima1_5000_Sign,L_Sarima1_5000_TP,L_Sarima1_5000_VNR,L_Sarima1_5000_3VZ,L_Sarima1_5000_4VZ,L_Sarima1_5000_5VZ,ncol=3)






### n=20
AR1_20_Sarima_DW=RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_20_Sarima_3VZ=RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='3-VZ')

AR1_20_Sarima_4VZ=RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='4-VZ')

AR1_20_Sarima_5VZ=RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='5-VZ')

AR1_20_Sarima_Sign= RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='Runs')

AR1_20_Sarima_DifRuns= RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='DifRuns')

AR1_20_Sarima_TP= RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='Turning-Point')

AR1_20_Sarima_BDS= RejratesS(reps=10, n=100,testgrid= Grid_Sarima, test='BDS')

AR1_20_Sarima_LB= RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_20_Sarima_VNR= RejratesS(reps=100, n=20,testgrid= Grid_Sarima, test='VonNeumannRang')


#### Heatmap Plots


L_AR1_20_Sarima_Sarima_DW=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_Sarima_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sarima_LB=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                      main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_BDS=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sarima_Sign=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_TP=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                      main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_VNR=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                       main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_3VZ=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                       main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_4VZ=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                       main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima_5VZ=levelplot(Rej ~ season*rho, data=AR1_20_Sarima_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                       main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_20_Sarima_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sarima_5VZ,split = c(3, 3, 3, 3), more = FALSE)





### n=100

AR1_100_Sarima_DW=RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_100_Sarima_3VZ=RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='3-VZ')

AR1_100_Sarima_4VZ=RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='4-VZ')

AR1_100_Sarima_5VZ=RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='5-VZ')

AR1_100_Sarima_Sign= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='Runs')

AR1_100_Sarima_DifRuns= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='DifRuns')

AR1_100_Sarima_TP= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='Turning-Point')

AR1_100_Sarima_BDS= RejratesS(reps=10, n=100,testgrid= Grid_Sarima, test='BDS')

AR1_100_Sarima_LB= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_100_Sarima_VNR= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='VonNeumannRang')


#### Heatmap Plots


L_AR1_100_Sarima_Sarima_DW=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_Sarima_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sarima_LB=levelplot(Rej ~ rho*season, data=AR1_100_Sarima_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),
              col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sarima_BDS=levelplot(Rej ~ rho*season, data=AR1_100_Sarima_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sarima_Sign=levelplot(Rej ~ rho*season, data=AR1_100_Sarima_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima_TP=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima_VNR=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima_3VZ=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima_4VZ=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima_5VZ=levelplot(Rej ~ season*rho, data=AR1_100_Sarima_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_100_Sarima_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sarima_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=500

AR1_500_Sarima_DW=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_500_Sarima_3VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='3-VZ')

AR1_500_Sarima_4VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='4-VZ')

AR1_500_Sarima_5VZ=RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='5-VZ')

AR1_500_Sarima_Sign= RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Runs')

AR1_500_Sarima_DifRuns= RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='DifRuns')

AR1_500_Sarima_TP= RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Turning-Point')

AR1_500_Sarima_BDS= RejratesS(reps=100, n=100,testgrid= Grid_Sarima, test='BDS')

AR1_500_Sarima_LB= RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_500_Sarima_VNR= RejratesS(reps=100, n=500,testgrid= Grid_Sarima, test='VonNeumannRang')


#### Heatmap Plots


L_AR1_500_Sarima_DW=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_LB=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_BDS=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_Sign=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_TP=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_VNR=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_3VZ=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_4VZ=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Sarima_5VZ=levelplot(Rej ~ season*rho, data=AR1_500_Sarima_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))



print(L_AR1_500_Sarima_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_500_Sarima_5VZ,split = c(3, 3, 3, 3), more = FALSE)


#_________________________________________________________________________________________________________
######################################### Mit 5 Kontaminationen der Intensitt 10 ###############################################
#_________________________________________________________________________________________________________


### n=20

AR1_20_Kont5_Sarima_DW=RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_20_Kont5_Sarima_3VZ=RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='3-VZ')

AR1_20_Kont5_Sarima_4VZ=RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='4-VZ')

AR1_20_Kont5_Sarima_5VZ=RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='5-VZ')

AR1_20_Kont5_Sarima_Sign= RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Runs')

AR1_20_Kont5_Sarima_TP= RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Turning-Point')

AR1_20_Kont5_Sarima_BDS= RejratesS(reps=10, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='BDS')

AR1_20_Kont5_Sarima_LB= RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_20_Kont5_Sarima_VNR= RejratesS(reps=100, n=20, kontno=5, kontint=10,testgrid= Grid_Sarima, test='VonNeumannRang')

#### Heatmap Plots


L_AR1_20_Kont5_Sarima_DW=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Kont5_Sarima_LB=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                                    main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_BDS=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                                     main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Kont5_Sarima_Sign=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                                      main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_TP=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                                    main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_VNR=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                                     main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_3VZ=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                                     main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_4VZ=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                                     main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Kont5_Sarima_5VZ=levelplot(Rej ~ season*rho, data=AR1_20_Kont5_Sarima_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                                     main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



### n=50

AR1_50_Kont5_Sarima_DW=RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_50_Kont5_Sarima_3VZ=RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='3-VZ')

AR1_50_Kont5_Sarima_4VZ=RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='4-VZ')

AR1_50_Kont5_Sarima_5VZ=RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='5-VZ')

AR1_50_Kont5_Sarima_Sign= RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Runs')

AR1_50_Kont5_Sarima_TP= RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Turning-Point')

AR1_50_Kont5_Sarima_BDS= RejratesS(reps=10, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='BDS')

AR1_50_Kont5_Sarima_LB= RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_50_Kont5_Sarima_VNR= RejratesS(reps=100, n=50, kontno=5, kontint=10,testgrid= Grid_Sarima, test='VonNeumannRang')

#### Heatmap Plots


L_AR1_50_Kont5_Sarima_DW=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_LB=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_BDS=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_BDS, pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_Sign=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_Sign, pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                      main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_TP=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_VNR=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_3VZ=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_3VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_4VZ=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_4VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_50_Kont5_Sarima_5VZ=levelplot(Rej ~ rho*season, data=AR1_50_Kont5_Sarima_5VZ  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_50_Kont5_Sarima_DW,L_AR1_50_Kont5_Sarima_LB,L_AR1_50_Kont5_Sarima_BDS,L_AR1_50_Kont5_Sarima_Sign,L_AR1_50_Kont5_Sarima_TP,L_AR1_50_Kont5_Sarima_VNR,L_AR1_50_Kont5_Sarima_3VZ,L_AR1_50_Kont5_Sarima_4VZ,L_AR1_50_Kont5_Sarima_5VZ,ncol=3)




### n=100

AR1_100_Kont5_Sarima_DW=RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_100_Kont5_Sarima_3VZ=RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='3-VZ')

AR1_100_Kont5_Sarima_4VZ=RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='4-VZ')

AR1_100_Kont5_Sarima_5VZ=RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='5-VZ')

AR1_100_Kont5_Sarima_Sign= RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Runs')

AR1_100_Kont5_Sarima_TP= RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Turning-Point')

AR1_100_Kont5_Sarima_BDS= RejratesS(reps=10, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='BDS')

AR1_100_Kont5_Sarima_LB= RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_100_Kont5_Sarima_VNR= RejratesS(reps=100, n=100, kontno=5, kontint=10,testgrid= Grid_Sarima, test='VonNeumannRang')

#### Heatmap Plots


L_AR1_100_Kont5_Sarima_DW=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                                     main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Kont5_Sarima_LB=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_BDS=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                               main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Kont5_Sarima_Sign=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                                main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_TP=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_VNR=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                               main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_3VZ=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                               main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_4VZ=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                               main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Kont5_Sarima_5VZ=levelplot(Rej ~ season*rho, data=AR1_100_Kont5_Sarima_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                               main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_100_Kont5_Sarima_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_100_Kont5_Sarima_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=500

AR1_500_Kont5_Sarima_DW=RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Durbin-Watson')

AR1_500_Kont5_Sarima_3VZ=RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='3-VZ')

AR1_500_Kont5_Sarima_4VZ=RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='4-VZ')

AR1_500_Kont5_Sarima_5VZ=RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='5-VZ')

AR1_500_Kont5_Sarima_Sign= RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Runs')

AR1_500_Kont5_Sarima_TP= RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Turning-Point')

AR1_500_Kont5_Sarima_BDS= RejratesS(reps=10, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='BDS')

AR1_500_Kont5_Sarima_LB= RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='Ljung-Box')

AR1_500_Kont5_Sarima_VNR= RejratesS(reps=100, n=500, kontno=5, kontint=10,testgrid= Grid_Sarima, test='VonNeumannRang')

#### Heatmap Plots


L_AR1_500_Kont5_Sarima_DW=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                   main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_LB=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                   main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_BDS=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_BDS, pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_Sign=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_Sign, pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                     main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_TP=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                   main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_VNR=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_3VZ=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_3VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_4VZ=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_4VZ  , pretty=T,layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_500_Kont5_Sarima_5VZ=levelplot(Rej ~ rho*season, data=AR1_500_Kont5_Sarima_5VZ  ,pretty=T, layers=1,xlab=list(label=TeX('$\\rho}$'),cex=1.3), ylab=list(label="Saison [S]",cex=1.3),colorkey=FALSE,
                                    main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_AR1_500_Kont5_Sarima_DW,L_AR1_500_Kont5_Sarima_LB,L_AR1_500_Kont5_Sarima_BDS,L_AR1_500_Kont5_Sarima_Sign,L_AR1_500_Kont5_Sarima_TP,L_AR1_500_Kont5_Sarima_VNR,L_AR1_500_Kont5_Sarima_3VZ,L_AR1_500_Kont5_Sarima_4VZ,L_AR1_500_Kont5_Sarima_5VZ,ncol=3)

#_________________________________________________________________________________________________________
######################################### AR2-Simulationen ###############################################
#_________________________________________________________________________________________________________

## Definieren eines Gitters (fr Stationaritt)

CJAR2= CJ(rho1=c(-1.99,seq(-1.9,1.9,by=0.1),1.99),rho2= c(-0.99,seq(-0.9,0.9,by=0.1),0.99))

Grid_AR2 <- as.data.frame(CJAR2[(rho2>-1) & (rho2-rho1<0.99) & (rho2 + rho1<0.99) | (rho2>-1) & (rho1- rho2>-0.99)& (rho1+rho2<0.99)])



----------------------------------------------------------------------------------------------------------
######################################### Normalbedingungen ##############################################
----------------------------------------------------------------------------------------------------------
  AR2_500_BG=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Breusch-Godfrey') 
  
### n= 20
  
AR2_20_DW=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_20_3VZ=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_20_4VZ=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_20_5VZ=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_20_Sign= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_20_TP= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_20_BDS= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_20_LB= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_20_VNR= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')


### scales=list(x=list(font=2,at=seq(2,length(c(-1.99,seq(-1.9,1.9,by=0.1),1.99))-1,by=1),labels=(seq(-1.9,1.9,by=0.1)),cex=1),y=list(font=2,at=seq(10,length(c(-0.99,seq(-0.9,0.9,by=0.1),0.99)),by=10),labels=(seq(-1.9,1.9,by=0.1)),cex=1))
L_AR2_500_BG=levelplot(Rej ~ rho1*rho2, data=AR2_500_BG  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)


L_AR2_20_DW=levelplot(Rej ~ rho1*rho2, data=AR2_20_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_LB=levelplot(Rej ~ rho1*rho2, data=AR2_20_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_20_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_20_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_TP=levelplot(Rej ~ rho1*rho2, data=AR2_20_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_20_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)


#AR2_20=stack(L_AR2_20_DW,L_AR2_20_LB,L_AR2_20_BDS,L_AR2_20_Sign,L_AR2_20_TP,L_AR2_20_VNR,L_AR2_20_3VZ,L_AR2_20_4VZ,L_AR2_20_5VZ)
#print(AR2_20, title="")

# stack(AR2_20_DW,AR2_20_TP,raster(as.matrix(AR2_20_DW)), Rej ~ rho1*rho2))
#levelplot(raster(as.matrix(AR2_20_DW)))



windows(width=10, height=10)
grid.arrange(L_AR2_20_DW,L_AR2_20_LB,L_AR2_20_BDS,L_AR2_20_Sign,L_AR2_20_TP,L_AR2_20_VNR,L_AR2_20_3VZ,L_AR2_20_4VZ,L_AR2_20_5VZ,ncol=3)




### n=50


AR2_50_DW=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_50_3VZ=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_50_4VZ=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_50_5VZ=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_50_Sign= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_50_TP= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_50_BDS= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_50_LB= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_50_VNR= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_50_DW=levelplot(Rej ~ rho1*rho2, data=AR2_50_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_LB=levelplot(Rej ~ rho1*rho2, data=AR2_50_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_50_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_50_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_TP=levelplot(Rej ~ rho1*rho2, data=AR2_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_50_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_50_DW,L_AR2_50_LB,L_AR2_50_BDS,L_AR2_50_Sign,L_AR2_50_TP,L_AR2_50_VNR,L_AR2_50_3VZ,L_AR2_50_4VZ,L_AR2_50_5VZ,ncol=3)


### n= 100

AR2_100_DW=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_100_3VZ=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_100_4VZ=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_100_5VZ=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_100_Sign= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_100_TP= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_100_BDS= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_100_LB= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_100_VNR= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')


### 
L_AR2_100_DW=levelplot(Rej ~ rho1*rho2, data=AR2_100_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_LB=levelplot(Rej ~ rho1*rho2, data=AR2_100_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_100_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_100_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_TP=levelplot(Rej ~ rho1*rho2, data=AR2_100_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_100_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_100_DW,L_AR2_100_LB,L_AR2_100_BDS,L_AR2_100_Sign,L_AR2_100_TP,L_AR2_100_VNR,L_AR2_100_3VZ,L_AR2_100_4VZ,L_AR2_100_5VZ,ncol=3)


### n=500


AR2_500_DW=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_500_3VZ=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_500_4VZ=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_500_5VZ=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_500_Sign= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_500_TP= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_500_BDS= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_500_LB= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_500_VNR= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_500_DW=levelplot(Rej ~ rho1*rho2, data=AR2_500_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_LB=levelplot(Rej ~ rho1*rho2, data=AR2_500_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_500_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_500_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_TP=levelplot(Rej ~ rho1*rho2, data=AR2_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_500_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_DW,L_AR2_500_LB,L_AR2_500_BDS,L_AR2_500_Sign,L_AR2_500_TP,L_AR2_500_VNR,L_AR2_500_3VZ,L_AR2_500_4VZ,L_AR2_500_5VZ,ncol=3)



----------------------------------------------------------------------------------------------------------
  ######################################### Wachsende Varianz ###########################################
----------------------------------------------------------------------------------------------------------
  
  ### n=20
  
  
  AR2_20_WVar_DW=Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_20_WVar_3VZ=Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_20_WVar_4VZ=Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_20_WVar_5VZ=Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_20_WVar_Sign= Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_20_WVar_TP= Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_20_WVar_BDS= Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_20_WVar_LB= Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_20_WVar_VNR= Rejrates2WVar(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_20_WVar_DW=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_LB=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_TP=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_WVar_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_WVar_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_20_WVar_DW,L_AR2_20_WVar_LB,L_AR2_20_WVar_BDS,L_AR2_20_WVar_Sign,L_AR2_20_WVar_TP,L_AR2_20_WVar_VNR,L_AR2_20_WVar_3VZ,L_AR2_20_WVar_4VZ,L_AR2_20_WVar_5VZ,ncol=3)

  
  
  
  ### n=50
  
  
AR2_50_WVar_DW=Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_50_WVar_3VZ=Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_50_WVar_4VZ=Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_50_WVar_5VZ=Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_50_WVar_Sign= Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_50_WVar_TP= Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_50_WVar_BDS= Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_50_WVar_LB= Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_50_WVar_VNR= Rejrates2WVar(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_50_WVar_DW=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_LB=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_TP=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_WVar_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_WVar_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_50_WVar_DW,L_AR2_50_WVar_LB,L_AR2_50_WVar_BDS,L_AR2_50_WVar_Sign,L_AR2_50_WVar_TP,L_AR2_50_WVar_VNR,L_AR2_50_WVar_3VZ,L_AR2_50_WVar_4VZ,L_AR2_50_WVar_5VZ,ncol=3)


### n=100


AR2_100_WVar_DW=Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_100_WVar_3VZ=Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_100_WVar_4VZ=Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_100_WVar_5VZ=Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_100_WVar_Sign= Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_100_WVar_TP= Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_100_WVar_BDS= Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_100_WVar_LB= Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_100_WVar_VNR= Rejrates2WVar(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_100_WVar_DW=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_LB=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_TP=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_WVar_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_WVar_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_100_WVar_DW,L_AR2_100_WVar_LB,L_AR2_100_WVar_BDS,L_AR2_100_WVar_Sign,L_AR2_100_WVar_TP,L_AR2_100_WVar_VNR,L_AR2_100_WVar_3VZ,L_AR2_100_WVar_4VZ,L_AR2_100_WVar_5VZ,ncol=3)


### n=500


AR2_500_WVar_DW=Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_500_WVar_3VZ=Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_500_WVar_4VZ=Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_500_WVar_5VZ=Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_500_WVar_Sign= Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

###

AR2_500_WVar_TP= Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_500_WVar_BDS= Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_500_WVar_LB= Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_500_WVar_VNR= Rejrates2WVar(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_500_WVar_DW=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_LB=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_TP=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_WVar_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_WVar_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_WVar_DW,L_AR2_500_WVar_LB,L_AR2_500_WVar_BDS,L_AR2_500_WVar_Sign,L_AR2_500_WVar_TP,L_AR2_500_WVar_VNR,L_AR2_500_WVar_3VZ,L_AR2_500_WVar_4VZ,L_AR2_500_WVar_5VZ,ncol=3)

  
  
  
  
----------------------------------------------------------------------------------------------------------
  ######################################### Drift ###########################################
----------------------------------------------------------------------------------------------------------
  
  
 ### n=20
  
AR2_20_D_DW=Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_20_D_3VZ=Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_20_D_4VZ=Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_20_D_5VZ=Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_20_D_Sign= Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_20_D_TP= Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_20_D_BDS= Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_20_D_LB= Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_20_D_VNR= Rejrates2D(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')
  


L_AR2_20_D_DW=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_LB=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_TP=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_D_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_20_D_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)




windows(width=10, height=10)
grid.arrange(L_AR2_20_D_DW,L_AR2_20_D_LB,L_AR2_20_D_BDS,L_AR2_20_D_Sign,L_AR2_20_D_TP,L_AR2_20_D_VNR,L_AR2_20_D_3VZ,L_AR2_20_D_4VZ,L_AR2_20_D_5VZ,ncol=3)




### n=50

AR2_50_D_DW=Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_50_D_3VZ=Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_50_D_4VZ=Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_50_D_5VZ=Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_50_D_Sign= Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_50_D_TP= Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_50_D_BDS= Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_50_D_LB= Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_50_D_VNR= Rejrates2D(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')



L_AR2_50_D_DW=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_LB=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_TP=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_D_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_50_D_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)




windows(width=10, height=10)
grid.arrange(L_AR2_50_D_DW,L_AR2_50_D_LB,L_AR2_50_D_BDS,L_AR2_50_D_Sign,L_AR2_50_D_TP,L_AR2_50_D_VNR,L_AR2_50_D_3VZ,L_AR2_50_D_4VZ,L_AR2_50_D_5VZ,ncol=3)




### n=100

AR2_100_D_DW=Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_100_D_3VZ=Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_100_D_4VZ=Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_100_D_5VZ=Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_100_D_Sign= Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_100_D_TP= Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_100_D_BDS= Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_100_D_LB= Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_100_D_VNR= Rejrates2D(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')



L_AR2_100_D_DW=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_LB=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_TP=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_D_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_100_D_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)




windows(width=10, height=10)
grid.arrange(L_AR2_100_D_DW,L_AR2_100_D_LB,L_AR2_100_D_BDS,L_AR2_100_D_Sign,L_AR2_100_D_TP,L_AR2_100_D_VNR,L_AR2_100_D_3VZ,L_AR2_100_D_4VZ,L_AR2_100_D_5VZ,ncol=3)



### n=500
  
AR2_500_D_DW=Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_500_D_3VZ=Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='3-VZ')

AR2_500_D_4VZ=Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='4-VZ')

AR2_500_D_5VZ=Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='5-VZ')

AR2_500_D_Sign= Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_500_D_TP= Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_500_D_BDS= Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='BDS')

AR2_500_D_LB= Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_500_D_VNR= Rejrates2D(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')



L_AR2_500_D_DW=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_LB=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_BDS=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_TP=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_D_5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_500_D_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_D_DW,L_AR2_500_D_LB,L_AR2_500_D_BDS,L_AR2_500_D_Sign,L_AR2_500_D_TP,L_AR2_500_D_VNR,L_AR2_500_D_3VZ,L_AR2_500_D_4VZ,L_AR2_500_D_5VZ,ncol=3)


----------------------------------------------------------------------------------------------------------
  ######################################### Andere Verteilungen ###########################################
----------------------------------------------------------------------------------------------------------

######## Cauchy
 
  
#n=50 
  
AR2_50_DW_t1=Rejrates2(reps=100, n=50,order=c(2,0,0), distr='t', df=1,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_50_3VZ_t1=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='3-VZ')

AR2_50_4VZ_t1=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='4-VZ')

AR2_50_5VZ_t1=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='5-VZ')

AR2_50_Sign_t1= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Runs')

AR2_50_TP_t1= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Turning-Point')

AR2_50_BDS_t1= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='BDS')

AR2_50_LB_t1= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Ljung-Box')

AR2_50_VNR_t1= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_50_DW_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_DW_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_LB_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_LB_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_BDS_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_BDS_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_Sign_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_Sign_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_TP_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_VNR_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_VNR_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_3VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_3VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_4VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_4VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_5VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_50_5VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_50_DW_t1,L_AR2_50_LB_t1,L_AR2_50_BDS_t1,L_AR2_50_Sign_t1,L_AR2_50_TP_t1,L_AR2_50_VNR_t1,L_AR2_50_3VZ_t1,L_AR2_50_4VZ_t1,L_AR2_50_5VZ_t1,ncol=3)

  


#n=500 

AR2_500_DW_t1=Rejrates2(reps=100, n=500,order=c(2,0,0), distr='t', df=1,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_500_3VZ_t1=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='3-VZ')

AR2_500_4VZ_t1=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='4-VZ')

AR2_500_5VZ_t1=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='5-VZ')

AR2_500_Sign_t1= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Runs')

AR2_500_TP_t1= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Turning-Point')

AR2_500_BDS_t1= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='BDS')

AR2_500_LB_t1= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='Ljung-Box')

AR2_500_VNR_t1= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='t', df=1,testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_500_DW_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_DW_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_LB_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_LB_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_BDS_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_BDS_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_Sign_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_Sign_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_TP_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_VNR_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_VNR_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_3VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_3VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_4VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_4VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_5VZ_t1=levelplot(Rej ~ rho1*rho2, data=AR2_500_5VZ_t1  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_DW_t1,L_AR2_500_LB_t1,L_AR2_500_BDS_t1,L_AR2_500_Sign_t1,L_AR2_500_TP_t1,L_AR2_500_VNR_t1,L_AR2_500_3VZ_t1,L_AR2_500_4VZ_t1,L_AR2_500_5VZ_t1,ncol=3)

  



#### dexp



#n=50 

AR2_50_DW_dexp=Rejrates2(reps=100, n=50,order=c(2,0,0), distr='dexp', scale=2,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_50_3VZ_dexp=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='3-VZ')

AR2_50_4VZ_dexp=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='4-VZ')

AR2_50_5VZ_dexp=Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='5-VZ')

AR2_50_Sign_dexp= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Runs')

AR2_50_TP_dexp= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Turning-Point')

AR2_50_BDS_dexp= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='BDS')

AR2_50_LB_dexp= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Ljung-Box')

AR2_50_VNR_dexp= Rejrates2(reps=100, n=50,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_50_DW_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_DW_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_LB_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_LB_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_BDS_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_BDS_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_Sign_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_Sign_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_TP_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                         main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_VNR_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_VNR_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_3VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_3VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_4VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_4VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_5VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_50_5VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_50_DW_dexp,L_AR2_50_LB_dexp,L_AR2_50_BDS_dexp,L_AR2_50_Sign_dexp,L_AR2_50_TP_dexp,L_AR2_50_VNR_dexp,L_AR2_50_3VZ_dexp,L_AR2_50_4VZ_dexp,L_AR2_50_5VZ_dexp,ncol=3)




#n=500 

AR2_500_DW_dexp=Rejrates2(reps=100, n=500,order=c(2,0,0), distr='dexp', scale=2,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_500_3VZ_dexp=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='3-VZ')

AR2_500_4VZ_dexp=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='4-VZ')

AR2_500_5VZ_dexp=Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='5-VZ')

AR2_500_Sign_dexp= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Runs')

AR2_500_TP_dexp= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Turning-Point')

AR2_500_BDS_dexp= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='BDS')

AR2_500_LB_dexp= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='Ljung-Box')

AR2_500_VNR_dexp= Rejrates2(reps=100, n=500,order=c(2,0,0),distr='dexp', scale=2,testgrid= Grid_AR2, test='VonNeumannRang')

###

L_AR2_500_DW_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_DW_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_LB_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_LB_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_BDS_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_BDS_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_Sign_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_Sign_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_TP_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                          main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_VNR_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_VNR_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_3VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_3VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_4VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_4VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_5VZ_dexp=levelplot(Rej ~ rho1*rho2, data=AR2_500_5VZ_dexp  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_DW_dexp,L_AR2_500_LB_dexp,L_AR2_500_BDS_dexp,L_AR2_500_Sign_dexp,L_AR2_500_TP_dexp,L_AR2_500_VNR_dexp,L_AR2_500_3VZ_dexp,L_AR2_500_4VZ_dexp,L_AR2_500_5VZ_dexp,ncol=3)

  
  


#_________________________________________________________________________________________________________
######################################### Kontaminationen 5% ###############################################
#_________________________________________________________________________________________________________

### n=20


AR2_20_DW_Kont5=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='Durbin-Watson')

AR2_20_3VZ_Kont5=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='3-VZ')

AR2_20_4VZ_Kont5=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='4-VZ')

AR2_20_5VZ_Kont5=Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='5-VZ')

AR2_20_Sign_Kont5= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='Runs')

AR2_20_TP_Kont5= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='Turning-Point')

AR2_20_BDS_Kont5= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='BDS')

AR2_20_LB_Kont5= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='Ljung-Box')

AR2_20_VNR_Kont5= Rejrates2(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, kontno= 1, kontint=10, test='VonNeumannRang')

###

L_AR2_20_DW_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_DW_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_LB_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_LB_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_BDS_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_BDS_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_Sign_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_Sign_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_TP_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_TP_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_VNR_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_VNR_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_3VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_3VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_4VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_4VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_20_5VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_20_5VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_20_DW_Kont5,L_AR2_20_LB_Kont5,L_AR2_20_BDS_Kont5,L_AR2_20_Sign_Kont5,L_AR2_20_TP_Kont5,L_AR2_20_VNR_Kont5,L_AR2_20_3VZ_Kont5,L_AR2_20_4VZ_Kont5,L_AR2_20_5VZ_Kont5,ncol=3)


### n=50


AR2_50_DW_Kont5=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='Durbin-Watson')

AR2_50_3VZ_Kont5=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='3-VZ')

AR2_50_4VZ_Kont5=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='4-VZ')

AR2_50_5VZ_Kont5=Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='5-VZ')

AR2_50_Sign_Kont5= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='Runs')

AR2_50_TP_Kont5= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='Turning-Point')

AR2_50_BDS_Kont5= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='BDS')

AR2_50_LB_Kont5= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='Ljung-Box')

AR2_50_VNR_Kont5= Rejrates2(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, kontno= 3, kontint=10, test='VonNeumannRang')

###

L_AR2_50_DW_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_DW_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_LB_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_LB_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_BDS_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_BDS_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_Sign_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_Sign_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                              main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_TP_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_TP_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_VNR_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_VNR_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_3VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_3VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_4VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_4VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_50_5VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_50_5VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_50_DW_Kont5,L_AR2_50_LB_Kont5,L_AR2_50_BDS_Kont5,L_AR2_50_Sign_Kont5,L_AR2_50_TP_Kont5,L_AR2_50_VNR_Kont5,L_AR2_50_3VZ_Kont5,L_AR2_50_4VZ_Kont5,L_AR2_50_5VZ_Kont5,ncol=3)


### n=100


AR2_100_DW_Kont5=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='Durbin-Watson')

AR2_100_3VZ_Kont5=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='3-VZ')

AR2_100_4VZ_Kont5=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='4-VZ')

AR2_100_5VZ_Kont5=Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='5-VZ')

AR2_100_Sign_Kont5= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='Runs')

AR2_100_TP_Kont5= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='Turning-Point')

AR2_100_BDS_Kont5= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='BDS')

AR2_100_LB_Kont5= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='Ljung-Box')

AR2_100_VNR_Kont5= Rejrates2(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, kontno=5, kontint=10, test='VonNeumannRang')

###

L_AR2_100_DW_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_DW_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_LB_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_LB_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_BDS_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_BDS_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_Sign_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_Sign_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                              main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_TP_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_TP_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_VNR_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_VNR_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_3VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_3VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_4VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_4VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_100_5VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_100_5VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_100_DW_Kont5,L_AR2_100_LB_Kont5,L_AR2_100_BDS_Kont5,L_AR2_100_Sign_Kont5,L_AR2_100_TP_Kont5,L_AR2_100_VNR_Kont5,L_AR2_100_3VZ_Kont5,L_AR2_100_4VZ_Kont5,L_AR2_100_5VZ_Kont5,ncol=3)



### n=500


AR2_500_DW_Kont5=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='Durbin-Watson')

AR2_500_3VZ_Kont5=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='3-VZ')

AR2_500_4VZ_Kont5=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='4-VZ')

AR2_500_5VZ_Kont5=Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='5-VZ')

AR2_500_Sign_Kont5= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='Runs')

AR2_500_TP_Kont5= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='Turning-Point')

AR2_500_BDS_Kont5= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='BDS')

AR2_500_LB_Kont5= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='Ljung-Box')

AR2_500_VNR_Kont5= Rejrates2(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, kontno=25, kontint=10, test='VonNeumannRang')

###

L_AR2_500_DW_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_DW_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_LB_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_LB_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_BDS_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_BDS_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="BDS",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_Sign_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_Sign_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                              main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_TP_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_TP_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_VNR_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_VNR_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_3VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_3VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_4VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_4VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_500_5VZ_Kont5=levelplot(Rej ~ rho1*rho2, data=AR2_500_5VZ_Kont5  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)



windows(width=10, height=10)
grid.arrange(L_AR2_500_DW_Kont5,L_AR2_500_LB_Kont5,L_AR2_500_BDS_Kont5,L_AR2_500_Sign_Kont5,L_AR2_500_TP_Kont5,L_AR2_500_VNR_Kont5,L_AR2_500_3VZ_Kont5,L_AR2_500_4VZ_Kont5,L_AR2_500_5VZ_Kont5,ncol=3)



#_________________________________________________________________________________________________________
######################################################## Zufallsschocks #################################
#_________________________________________________________________________________________________________
  
  
AR2_20_DW_S1.30=Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_20_3VZ_S3.10=Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='3-VZ')

AR2_20_4VZ_S3.10=Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='4-VZ')

AR2_20_5VZ_S3.10=Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='5-VZ')

AR2_20_Sign_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='Runs')

AR2_20_DifRuns_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='DifRuns')

AR2_20_TP_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='Turning-Point')

AR2_20_BDS_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=10,testgrid= Grid_AR2, test='BDS')

AR2_20_LB_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='Ljung-Box')

AR2_20_VNR_S3.10= Rejrates2(reps=100, n=20,order=c(2,0,0),shockno=3,shockint=10,testgrid= Grid_AR2, test='VonNeumannRang')


###


L_AR2_20_DW_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_DW_S3.10  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_LB_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_LB_S3.10  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_BDS_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_BDS_S3.10, pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_Sign_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_Sign_S3.10, pretty=T,layers=1,xlab="rho", ylab="rho2",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR2_20_TP_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_TP_S3.10  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_VNR_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_VNR_S3.10  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_3VZ_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_3VZ_S3.10  , pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_4VZ_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_4VZ_S3.10  , pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_5VZ_S3.10=levelplot(Rej ~ rho1*rho2, data=AR2_20_5VZ_S3.10  ,pretty=T, layers=1,xlab="rho", ylab="rho2",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR2_20_DW_S3.10, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR2_20_LB_S3.10, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR2_20_BDS_S3.10, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR2_20_Sign_S3.10,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR2_20_TP_S3.10, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR2_20_VNR_S3.10, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR2_20_3VZ_S3.10, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR2_20_4VZ_S3.10, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR2_20_5VZ_S3.10,split = c(3, 3, 3, 3), more = FALSE)




----------------------------------------------------------------------------------------------------------
  ################################ Mit 1 Zufallsschock der Intensitt 30 ###############################
----------------------------------------------------------------------------------------------------------
  
  
  AR2_20_DW_S1.30=Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='Durbin-Watson')

AR2_20_3VZ_S1.30=Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='3-VZ')

AR2_20_4VZ_S1.30=Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='4-VZ')

AR2_20_5VZ_S1.30=Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='5-VZ')

AR2_20_Sign_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='Runs')

AR2_20_DifRuns_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='DifRuns')

AR2_20_TP_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='Turning-Point')

AR2_20_BDS_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=10,testgrid= Grid_AR2, test='BDS')

AR2_20_LB_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='Ljung-Box')

AR2_20_VNR_S1.30= Rejrates2(reps=100, n=20,order=c(2,0,0),shockint=30,testgrid= Grid_AR2, test='VonNeumannRang')


###


L_AR2_20_DW_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_DW_S1.30  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_LB_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_LB_S1.30  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_BDS_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_BDS_S1.30, pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_Sign_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_Sign_S1.30, pretty=T,layers=1,xlab="rho", ylab="rho2",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR2_20_TP_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_TP_S1.30  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_VNR_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_VNR_S1.30  ,pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_3VZ_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_3VZ_S1.30  , pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_4VZ_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_4VZ_S1.30  , pretty=T,layers=1,xlab="rho", ylab="rho2",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR2_20_5VZ_S1.30=levelplot(Rej ~ rho1*rho2, data=AR2_20_5VZ_S1.30  ,pretty=T, layers=1,xlab="rho", ylab="rho2",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR2_20_DW_S1.30, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR2_20_LB_S1.30, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR2_20_BDS_S1.30, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR2_20_Sign_S1.30,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR2_20_TP_S1.30, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR2_20_VNR_S1.30, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR2_20_3VZ_S1.30, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR2_20_4VZ_S1.30, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR2_20_5VZ_S1.30,split = c(3, 3, 3, 3), more = FALSE)








#_________________________________________________________________________________________________________
######################################### AR-Prozesse hherer Ordnung###############################################
#_________________________________________________________________________________________________________




#_________________________________________________________________________________________________________
######################################### Modelle mit Drift ##############################################
#_________________________________________________________________________________________________________

### Erstellen eines Gitters

Grid_AR1_Drift=as.data.frame(CJ(rho=c(-0.99,seq(-0.9,0.9,by=0.1),0.99),drift= seq(-2,2,by=0.1)))


##

AR1_20_Drift_DW=RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Durbin-Watson')

AR1_20_Drift_3VZ=RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='3-VZ')

AR1_20_Drift_4VZ=RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='4-VZ')

AR1_20_Drift_5VZ=RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='5-VZ')

AR1_20_Drift_Sign= RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Runs')

AR1_20_Drift_DifRuns= RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='DifRuns')

AR1_20_Drift_TP= RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Turning-Point')

AR1_20_Drift_BDS= RejratesD(reps=10, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='BDS')

AR1_20_Drift_LB= RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Ljung-Box')

AR1_20_Drift_VNR= RejratesD(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='VonNeumannRang')



#### Heatmap Plots

L_AR1_20_Drift_DW=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_DW  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                      main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_LB=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_LB  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                      main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_BDS=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_BDS, pretty=T,layers=1,xlab="drift", ylab="rho",
                       main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_Sign=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_Sign, pretty=T,layers=1,xlab="drift", ylab="rho",
                        main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_TP=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_TP  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                      main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_VNR=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_VNR  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                       main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_3VZ=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_3VZ  , pretty=T,layers=1,xlab="drift", ylab="rho",
                       main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Drift_4VZ=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_4VZ  , pretty=T,layers=1,xlab="drift", ylab="rho",
                       main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Drift_5VZ=levelplot(Rej ~ drift*rho, data=AR1_20_Drift_5VZ  ,pretty=T, layers=1,xlab="drift", ylab="rho",
                       main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_20_Drift_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_20_Drift_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_Drift_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Drift_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_Drift_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_Drift_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_Drift_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_Drift_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_Drift_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=100


##

AR1_100_Drift_DW=RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Durbin-Watson')

AR1_100_Drift_3VZ=RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='3-VZ')

AR1_100_Drift_4VZ=RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='4-VZ')

AR1_100_Drift_5VZ=RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='5-VZ')

AR1_100_Drift_Sign= RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Runs')

AR1_100_Drift_DifRuns= RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='DifRuns')

AR1_100_Drift_TP= RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Turning-Point')

AR1_100_Drift_BDS= RejratesD(reps=10, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='BDS')

AR1_100_Drift_LB= RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='Ljung-Box')

AR1_100_Drift_VNR= RejratesD(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Drift, test='VonNeumannRang')



#### Heatmap Plots

L_AR1_100_Drift_DW=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_DW  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                            main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_LB=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_LB  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                            main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_BDS=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_BDS, pretty=T,layers=1,xlab="drift", ylab="rho",
                             main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_Sign=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_Sign, pretty=T,layers=1,xlab="drift", ylab="rho",
                              main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_TP=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_TP  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                            main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_VNR=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_VNR  ,pretty=T,layers=1,xlab="drift", ylab="rho",
                             main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_3VZ=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_3VZ  , pretty=T,layers=1,xlab="drift", ylab="rho",
                             main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Drift_4VZ=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_4VZ  , pretty=T,layers=1,xlab="drift", ylab="rho",
                             main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Drift_5VZ=levelplot(Rej ~ drift*rho, data=AR1_100_Drift_5VZ  ,pretty=T, layers=1,xlab="drift", ylab="rho",
                             main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_100_Drift_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_100_Drift_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_100_Drift_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_100_Drift_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_100_Drift_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_100_Drift_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_100_Drift_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_100_Drift_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_100_Drift_5VZ,split = c(3, 3, 3, 3), more = FALSE)


#_________________________________________________________________________________________________________
######################################### Heteroskedastizitt ############################################
#_________________________________________________________________________________________________________
  

#_________________________________________________________________________________________________________
######################################### Wechselnde Varianz #############################################
#_________________________________________________________________________________________________________


##### AR(1) von 1 auf sd=2


AR1_20_SD2_DW_Simple=RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_SD2_3VZ_Simple=RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_SD2_4VZ_Simple=RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_SD2_5VZ_Simple=RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_SD2_Sign_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_SD2_DifRuns_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_SD2_TP_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_SD2_BDS_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_SD2_LB_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_SD2_VNR_Simple= RejratesH(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')



#### Heatmap Plot

Gem_AR1_20_SD2 = cbind(AR1_20_SD2_DW_Simple$Rej,AR1_20_SD2_LB_Simple$Rej,AR1_20_SD2_BDS_Simple$Rej,AR1_20_SD2_Sign_Simple$Rej,AR1_20_SD2_TP_Simple$Rej,AR1_20_SD2_VNR_Simple$Rej,AR1_20_SD2_3VZ_Simple$Rej,AR1_20_SD2_4VZ_Simple$Rej,AR1_20_SD2_5VZ_Simple$Rej)
colnames(Gem_AR1_20_SD2)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_SD2) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_SD2,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Wechselnde Standartabw. (2)')



### Von 1 auf sd=4

AR1_20_SD4_DW_Simple=RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Durbin-Watson')

AR1_20_SD4_3VZ_Simple=RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='3-VZ')

AR1_20_SD4_4VZ_Simple=RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='4-VZ')

AR1_20_SD4_5VZ_Simple=RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='5-VZ')

AR1_20_SD4_Sign_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Runs')

AR1_20_SD4_DifRuns_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='DifRuns')

AR1_20_SD4_TP_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Turning-Point')

AR1_20_SD4_BDS_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='BDS')

AR1_20_SD4_LB_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='Ljung-Box')

AR1_20_SD4_VNR_Simple= RejratesH(reps=100,breakpointsd=4, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple, test='VonNeumannRang')



#### Heatmap Plot

Gem_AR1_20_SD4 = cbind(AR1_20_SD4_DW_Simple$Rej,AR1_20_SD4_LB_Simple$Rej,AR1_20_SD4_BDS_Simple$Rej,AR1_20_SD4_Sign_Simple$Rej,AR1_20_SD4_TP_Simple$Rej,AR1_20_SD4_VNR_Simple$Rej,AR1_20_SD4_3VZ_Simple$Rej,AR1_20_SD4_4VZ_Simple$Rej,AR1_20_SD4_5VZ_Simple$Rej)
colnames(Gem_AR1_20_SD4)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_AR1_20_SD4) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_AR1_20_SD4,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Wechselnde Standartabw. (4)')


----------------------------------------------------------------------------------------------------------
  ########################################### GARCH(1,0) ###################################################
----------------------------------------------------------------------------------------------------------
  

----------------------------------------------------------------------------------------------------------
########################################### GARCH(1,1) ###################################################
----------------------------------------------------------------------------------------------------------


### Definieren des Gitters fr "typische Werte"
  
CJARGarch= CJ(alpha=seq(0.05,0.1,by=0.005),beta= seq(0.85,0.98,by=0.005))

Grid_GARCH <- as.data.frame(CJARGarch[alpha+beta<0.99])


######## n=20

GARCH_20_DW=RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='Durbin-Watson')

GARCH_20_3VZ=RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='3-VZ')

GARCH_20_4VZ=RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='4-VZ')

GARCH_20_5VZ=RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='5-VZ')

GARCH_20_Sign= RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='Runs')

GARCH_20_TP= RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='Turning-Point')

GARCH_20_BDS= RejratesGARCH(reps=10, n=100,testgrid= Grid_GARCH, test='BDS')

GARCH_20_LB= RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='Ljung-Box')

GARCH_20_VNR= RejratesGARCH(reps=100, n=20,testgrid= Grid_GARCH, test='VonNeumannRang')

#### Heatmap-Plot

L_GARCH_20_DW=levelplot(Rej ~ alpha*beta, data=GARCH_20_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_3VZ=levelplot(Rej ~ alpha*beta, data=GARCH_20_3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                         main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_4VZ=levelplot(Rej ~ alpha*beta, data=GARCH_20_4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                         main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_5VZ=levelplot(Rej ~ alpha*beta, data=GARCH_20_5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                         main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_Sign=levelplot(Rej ~ alpha*beta, data=GARCH_20_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                          main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_DifRuns=levelplot(Rej ~ alpha*beta, data=GARCH_20_DifRuns  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                             main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_TP=levelplot(Rej ~ alpha*beta, data=GARCH_20_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                        main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_BDS=levelplot(Rej ~ alpha*beta, data=GARCH_20_BDS  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                         main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_LB=levelplot(Rej ~ alpha*beta, data=GARCH_20_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                        main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_20_VNR=levelplot(Rej ~ alpha*beta, data=GARCH_20_VNR ,pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3),
                         main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))





windows(width=10, height=10)
grid.arrange(L_GARCH_20_DW,L_GARCH_20_LB,L_GARCH_20_BDS,L_GARCH_20_Sign,L_GARCH_20_TP,L_GARCH_20_VNR,L_GARCH_20_3VZ,L_GARCH_20_4VZ,L_GARCH_20_5VZ,ncol=3)





######## n=50

GARCH_50_DW=RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='Durbin-Watson')

GARCH_50_3VZ=RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='3-VZ')

GARCH_50_4VZ=RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='4-VZ')

GARCH_50_5VZ=RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='5-VZ')

GARCH_50_Sign= RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='Runs')

GARCH_50_DifRuns= RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='DifRuns')

GARCH_50_TP= RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='Turning-Point')

GARCH_50_BDS= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='BDS')

GARCH_50_LB= RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='Ljung-Box')

GARCH_50_VNR= RejratesGARCH(reps=100, n=50,testgrid= Grid_GARCH, test='VonNeumannRang')





#### Heatmap-Plot

L_GARCH_50_DW=levelplot(Rej ~ alpha*beta, data=GARCH_50_DW  ,pretty=T,layers=1,
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_50_3VZ=levelplot(Rej ~ alpha*beta, data=GARCH_50_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_4VZ=levelplot(Rej ~ alpha*beta, data=GARCH_50_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_5VZ=levelplot(Rej ~ alpha*beta, data=GARCH_50_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_Sign=levelplot(Rej ~ alpha*beta, data=GARCH_50_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_TP=levelplot(Rej ~ alpha*beta, data=GARCH_50_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_BDS=levelplot(Rej ~ alpha*beta, data=GARCH_50_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_LB=levelplot(Rej ~ alpha*beta, data=GARCH_50_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_50_VNR=levelplot(Rej ~ alpha*beta, data=GARCH_50_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_GARCH_50_DW,L_GARCH_50_LB,L_GARCH_50_BDS,L_GARCH_50_Sign,L_GARCH_50_TP,L_GARCH_50_VNR,L_GARCH_50_3VZ,L_GARCH_50_4VZ,L_GARCH_50_5VZ,ncol=3)







### n=100

GARCH_100_DW=RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='Durbin-Watson')

GARCH_100_3VZ=RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='3-VZ')

GARCH_100_4VZ=RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='4-VZ')

GARCH_100_5VZ=RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='5-VZ')

GARCH_100_Sign= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='Runs')

GARCH_100_DifRuns= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='DifRuns')

GARCH_100_TP= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='Turning-Point')

GARCH_100_BDS= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='BDS')

GARCH_100_LB= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='Ljung-Box')

GARCH_100_VNR= RejratesGARCH(reps=100, n=100,testgrid= Grid_GARCH, test='VonNeumannRang')



#### Heatmap-Plot
L_GARCH_100_DW=levelplot(Rej ~ alpha*beta, data=GARCH_100_DW  ,pretty=T,layers=1,
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_100_3VZ=levelplot(Rej ~ alpha*beta, data=GARCH_100_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_4VZ=levelplot(Rej ~ alpha*beta, data=GARCH_100_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_5VZ=levelplot(Rej ~ alpha*beta, data=GARCH_100_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_Sign=levelplot(Rej ~ alpha*beta, data=GARCH_100_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_TP=levelplot(Rej ~ alpha*beta, data=GARCH_100_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_BDS=levelplot(Rej ~ alpha*beta, data=GARCH_100_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_LB=levelplot(Rej ~ alpha*beta, data=GARCH_100_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_GARCH_100_VNR=levelplot(Rej ~ alpha*beta, data=GARCH_100_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))



windows(width=10, height=10)
grid.arrange(L_GARCH_100_DW,L_GARCH_100_LB,L_GARCH_100_BDS,L_GARCH_100_Sign,L_GARCH_100_TP,L_GARCH_100_VNR,L_GARCH_100_3VZ,L_GARCH_100_4VZ,L_GARCH_100_5VZ,ncol=3)




######## n=500

GARCH_500_DW=RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='Durbin-Watson')

GARCH_500_3VZ=RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='3-VZ')

GARCH_500_4VZ=RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='4-VZ')

GARCH_500_5VZ=RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='5-VZ')

GARCH_500_Sign= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='Runs')

GARCH_500_DifRuns= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='DifRuns')

GARCH_500_TP= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='Turning-Point')

GARCH_500_BDS= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='BDS')

GARCH_500_LB= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='Ljung-Box')

GARCH_500_VNR= RejratesGARCH(reps=100, n=500,testgrid= Grid_GARCH, test='VonNeumannRang')





#### Heatmap-Plot
L_GARCH_500_DW=levelplot(Rej ~ alpha*beta, data=GARCH_500_DW  ,pretty=T,layers=1, colorkey=FALSE,
                        main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_3VZ=levelplot(Rej ~ alpha*beta, data=GARCH_500_3VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_4VZ=levelplot(Rej ~ alpha*beta, data=GARCH_500_4VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_5VZ=levelplot(Rej ~ alpha*beta, data=GARCH_500_5VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_Sign=levelplot(Rej ~ alpha*beta, data=GARCH_500_Sign  ,pretty=T,layers=1,colorkey=FALSE,
                           main="Runs",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_TP=levelplot(Rej ~ alpha*beta, data=GARCH_500_TP  ,pretty=T,layers=1,colorkey=FALSE,
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_BDS=levelplot(Rej ~ alpha*beta, data=GARCH_500_BDS  ,pretty=T,layers=1,colorkey=FALSE,
                          main="BDS",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_LB=levelplot(Rej ~ alpha*beta, data=GARCH_500_LB  ,pretty=T,layers=1,colorkey=FALSE,
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_500_VNR=levelplot(Rej ~ alpha*beta, data=GARCH_500_VNR ,pretty=T,layers=1,colorkey=FALSE,
                          main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))



windows(width=10, height=10)
grid.arrange(L_GARCH_500_DW,L_GARCH_500_LB,L_GARCH_500_BDS,L_GARCH_500_Sign,L_GARCH_500_TP,L_GARCH_500_VNR,L_GARCH_500_3VZ,L_GARCH_500_4VZ,L_GARCH_500_5VZ,ncol=3)


######## n=5000

GARCH_5000_DW=RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='Durbin-Watson')

GARCH_5000_3VZ=RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='3-VZ')

GARCH_5000_4VZ=RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='4-VZ')

GARCH_5000_5VZ=RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='5-VZ')

GARCH_5000_Sign= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='Runs')

GARCH_5000_DifRuns= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='DifRuns')

GARCH_5000_TP= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='Turning-Point')

GARCH_5000_BDS= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='BDS')

GARCH_5000_LB= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='Ljung-Box')

GARCH_5000_VNR= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCH, test='VonNeumannRang')





#### Heatmap-Plot
L_GARCH_5000_DW=levelplot(Rej ~ alpha*beta, data=GARCH_5000_DW  ,pretty=T,layers=1, colorkey=FALSE,
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_3VZ=levelplot(Rej ~ alpha*beta, data=GARCH_5000_3VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="3-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_4VZ=levelplot(Rej ~ alpha*beta, data=GARCH_5000_4VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="4-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_5VZ=levelplot(Rej ~ alpha*beta, data=GARCH_5000_5VZ  ,pretty=T,layers=1,colorkey=FALSE,
                          main="5-VZ",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_Sign=levelplot(Rej ~ alpha*beta, data=GARCH_5000_Sign  ,pretty=T,layers=1,colorkey=FALSE,
                           main="Runs",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_TP=levelplot(Rej ~ alpha*beta, data=GARCH_5000_TP  ,pretty=T,layers=1,colorkey=FALSE,
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_BDS=levelplot(Rej ~ alpha*beta, data=GARCH_5000_BDS  ,pretty=T,layers=1,colorkey=FALSE,
                          main="BDS",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_LB=levelplot(Rej ~ alpha*beta, data=GARCH_5000_LB  ,pretty=T,layers=1,colorkey=FALSE,
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))

L_GARCH_5000_VNR=levelplot(Rej ~ alpha*beta, data=GARCH_5000_VNR ,pretty=T,layers=1,colorkey=FALSE,
                          main="Von-Neumann",col.regions=magma, at=seq(0,1,by=0.05),xlab=list(label=TeX('$\\alpha}$'),cex=1.3), ylab=list(label=TeX('$\\beta$'),cex=1.3))


windows(width=10, height=10)
grid.arrange(L_GARCH_5000_DW,L_GARCH_5000_LB,L_GARCH_5000_BDS,L_GARCH_5000_Sign,L_GARCH_5000_TP,L_GARCH_5000_VNR,L_GARCH_5000_3VZ,L_GARCH_5000_4VZ,L_GARCH_5000_5VZ,ncol=3)


#_________________________________________________________________________________________________________
############################################### ARCH(1) ##################################################
#_________________________________________________________________________________________________________


##### Definieren eines Gitters
  
Grid_ARCH= c(seq(0,0.99,by=0.05))


###

ARCH_20_DW=RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='Durbin-Watson')

ARCH_20_3VZ=RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='3-VZ')

ARCH_20_4VZ=RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='4-VZ')

ARCH_20_5VZ=RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='5-VZ')

ARCH_20_Sign= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='Runs')

ARCH_20_DifRuns= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='DifRuns')

ARCH_20_TP= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='Turning-Point')

ARCH_20_BDS= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='BDS')

ARCH_20_LB= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='Ljung-Box')

ARCH_20_VNR= RejratesARCH(reps=100, n=20,testgrid= Grid_ARCH, test='VonNeumannRang')



Gem_ARCH_20 = cbind(ARCH_20_DW$Rej,ARCH_20_LB$Rej,ARCH_20_BDS$Rej,ARCH_20_Sign$Rej,ARCH_20_TP$Rej,ARCH_20_VNR$Rej,ARCH_20_3VZ$Rej,ARCH_20_4VZ$Rej,ARCH_20_5VZ$Rej)
colnames(Gem_ARCH_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_ARCH_20) <- seq(0,0.99,0.05)


levelplot(Gem_ARCH_20,pretty=T,col.regions=magma,xlab="alpha", ylab="Test", at=seq(0,1,by=0.05), main='ARCH(1)')




### n=100

ARCH_100_DW=RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='Durbin-Watson')

ARCH_100_3VZ=RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='3-VZ')

ARCH_100_4VZ=RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='4-VZ')

ARCH_100_5VZ=RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='5-VZ')

ARCH_100_Sign= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='Runs')

ARCH_100_DifRuns= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='DifRuns')

ARCH_100_TP= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='Turning-Point')

ARCH_100_BDS= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='BDS')

ARCH_100_LB= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='Ljung-Box')

ARCH_100_VNR= RejratesARCH(reps=100, n=100,testgrid= Grid_ARCH, test='VonNeumannRang')



Gem_ARCH_100 = cbind(ARCH_100_DW$Rej,ARCH_100_LB$Rej,ARCH_100_BDS$Rej,ARCH_100_Sign$Rej,ARCH_100_TP$Rej,ARCH_100_VNR$Rej,ARCH_100_3VZ$Rej,ARCH_100_4VZ$Rej,ARCH_100_5VZ$Rej)
colnames(Gem_ARCH_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_ARCH_100) <- seq(0,0.99,0.05)


levelplot(Gem_ARCH_100,pretty=T,col.regions=magma,xlab="alpha", ylab="Test", at=seq(0,1,by=0.05), main='ARCH(1)')



#_________________________________________________________________________________________________________
############################################### Nichtlineare Modelle ######################################
#_________________________________________________________________________________________________________


#_________________________________________________________________________________________________________
############################################### Risswachstums-Modell######################################
#_________________________________________________________________________________________________________

Grid_NL= as.data.frame(CJ(seq(-0.02,0.05,by=0.005),seq(0.5,1.2,by=0.1)))

### n=20

AR1_NL_20_DW=RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='Durbin-Watson')

AR1_NL_20_3VZ=RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='3-VZ')

AR1_NL_20_4VZ=RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='4-VZ')

AR1_NL_20_5VZ=RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='5-VZ')

AR1_NL_20_Sign= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='Runs')

AR1_NL_20_DifRuns= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='DifRuns')

AR1_NL_20_TP= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='Turning-Point')

AR1_NL_20_BDS= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='BDS')

AR1_NL_20_LB= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='Ljung-Box')

AR1_NL_20_VNR= RejratesNL(reps=100, n=20,testgrid= Grid_NL, test='VonNeumannRang')


###

L_AR1_NL_20_DW=levelplot(Rej ~ V1*V2, data=AR1_NL_20_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_3VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_20_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_4VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_20_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_5VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_20_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_Sign=levelplot(Rej ~ V1*V2, data=AR1_NL_20_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_NL_20_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                             main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_TP=levelplot(Rej ~ V1*V2, data=AR1_NL_20_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_BDS=levelplot(Rej ~ V1*V2, data=AR1_NL_20_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_LB=levelplot(Rej ~ V1*V2, data=AR1_NL_20_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                        main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_20_VNR=levelplot(Rej ~ V1*V2, data=AR1_NL_20_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_NL_20_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_NL_20_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_NL_20_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_NL_20_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_NL_20_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_NL_20_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_NL_20_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_NL_20_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_NL_20_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=50

AR1_NL_50_DW=RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='Durbin-Watson')

AR1_NL_50_3VZ=RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='3-VZ')

AR1_NL_50_4VZ=RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='4-VZ')

AR1_NL_50_5VZ=RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='5-VZ')

AR1_NL_50_Sign= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='Runs')

AR1_NL_50_DifRuns= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='DifRuns')

AR1_NL_50_TP= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='Turning-Point')

AR1_NL_50_BDS= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='BDS')

AR1_NL_50_LB= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='Ljung-Box')

AR1_NL_50_VNR= RejratesNL(reps=100, n=50,testgrid= Grid_NL, test='VonNeumannRang')


###

L_AR1_NL_50_DW=levelplot(Rej ~ V1*V2, data=AR1_NL_50_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_3VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_50_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_4VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_50_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_5VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_50_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_Sign=levelplot(Rej ~ V1*V2, data=AR1_NL_50_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_NL_50_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                              main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_TP=levelplot(Rej ~ V1*V2, data=AR1_NL_50_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_BDS=levelplot(Rej ~ V1*V2, data=AR1_NL_50_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_LB=levelplot(Rej ~ V1*V2, data=AR1_NL_50_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_50_VNR=levelplot(Rej ~ V1*V2, data=AR1_NL_50_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_NL_50_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_NL_50_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_NL_50_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_NL_50_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_NL_50_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_NL_50_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_NL_50_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_NL_50_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_NL_50_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=100

AR1_NL_100_DW=RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='Durbin-Watson')

AR1_NL_100_3VZ=RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='3-VZ')

AR1_NL_100_4VZ=RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='4-VZ')

AR1_NL_100_5VZ=RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='5-VZ')

AR1_NL_100_Sign= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='Runs')

AR1_NL_100_DifRuns= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='DifRuns')

AR1_NL_100_TP= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='Turning-Point')

AR1_NL_100_BDS= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='BDS')

AR1_NL_100_LB= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='Ljung-Box')

AR1_NL_100_VNR= RejratesNL(reps=100, n=100,testgrid= Grid_NL, test='VonNeumannRang')


###

L_AR1_NL_100_DW=levelplot(Rej ~ V1*V2, data=AR1_NL_100_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_3VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_100_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_4VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_100_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_5VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_100_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_Sign=levelplot(Rej ~ V1*V2, data=AR1_NL_100_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_NL_100_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                              main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_TP=levelplot(Rej ~ V1*V2, data=AR1_NL_100_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_BDS=levelplot(Rej ~ V1*V2, data=AR1_NL_100_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_LB=levelplot(Rej ~ V1*V2, data=AR1_NL_100_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_100_VNR=levelplot(Rej ~ V1*V2, data=AR1_NL_100_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_NL_100_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_NL_100_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_NL_100_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_NL_100_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_NL_100_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_NL_100_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_NL_100_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_NL_100_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_NL_100_5VZ,split = c(3, 3, 3, 3), more = FALSE)





### n=500

AR1_NL_500_DW=RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='Durbin-Watson')

AR1_NL_500_3VZ=RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='3-VZ')

AR1_NL_500_4VZ=RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='4-VZ')

AR1_NL_500_5VZ=RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='5-VZ')

AR1_NL_500_Sign= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='Runs')

AR1_NL_500_DifRuns= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='DifRuns')

AR1_NL_500_TP= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='Turning-Point')

AR1_NL_500_BDS= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='BDS')

AR1_NL_500_LB= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='Ljung-Box')

AR1_NL_500_VNR= RejratesNL(reps=100, n=500,testgrid= Grid_NL, test='VonNeumannRang')


###

L_AR1_NL_500_DW=levelplot(Rej ~ V1*V2, data=AR1_NL_500_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_3VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_500_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_4VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_500_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_5VZ=levelplot(Rej ~ V1*V2, data=AR1_NL_500_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_Sign=levelplot(Rej ~ V1*V2, data=AR1_NL_500_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_NL_500_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                              main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_TP=levelplot(Rej ~ V1*V2, data=AR1_NL_500_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_BDS=levelplot(Rej ~ V1*V2, data=AR1_NL_500_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_LB=levelplot(Rej ~ V1*V2, data=AR1_NL_500_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_NL_500_VNR=levelplot(Rej ~ V1*V2, data=AR1_NL_500_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_NL_500_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_NL_500_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_NL_500_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_NL_500_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_NL_500_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_NL_500_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_NL_500_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_NL_500_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_NL_500_5VZ,split = c(3, 3, 3, 3), more = FALSE)

#_________________________________________________________________________________________________________
############################################### Multiplikatives MA-Modell######################################
#_________________________________________________________________________________________________________

Grid_NLMA= seq(-2,2,by=0.1)


### n=20

NLMA1_20_DW_Simple=RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='Durbin-Watson')

NLMA1_20_3VZ_Simple=RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='3-VZ')

NLMA1_20_4VZ_Simple=RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='4-VZ')

NLMA1_20_5VZ_Simple=RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='5-VZ')

NLMA1_20_Sign_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='Runs')

NLMA1_20_DifRuns_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='DifRuns')

NLMA1_20_TP_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='Turning-Point')

NLMA1_20_BDS_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='BDS')

NLMA1_20_LB_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='Ljung-Box')

NLMA1_20_VNR_Simple= RejratesNLMA(reps=100, n=20,order=c(0,0,1),testgrid= Grid_NLMA, test='VonNeumannRang')



### Heatmap Plots

Gem_NLMA1_20 = cbind(NLMA1_20_DW_Simple$Rej,NLMA1_20_LB_Simple$Rej,NLMA1_20_BDS_Simple$Rej,NLMA1_20_Sign_Simple$Rej,NLMA1_20_TP_Simple$Rej,NLMA1_20_VNR_Simple$Rej,NLMA1_20_3VZ_Simple$Rej,NLMA1_20_4VZ_Simple$Rej,NLMA1_20_5VZ_Simple$Rej)
colnames(Gem_NLMA1_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-NeuNLMAnn','3-VZ','4-VZ','5-VZ')
rownames(Gem_NLMA1_20) <- round(seq(-2,2,by=0.1),digits=1)


levelplot(Gem_NLMA1_20,pretty=T,col.regions=magma,xlab="phi", ylab="Test", at=seq(0,1,by=0.05), NLMAin='NorNLMAlbedingungen NLMA(1)')




### n=100


NLMA1_100_DW_Simple=RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='Durbin-Watson')

NLMA1_100_3VZ_Simple=RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='3-VZ')

NLMA1_100_4VZ_Simple=RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='4-VZ')

NLMA1_100_5VZ_Simple=RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='5-VZ')

NLMA1_100_Sign_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='Runs')

NLMA1_100_DifRuns_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='DifRuns')

NLMA1_100_TP_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='Turning-Point')

NLMA1_100_BDS_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='BDS')

NLMA1_100_LB_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='Ljung-Box')

NLMA1_100_VNR_Simple= RejratesNLMA(reps=100, n=100,order=c(0,0,1),testgrid= Grid_NLMA, test='VonNeumannRang')



### Heatmap Plots

Gem_NLMA1_100 = cbind(NLMA1_100_DW_Simple$Rej,NLMA1_100_LB_Simple$Rej,NLMA1_100_BDS_Simple$Rej,NLMA1_100_Sign_Simple$Rej,NLMA1_100_TP_Simple$Rej,NLMA1_100_VNR_Simple$Rej,NLMA1_100_3VZ_Simple$Rej,NLMA1_100_4VZ_Simple$Rej,NLMA1_100_5VZ_Simple$Rej)
colnames(Gem_NLMA1_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-NeuNLMAnn','3-VZ','4-VZ','5-VZ')
rownames(Gem_NLMA1_100) <- round(seq(-2,2,by=0.1),digits=1)


levelplot(Gem_NLMA1_100,pretty=T,col.regions=magma,xlab="phi", ylab="Test", at=seq(0,1,by=0.05), NLMAin='NorNLMAlbedingungen NLMA(1)')



#_________________________________________________________________________________________________________
############################################### Bilineares Autoregressives Modell ######################################
#_________________________________________________________________________________________________________

Grid_BLAR= as.data.frame(CJ(c(-0.99,seq(-0.9,0.9,by=0.1),0.99),seq(0,1,by=0.1)))

### n=20


AR1_BLAR_20_DW=RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='Durbin-Watson')

AR1_BLAR_20_3VZ=RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='3-VZ')

AR1_BLAR_20_4VZ=RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='4-VZ')

AR1_BLAR_20_5VZ=RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='5-VZ')

AR1_BLAR_20_Sign= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='Runs')

AR1_BLAR_20_DifRuns= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='DifRuns')

AR1_BLAR_20_TP= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='Turning-Point')

AR1_BLAR_20_BDS= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='BDS')

AR1_BLAR_20_LB= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='Ljung-Box')

AR1_BLAR_20_VNR= RejratesBLAR(reps=100, n=20,testgrid= Grid_BLAR, test='VonNeumannRang')


###

L_AR1_BLAR_20_DW=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_3VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_4VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_5VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_Sign=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                              main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_TP=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_BDS=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_LB=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                         main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_20_VNR=levelplot(Rej ~ V1*V2, data=AR1_BLAR_20_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                          main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_BLAR_20_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_BLAR_20_5VZ,split = c(3, 3, 3, 3), more = FALSE)


### n=100


AR1_BLAR_100_DW=RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='Durbin-Watson')

AR1_BLAR_100_3VZ=RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='3-VZ')

AR1_BLAR_100_4VZ=RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='4-VZ')

AR1_BLAR_100_5VZ=RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='5-VZ')

AR1_BLAR_100_Sign= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='Runs')

AR1_BLAR_100_DifRuns= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='DifRuns')

AR1_BLAR_100_TP= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='Turning-Point')

AR1_BLAR_100_BDS= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='BDS')

AR1_BLAR_100_LB= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='Ljung-Box')

AR1_BLAR_100_VNR= RejratesBLAR(reps=100, n=100,testgrid= Grid_BLAR, test='VonNeumannRang')


###

L_AR1_BLAR_100_DW=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_DW  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_3VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_3VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                            main="3-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_4VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_4VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                            main="4-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_5VZ=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_5VZ  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                            main="5-Vorzeichentiefe",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_Sign=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_Sign  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                             main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_DifRuns=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_DifRuns  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                                main="DifRuns",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_TP=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_TP  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_BDS=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_BDS  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                            main="BDS-Statistik",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_LB=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_LB  ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                           main="Ljung-Box",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_BLAR_100_VNR=levelplot(Rej ~ V1*V2, data=AR1_BLAR_100_VNR ,pretty=T,layers=1,xlab="alpha", ylab="beta",
                            main="VonNeumann-Rang",col.regions=magma, at=seq(0,1,by=0.05))


print(L_AR1_BLAR_100_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_BLAR_100_5VZ,split = c(3, 3, 3, 3), more = FALSE)

#_________________________________________________________________________________________________________
############################################### Threshold Modell ######################################
#_________________________________________________________________________________________________________

Grid_TAR1_Simple = Grid_AR1_Simple

### n=20


TAR1_20_DW_Simple=RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Durbin-Watson')

TAR1_20_3VZ_Simple=RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='3-VZ')

TAR1_20_4VZ_Simple=RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='4-VZ')

TAR1_20_5VZ_Simple=RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='5-VZ')

TAR1_20_Sign_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Runs')

TAR1_20_DifRuns_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='DifRuns')

TAR1_20_TP_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Turning-Point')

TAR1_20_BDS_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='BDS')

TAR1_20_LB_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Ljung-Box')

TAR1_20_VNR_Simple= RejratesTAR(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_TAR1_20 = cbind(TAR1_20_DW_Simple$Rej,TAR1_20_LB_Simple$Rej,TAR1_20_BDS_Simple$Rej,TAR1_20_Sign_Simple$Rej,TAR1_20_TP_Simple$Rej,TAR1_20_VNR_Simple$Rej,TAR1_20_3VZ_Simple$Rej,TAR1_20_4VZ_Simple$Rej,TAR1_20_5VZ_Simple$Rej)
colnames(Gem_TAR1_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_TAR1_20) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_TAR1_20,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')




### n=100


TAR1_100_DW_Simple=RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Durbin-Watson')

TAR1_100_3VZ_Simple=RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='3-VZ')

TAR1_100_4VZ_Simple=RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='4-VZ')

TAR1_100_5VZ_Simple=RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='5-VZ')

TAR1_100_Sign_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Runs')

TAR1_100_DifRuns_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='DifRuns')

TAR1_100_TP_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Turning-Point')

TAR1_100_BDS_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='BDS')

TAR1_100_LB_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='Ljung-Box')

TAR1_100_VNR_Simple= RejratesTAR(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR1_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_TAR1_100 = cbind(TAR1_100_DW_Simple$Rej,TAR1_100_LB_Simple$Rej,TAR1_100_BDS_Simple$Rej,TAR1_100_Sign_Simple$Rej,TAR1_100_TP_Simple$Rej,TAR1_100_VNR_Simple$Rej,TAR1_100_3VZ_Simple$Rej,TAR1_100_4VZ_Simple$Rej,TAR1_100_5VZ_Simple$Rej)
colnames(Gem_TAR1_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_TAR1_100) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_TAR1_100,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')



#_________________________________________________________________________________________________________
############################################### Threshold Modell 2 ######################################
#_________________________________________________________________________________________________________


Grid_TAR21_Simple= Grid_TAR1_Simple


###n=20

TAR21_20_DW_Simple=RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Durbin-Watson')

TAR21_20_3VZ_Simple=RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='3-VZ')

TAR21_20_4VZ_Simple=RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='4-VZ')

TAR21_20_5VZ_Simple=RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='5-VZ')

TAR21_20_Sign_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Runs')

TAR21_20_DifRuns_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='DifRuns')

TAR21_20_TP_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Turning-Point')

TAR21_20_BDS_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='BDS')

TAR21_20_LB_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Ljung-Box')

TAR21_20_VNR_Simple= RejratesTAR2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_TAR21_20 = cbind(TAR21_20_DW_Simple$Rej,TAR21_20_LB_Simple$Rej,TAR21_20_BDS_Simple$Rej,TAR21_20_Sign_Simple$Rej,TAR21_20_TP_Simple$Rej,TAR21_20_VNR_Simple$Rej,TAR21_20_3VZ_Simple$Rej,TAR21_20_4VZ_Simple$Rej,TAR21_20_5VZ_Simple$Rej)
colnames(Gem_TAR21_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_TAR21_20) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_TAR21_20,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')




###n=100

TAR21_100_DW_Simple=RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Durbin-Watson')

TAR21_100_3VZ_Simple=RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='3-VZ')

TAR21_100_4VZ_Simple=RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='4-VZ')

TAR21_100_5VZ_Simple=RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='5-VZ')

TAR21_100_Sign_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Runs')

TAR21_100_DifRuns_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='DifRuns')

TAR21_100_TP_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Turning-Point')

TAR21_100_BDS_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='BDS')

TAR21_100_LB_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='Ljung-Box')

TAR21_100_VNR_Simple= RejratesTAR2(reps=100, n=100,order=c(1,0,0),testgrid= Grid_TAR21_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_TAR21_100 = cbind(TAR21_100_DW_Simple$Rej,TAR21_100_LB_Simple$Rej,TAR21_100_BDS_Simple$Rej,TAR21_100_Sign_Simple$Rej,TAR21_100_TP_Simple$Rej,TAR21_100_VNR_Simple$Rej,TAR21_100_3VZ_Simple$Rej,TAR21_100_4VZ_Simple$Rej,TAR21_100_5VZ_Simple$Rej)
colnames(Gem_TAR21_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_TAR21_100) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_TAR21_100,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')



#_________________________________________________________________________________________________________
############################################### INAR Modell ######################################
#_________________________________________________________________________________________________________

Grid_INAR2_Simple= Grid_TAR1_Simple





###n=20

INAR2_20_DW_Simple=RejratesINAR(reps=100, n=20,lambda=2,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Durbin-Watson')

INAR2_20_3VZ_Simple=RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='3-VZ')

INAR2_20_4VZ_Simple=RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='4-VZ')

INAR2_20_5VZ_Simple=RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='5-VZ')

INAR2_20_Sign_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Runs')

INAR2_20_DifRuns_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='DifRuns')

INAR2_20_TP_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Turning-Point')

INAR2_20_BDS_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='BDS')

INAR2_20_LB_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Ljung-Box')

INAR2_20_VNR_Simple= RejratesINAR(reps=100, n=20,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_INAR2_20 = cbind(INAR2_20_DW_Simple$Rej,INAR2_20_LB_Simple$Rej,INAR2_20_BDS_Simple$Rej,INAR2_20_Sign_Simple$Rej,INAR2_20_TP_Simple$Rej,INAR2_20_VNR_Simple$Rej,INAR2_20_3VZ_Simple$Rej,INAR2_20_4VZ_Simple$Rej,INAR2_20_5VZ_Simple$Rej)
colnames(Gem_INAR2_20)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_INAR2_20) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_INAR2_20,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')





###n=100

INAR2_100_DW_Simple=RejratesINAR(reps=100, n=100,lambda=2,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Durbin-Watson')

INAR2_100_3VZ_Simple=RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='3-VZ')

INAR2_100_4VZ_Simple=RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='4-VZ')

INAR2_100_5VZ_Simple=RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='5-VZ')

INAR2_100_Sign_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Runs')

INAR2_100_DifRuns_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='DifRuns')

INAR2_100_TP_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Turning-Point')

INAR2_100_BDS_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='BDS')

INAR2_100_LB_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='Ljung-Box')

INAR2_100_VNR_Simple= RejratesINAR(reps=100, n=100,lambda=2,,order=c(1,0,0),testgrid= Grid_INAR2_Simple, test='VonNeumannRang')




### Heatmap- Plots

Gem_INAR2_100 = cbind(INAR2_100_DW_Simple$Rej,INAR2_100_LB_Simple$Rej,INAR2_100_BDS_Simple$Rej,INAR2_100_Sign_Simple$Rej,INAR2_100_TP_Simple$Rej,INAR2_100_VNR_Simple$Rej,INAR2_100_3VZ_Simple$Rej,INAR2_100_4VZ_Simple$Rej,INAR2_100_5VZ_Simple$Rej)
colnames(Gem_INAR2_100)<- c('Durbin-Watson','Ljung-Box', 'BDS', 'Runs', 'Turning-Point','Von-Neumann','3-VZ','4-VZ','5-VZ')
rownames(Gem_INAR2_100) <- c(-0.99,seq(-0.9,0.9,by=0.1),0.99)


levelplot(Gem_INAR2_100,pretty=T,col.regions=magma,xlab="rho", ylab="Test", at=seq(0,1,by=0.05), main='Normalbedingungen')






#_________________________________________________________________________________________________________
############################################### Saisonales Modell (komibiert) ######################################
#_________________________________________________________________________________________________________


Grid_Sarima2= as.data.frame(CJ(rho1=c(seq(-0.5,0.5, by=0.1)),rho2= c(-0.49,seq(-0.4,0.4, by=0.1),0.49)))




### n=20

AR1_20_Sarima2_DW=RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='Durbin-Watson')

AR1_20_Sarima2_3VZ=RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='3-VZ')

AR1_20_Sarima2_4VZ=RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='4-VZ')

AR1_20_Sarima2_5VZ=RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='5-VZ')

AR1_20_Sarima2_Sign= RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='Runs')

AR1_20_Sarima2_DifRuns= RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='DifRuns')

AR1_20_Sarima2_TP= RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='Turning-Point')

AR1_20_Sarima2_BDS= RejratesS2(reps=10, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='BDS')

AR1_20_Sarima2_LB= RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='Ljung-Box')

AR1_20_Sarima2_VNR= RejratesS2(reps=100, n=20,a=4,b=7,testgrid= Grid_Sarima2, test='VonNeumannRang')


#### Heatmap Plots


L_AR1_20_Sarima2_DW=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                                    main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sarima2_LB=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                             main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_BDS=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                              main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_20_Sarima2_Sign=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                               main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_TP=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                             main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_VNR=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_3VZ=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_4VZ=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                              main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_20_Sarima2_5VZ=levelplot(Rej ~ rho1*rho2, data=AR1_20_Sarima2_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                              main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_20_Sarima2_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_20_Sarima2_5VZ,split = c(3, 3, 3, 3), more = FALSE)



### n=100

AR1_100_Sarima2_DW=RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='Durbin-Watson')

AR1_100_Sarima2_3VZ=RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='3-VZ')

AR1_100_Sarima2_4VZ=RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='4-VZ')

AR1_100_Sarima2_5VZ=RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='5-VZ')

AR1_100_Sarima2_Sign= RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='Runs')

AR1_100_Sarima2_DifRuns= RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='DifRuns')

AR1_100_Sarima2_TP= RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='Turning-Point')

AR1_100_Sarima2_BDS= RejratesS2(reps=10, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='BDS')

AR1_100_Sarima2_LB= RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='Ljung-Box')

AR1_100_Sarima2_VNR= RejratesS2(reps=100, n=500,a=5,b=7,testgrid= Grid_Sarima2, test='VonNeumannRang')


#### Heatmap Plots


L_AR1_100_Sarima2_DW=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_DW  ,pretty=T,layers=1,xlab="saisonalitt", ylab="rho",
                              main="Durbin-Watson",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sarima2_LB=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_LB  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main='Ljung-Box',col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_BDS=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_BDS, pretty=T,layers=1,xlab="season", ylab="rho",
                               main="BDS",col.regions=magma, at=seq(0,1,by=0.05))

L_AR1_100_Sarima2_Sign=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_Sign, pretty=T,layers=1,xlab="season", ylab="rho",
                                main="Runs-Test",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_TP=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_TP  ,pretty=T,layers=1,xlab="season", ylab="rho",
                              main="Turning-Point",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_VNR=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_VNR  ,pretty=T,layers=1,xlab="season", ylab="rho",
                               main="VonNeumann-Rangtest",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_3VZ=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_3VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                               main="3-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_4VZ=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_4VZ  , pretty=T,layers=1,xlab="season", ylab="rho",
                               main="4-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))

L_AR1_100_Sarima2_5VZ=levelplot(Rej ~ rho1*rho2, data=AR1_100_Sarima2_5VZ  ,pretty=T, layers=1,xlab="season", ylab="rho",
                               main="5-Sign-Depth",col.regions=magma, at=seq(0,1,by=0.01))



print(L_AR1_100_Sarima2_DW, split = c(1, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_LB, split = c(2, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_BDS, split = c(3, 1, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_Sign,split = c(1, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_TP, split = c(2, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_VNR, split = c(3, 2, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_3VZ, split = c(1, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_4VZ, split = c(2, 3, 3, 3), more = TRUE)
print(L_AR1_100_Sarima2_5VZ,split = c(3, 3, 3, 3), more = FALSE)


















##############################  AUsprobieren von Zeug

# 2 parallel apllys
start_time <- Sys.time()
AR1_20_DW_S3.10=Rejrates(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson', shockint=10, shockno=3)
stop_time <- Sys.time()
stop_time - start_time

# 0parallel apply

start_time <- Sys.time()
AR1_20_DW_S3.10=Rejrates2(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1, test='Durbin-Watson', shockint=10, shockno=3)
stop_time <- Sys.time()
stop_time - start_time




cor.test( method="kendall")


for(i in 1:2){arima.sim(list(order=c(2,0,0), ar=as.numeric(Grid_AR2[1,]),mean=0),innov=rnorm(20), n=20)}

arima.sim(list(order=c(2,0,0), ar=as.numeric(Grid_AR2[2,]),mean=0),innov=rnorm(20), n=20)




#### Nichtlineare Modelle
n=20
theta1= 0.2
theta2= 1
innovs= as.complex(rnorm(n+100,sd=0.1))

dats=complex(n+100)
dats[1] <- 0
dats[2] <- theta1* (dats[1]^theta2) + innovs[2]

for(i in (3:(n+100))){
  dats[i] =  dats[i-1] + theta1 * (dats[i-1] ^theta2) + innovs[i]
  
}

sim_data= Re(dats[101:(n+100)])

### nls



nlar(matrix(Re(sim_data)), lag=1, power=1)


auto.arima(Re(dats))

auto.arima(Re(sim_data))

dwtest(Re(sim_data)~ 1+seq(1,20), alternative= 'two.sided')$p


##### Saisonale Modelle (Sarima)


sim_data= sim_sarima(n=n, model= list(ar=c(rep(0,season-1),rho)))


##### multiplikatives MA modell
rho=0.5
innovs= rnorm(20)
dats= vector(mode='double', length=20)
dats[1]= innovs[1]

for(i in 2:20){
  dats[i]= innovs[i-1]*(rho + innovs[i])
  
}

### bilineares Modell

rho=0.5
a=0.4
innovs= rnorm(20)
dats= vector(mode='double', length=20)
dats[1]= innovs[1]

for(i in 2:20){
  dats[i]= dats[i-1]*(rho + a*innovs[i-1]) + innovs[i]
  
}



### threshold model

rho=0.5
innovs= rnorm(20)
dats= vector(mode='double', length=20)
dats[1]= innovs[1]

for(i in 2:20){
  if( dats[i-1]<=0){
    dats[i]= (-rho)*dats[i-1] + innovs[i]
  } else {
    dats[i]= (rho)*dats[i-1] + innovs[i]
  }
}

##### INAR model

Y= vector(mode='integer', length=n)
lambda= 3
Y[0]=0
for(t in 2:n){
Y[t]=rbinom(1,Y[t-1],rho)+rpois(1,lambda)}


##### Saisonales Modell (4 + 7)
a=4
ar1=0.5
ar2=0.3
b=7

Y=sim_sarima(n,model=list(ar=c(rep(0,(a-1)),ar1,rep(0,(b-1)),ar2)))




#### Wachsende Varianz
innovs= vector(mode='integer', length=n)
sdw= seq(from=1,to=4,length.out=n)
for(i in 1:length(innovs)){
  innovs[i]=rnorm(mean=0,sd=sdw[i],n=1)
}

#### Mit Sprung

sim_data=arima.sim(list(order=order, ar=rho,mean=mean), n=n)
sim_data[floor(length(sim_data)/2):length(sim_data)]=sim_data[floor(length(sim_data)/2):length(sim_data)]+hhe





#_________________________________________________________________________________________________________
############################################### Plots ######################################
#_________________________________________________________________________________________________________

#_________________________________________________________________________________________________________
############################################### AR(1) ######################################
#_________________________________________________________________________________________________________


### ACF 

windows(width=7, height=5)
acf(arima.sim(model=list(order=c(1,0,0),ar=0.7),n=100),main="")

### Zeitreihen

### positiv

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, cex.axis=1.7)
AR1_pos=arima.sim(model=list(order=c(1,0,0),ar=0.7),n=100)
plot(AR1_pos, xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(AR1_pos),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')


### negativ

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, cex.axis=1.7)
AR1_neg=arima.sim(model=list(order=c(1,0,0),ar=-0.7),n=100)
plot(AR1_neg, xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(AR1_neg),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

### neutral

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, cex.axis=1.7)
AR1_0=rnorm(100)
plot(AR1_0, xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5, type='l')
abline(h=0,lty=2, col='red')
abline(h=median(AR1_0),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



#### Verteilungsplots

x=seq(-4, 4, length=200)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))
plot(x,dnorm(x),type='l', xlab='x', ylab='Dichte f(x)', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
lines(x,dt(x,df=1),type='l',col='blue')
lines(x,dt(x,df=5),type='l',col='red')
legend("topright", inset=.05, title="Verteilungen",
       c('Normal','Cauchy','t(5)'), lwd=2, lty=c(1, 1, 1), col=c('black','blue','red'))
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



#### Plots Cauchy-Verteilung

shock=rt(df=1,n=500)



windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, cex.axis=1.7)
AR1_t=arima.sim(list(order=order, ar=0.5,mean=mean),innov=shock, n=100)
plot(AR1_t, xlab='Index', ylab='', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(AR1_t),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')


#### acf plot Vergleich
windows(width=7, height=5)

AR1_t=arima.sim(list(order=order, ar=0.07,mean=mean),innov=shock, n=500)
acf(AR1_t,main="", cex.lab=1.5, cex.axis=1.7)


windows(width=7, height=5)
AR1_n =arima.sim(list(order=order, ar=0.07,mean=mean), n=500)
acf(AR1_n,main="", cex.lab=1.5, cex.axis=1.7)

###
2*(1-pnorm(5))
2*(1-pt(5, df=1))
2*(1-pt(5, df=5))


#### Plots Extremwertverteilung

x=seq(-8, 8, length=400)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))
plot(x,dnorm(x),type='l', xlab='x', ylab='Dichte f(x)', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
lines(x,dgumbel(x,scale=3),type='l',col='blue')
lines(x,ddexp(x,scale=2),type='l',col='red')
legend("topright", inset=.05, title="Verteilungen",
       c('Normal','Gumbel','Laplace'), lwd=2, lty=c(1, 1, 1), col=c('black','blue','red'))
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

(1-pgumbel(5, scale=3))+ pgumbel(-5, scale=3)
2*(1-pdexp(5, scale=2))



####  Kontaminationen-PLot

windows(width=7, height=5)

AR1_neg=arima.sim(model=list(order=c(1,0,0),ar=0.2),n=500)
AR1_neg[sample(seq(1:length(AR1_neg)),25)]= AR1_neg[sample(seq(1:length(AR1_neg)),25)]+sample(c(-1,1),25,replace=T)*10
acf(AR1_neg,main="",cex.lab=1.5,cex.axis=1.7)






#### wachsende Varianz

innovs= vector(mode='integer', length=100)
sdw= seq(from=1,to=100/10,length.out=100)
for(i in 1:length(innovs)){
  innovs[i]=rnorm(mean=0,sd=sdw[i],n=1)
}

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, lwd=1.7,cex.axis=1.7)
AR1_WVar=arima.sim(list(order=c(1,0,0), ar=0.5,mean=mean),innov=innovs, n=100)
plot(AR1_WVar, xlab='Index', ylab='', xaxt='n', yaxt='n')
abline(h=0,lty=2, col='red')
abline(h=median(AR1_WVar),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')





### Korrelogramme

innovs= vector(mode='integer', length=500)

AR1_WVar=arima.sim(list(order=c(1,0,0), ar=0.01,mean=mean), n=500)
windows(width=7, height=5)
acf(AR1_WVar, main="",cex.lab=1.5,cex.axis=1.7)

sdw= seq(from=1,to=500/10,length.out=500)
for(i in 1:length(innovs)){
  innovs[i]=rnorm(mean=0,sd=sdw[i],n=1)
}
AR1_WVar=arima.sim(list(order=c(1,0,0), ar=0.01,mean=mean),innov=innovs, n=500)
acf(AR1_WVar, main="",cex.lab=1.5,cex.axis=1.7)



#### Sprung
sim_data=arima.sim(list(order=c(1,0,0), ar=-0.65), n=100)
sim_data[floor(length(sim_data)/2):length(sim_data)]=sim_data[floor(length(sim_data)/2):length(sim_data)]+1.96/2
sim_data[1:floor(length(sim_data)/2)-1]=sim_data[1:floor(length(sim_data)/2)-1]-1.96/2
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7, lwd=1.5)

plot(sim_data, xlab='Index', ylab='', xaxt='n', yaxt='n')
abline(h=0,lty=2, col='red')
abline(h=median(AR1_WVar),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



acf(sim_data, main="", cex.lab=1.5,cex.axis=1.7)

dwtest(sim_data~seq(1:500), alternative = "two.sided")




### Drift
sim_data=arima.sim(list(order=order, ar=-0.01), n=100)
sim_data= sim_data  + drift/n *seq(-n/2,n/2-1)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, lwd=1.5,cex.axis=1.7)

plot(sim_data, xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(AR1_WVar),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



acf(sim_data, main="",cex.lab=1.5,cex.axis=1.7)





### AR(2)


### Param.

sim_data=arima.sim(list(order=c(2,0,0), ar=c(0.01,0.01)), n=100)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7)

plot(sim_data, xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

acf(sim_data, main="", cex.lab=1.5, cex.axis=1.7)

dw= dwtest(sim_data~ 1+seq(1,500), alternative= 'two.sided')$p
# bg=bgtest(sim_data~1 + seq(1,n))$p.value
lb=Box.test(sim_data, lag = 1, type = "Ljung-Box", fitdf = 0)$p.value



#### Turning-Point
AR2_500_TP[which(AR2_500_TP$Rej<0.1),]


sim_data=arima.sim(list(order=c(2,0,0), ar=c(0.001,0)), n=100)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))

plot(sim_data, xlab='Index', ylab='', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

turningpoint.test(sim_data)



#### Kontaminationen
AR2_500_LB_Kont5[which(AR2_500_LB_Kont5$Rej < 0.05),]

windows(width=7, height=5)
sim_data=arima.sim(list(order=c(2,0,0), ar=c(-0.3,-0.5)), n=500)
plot(sim_data, xlab='Index', ylab='', xaxt='n', yaxt='n')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

acf(sim_data,main='', cex.lab=1.5, cex.axis=1.7)
Kont=sample(seq(1:length(sim_data)),25)
sim_data[Kont]= sim_data[Kont]+sample(c(-1,1),25,replace=T)*10
acf(sim_data,main="", cex.lab=1.5, cex.axis=1.7)




#### Sarima
season=5

sim_data=sim_sarima(n=100, model= list(ar=c(rep(0,season-1),-0.9)))
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7)

plot(sim_data,type='l', xlab='Index', ylab='', xaxt='n', yaxt='n')
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

windows(width=7, height=5)
acf(sim_data, main='', cex.lab=1.5, cex.axis=1.7)
lb.test(sim_data, lag=15)



######### Moving Average


sim_data=arima.sim(list(order=c(0,0,1), ma=-4,mean=0), n=100)
windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7)
plot(sim_data,type='l', xlab='Index', ylab='', xaxt='n', yaxt='n')
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')
windows(width=7, height=5)
acf(sim_data, main='', cex.lab=1.5, cex.axis=1.7)


#### Funktion
PlotACF= function(x){
  Werte=rep(0, length(x))
  for(i in 1:length(x)){
    Werte[i]= x[i]/(1+ x[i]^{2})}
return(Werte)
}

x= seq(-30,30, by=0.01)

windows(width=7, height=5)
plot(x, PlotACF(x), type='l', xlab=TeX('$\\nu_{1}$'), ylab=TeX('f($\\nu_{1})'), xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')











####### Oszillationen Test

### Abtastrate

sim_data=arima.sim(list(order=c(1,0,0), ar=0.01,mean=0), n=100)
Amp=2
sim_data2=sim_data

n=length(sim_data)
cospoints=seq(1,10,length=n)
for(i in 1:n){
  sim_data[i]=sim_data[i]+ Amp*cos(cospoints[i])
}


windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7,lwd=1.5)

plot(sim_data,type='l', xlab='Index', ylab='', xaxt='n', yaxt='n', cex.lab=1.7,cex.axis=1.7, lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

plot(acf(sim_data),main='', cex.lab=1.5,cex.axis=1.7)


### Lnge
cospoints2=seq(1,n/2,length=n)
for(i in 1:n){
  sim_data2[i]=sim_data2[i]+ Amp*cos(cospoints2[i])
}

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7,cex.axis=1.7,lwd=1.5)

plot(sim_data2,type='l', xlab='Index', ylab='', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
abline(h=0,lty=2, col='red')
abline(h=median(sim_data2),lty=2, col='blue')
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



######################### Ausprobieren des maximalen K's
N=20
signsim= rep(c(0,1),N/2)
  
vz3=pdepth(calcDepth(sign_sim,K=10, transform=T, linear=FALSE),N=N,K=10, transform=T)







######### Moving Avegae: Tunring points

###Expected= 2/3*98= 65  Var= 17.455

Tps=vector()
for(i in 1:1000){

sim_data=arima.sim(list(order=c(0,0,1), ma=-0.5,mean=0), n=100)


Tps=c(Tps,turnpoints(sim_data)$nturns)
}

abs(turnpoints(sim_data)$nturns-65)/sqrt(17.455)

turningpoint.test(sim_data)


abs(71.44-65)/sqrt(17.455)



#### Ablehnungsbereich VZT-Tests

Raster= cbind(seq(0,0.05,by=0.00001),(0.05-seq(0,0.05,by=0.00001)))
###K=3
n=20
Intlength=vector()
for(i in 1:dim(Raster)[1]){

Intlength=c(Intlength,qdepth(p=1-Raster[i,2], N=n,K=3)-qdepth(p=Raster[i,1], N=n,K=3))}

Raster[which.min(Intlength),]

qdepth(0.00095,N=n,K=3,transform=TRUE)
qdepth(0.04905,N=n,K=3,transform=TRUE)-qdepth(0.00095,N=n,K=3,transform=TRUE)

Raster= cbind(seq(0,0.05,by=0.00001),(0.05-seq(0,0.05,by=0.00001)))

###K=4
Intlength=vector()
for(i in 1:dim(Raster)[1]){
  
  Intlength=c(Intlength,qdepth(p=1-Raster[i,2], N=100,K=4)-qdepth(p=Raster[i,1], N=100,K=4))}

Raster[which.min(Intlength),]

qdepth(0.00235,N=n,K=4,transform=TRUE)
qdepth(0.04765,N=n,K=4,transform=TRUE)-qdepth(0.00235,N=n,K=4,transform=TRUE)

Raster= cbind(seq(0,0.05,by=0.00001),(0.05-seq(0,0.05,by=0.00001)))
###K=5
Intlength=vector()
for(i in 1:dim(Raster)[1]){
  
  Intlength=c(Intlength,qdepth(p=1-Raster[i,2], N=100,K=5)-qdepth(p=Raster[i,1], N=100,K=5))}

Raster[which.min(Intlength),]

qdepth(0.00355,N=n,K=5,transform=TRUE)
qdepth(0.04645,N=n,K=5,transform=TRUE)-qdepth(0.00355,N=n,K=5,transform=TRUE)

#### innovative Ausreier

n=100
schockno=5
schockint=10
schocktime= sample(seq(1:100),schockno, replace=FALSE)

shock=rnorm(n)


shock[schocktime]= sample(c(-1,1),schockno,replace=T)*schockint
sim_data=arima.sim(list(order=c(1,0,0), ar=-0.2,mean=mean),innov=shock, n=n)


windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2.5,2.2,1), cex.axis=1.7,cex.lab=1.7)
plot(sim_data[(schocktime-4):(schocktime+15)],type='p', xlab='Index', ylab='',ylim=c(-11,11), xaxt='n', yaxt='n', lwd=1.5, pch=19)
abline(h=0,lty=2, col='red')
abline(h=median(sim_data),lty=2, col='blue')
magaxis(side = 1:2, majorn =c(5,5), minorn = c(5,5), tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')


windows(width=7, height=5)
acf(sim_data, main='', cex.axis=1.7,cex.lab=1.5)



##### Innovationen ermitteln (mit + ohne ausreier)

Korrvektor=seq(-0.99,0.99,by=0.01)
Trackvektor=rep(0,length(Korrvektor))
for (i in 1:length(Korrvektor)){
  
  Countvec=rep(0,100)
  for(j in 1:100){
  shock=rnorm(n)
  
  #schocktime= sample(seq(1:n),schockno, replace=FALSE)
 # shock[schocktime]= sample(c(-1,1),schockno,replace=T)*schockint
  sim_data=arima.sim(list(order=c(1,0,0), ar=Korrvektor[i],mean=mean),innov=shock, n=n)
  shocktime=sample(1:n,shockno)
  sim_data[konttime]= sim_data[konttime]+sample(c(-1,1),kontno,replace=T)*kontint
  
  Inov= as.numeric(acf(sim_data, lag.max = 15, plot = FALSE)[[1]][2])
    

  Countvec[j]=Inov-Korrvektor[i]
  }
  
  Trackvektor[i]=mean(Countvec) 
  

}




windows(width=7, height=5)
plot(Korrvektor,Trackvektor,type='p', xlab=TeX('$\\rho_{1}$'), ylab='', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5, pch=19)
abline(h=0, lty=2, col='red')
abline(v=0,lty=2, col='blue')
magaxis(side = 1:2, majorn =c(5,5), minorn = c(5,5), tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')




###### Dichten der Vorzeichentiefen

x3=seq(-1.5,1.5,length=100000)
fx3= ddepth(x3,N=10000,K=3, transform=TRUE)

x4=seq(-1.5,1.5,length=100000)
fx4= ddepth(x4,N=10000,K=4, transform=TRUE)

x5=seq(-1.5,1.5,length=100000)
fx5= ddepth(x5,N=10000,K=5, transform=TRUE)


windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))
plot(x3,fx3,,type='l', xlab='x', ylab='Dichte f(x)', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5,ylim=c(0,1.5))
lines(x4,fx4,type='l',col='blue')
lines(x5,fx5,type='l',col='red')
legend("topright", inset=.05, title="Verteilungen",
       c('3-VZT','4-VZT','5-VZT'), lwd=2, lty=c(1, 1, 1), col=c('black','blue','red'))
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



#####Ausprobieren der Vereinfachten Vorzeichentiefe #####
#########################################################################################

#n=100

AR1_100_Simp=RejratesSimp(reps=100, n=100,order=c(1,0,0),K=2,testgrid= Grid_AR1_Simple)

Gem_AR1_100_Simp = AR1_100_Simp$Rej[c(5,6,8),]
rownames(Gem_AR1_100_Simp)<- c('Runs','Simp','3-VZ')
colnames(Gem_AR1_100_Simp) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Simp_Levelplot=levelplot(t(Gem_AR1_100_Simp),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Simp_Levelplot)
update(AR1_100_Simp_Levelplot, aspect=0.5)


#n=20

AR1_20_Simp=RejratesSimp(reps=100, n=20,order=c(1,0,0),testgrid= Grid_AR1_Simple)
Gem_AR1_20_Simp_K2 = AR1_20_Simp$Rej[seq(1:10)[-3][c(1:4,9,5:8)],]
rownames(Gem_AR1_20_Simp_K2)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs','Turning-Point','Simp. 2-VZ','Simp. 3-VZ','Simp. 4-VZ','Simp. 5-VZ ')
colnames(Gem_AR1_20_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Simp_K2_Levelplot=levelplot(t(Gem_AR1_20_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Simp_K2_Levelplot)
update(AR1_20_Simp_K2_Levelplot, aspect=0.5)

#n=50

AR1_50_Simp=RejratesSimp(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)

AR1_50_Simp_Dif=RejratesSimpDif(reps=100, n=50,order=c(1,0,0),testgrid= Grid_AR1_Simple)


Gem_AR1_50_Simp_K2 = AR1_50_Simp$Rej[seq(1:10)[-3][c(1:4,9,5:8)],]
rownames(Gem_AR1_50_Simp_K2)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs','Turning-Point','Simp. 2-VZ','Simp. 3-VZ','Simp. 4-VZ','Simp. 5-VZ ')
colnames(Gem_AR1_50_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Simp_K2_Levelplot=levelplot(t(Gem_AR1_50_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Simp_K2_Levelplot)
update(AR1_50_Simp_K2_Levelplot, aspect=0.5)

#n=100

AR1_100_Simp=RejratesSimp(reps=100, n=100,order=c(1,0,0),testgrid= Grid_AR1_Simple)

Gem_AR1_100_Simp_K2 = AR1_100_Simp$Rej[seq(1:10)[-3][c(1:4,9,5:8)],]
rownames(Gem_AR1_100_Simp_K2)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs','Turning-Point','Simp. 2-VZ','Simp. 3-VZ','Simp. 4-VZ','Simp. 5-VZ ')
colnames(Gem_AR1_100_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Simp_K2_Levelplot=levelplot(t(Gem_AR1_100_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Simp_K2_Levelplot)
update(AR1_100_Simp_K2_Levelplot, aspect=0.5)

#n=500

AR1_500_Simp=RejratesSimp(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)


AR1_500_Simp_Dif=RejratesSimpDif(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Simple)





Gem_AR1_500_Simp_K2 = AR1_500_Simp$Rej[seq(1:10)[-3][c(1:4,9,5:8)],]
rownames(Gem_AR1_500_Simp_K2)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs','Turning-Point','Simp. 2-VZ','Simp. 3-VZ','Simp. 4-VZ','Simp. 5-VZ ')
colnames(Gem_AR1_500_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Simp_K2_Levelplot=levelplot(t(Gem_AR1_500_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Simp_K2_Levelplot)
update(AR1_500_Simp_K2_Levelplot, aspect=0.5)


######### Gemeinsamer Plot







### Vergleiche

Gem_AR1_500_Simp_Vergleich= rbind(AR1_50_Simp_Dif$Rej[7,],AR1_50_Simp$Rej[10,],AR1_500_Simp_Dif$Rej[7,],AR1_500_Simp$Rej[10,])

rownames(Gem_AR1_500_Simp_Vergleich)<- c('SimpK3, N=50','Dif-TP, N=50', 'SimpK3, N=500','Dif-TP, N=500')
colnames(Gem_AR1_500_Simp_Vergleich) <- c(seq(-0.99,0.99,by=0.01))

AR1_500_Simp_Vergleich_Levelplot=levelplot(t(Gem_AR1_500_Simp_Vergleich),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))


windows(width=10,height=7)                                                                                  
plot(AR1_500_Simp_Vergleich_Levelplot)
update(AR1_500_Simp_Vergleich_Levelplot, aspect=0.5)



#n=5000

AR1_5000_Simp=RejratesSimp(reps=100, n=5000,order=c(1,0,0),K=2,testgrid= Grid_AR1_Simple)

Gem_AR1_5000_Simp = AR1_5000_Simp$Rej[c(5,6,8),]
rownames(Gem_AR1_5000_Simp)<- c('Runs','Simp','3-VZ')
colnames(Gem_AR1_5000_Simp) <- c(seq(-0.99,0.99,by=0.01))


AR1_5000_Simp_Levelplot=levelplot(t(Gem_AR1_5000_Simp),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_5000_Simp_Levelplot)
update(AR1_5000_Simp_Levelplot, aspect=0.5)


###### Andere Simple Teststatistiken + Ablehnungsbereiche ####

###K=3
sumK3=vector()
for(i in 1:(n-2)){
  sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
}
TestK3= (1/(n-2)) * sum(sumK3)

StatK3= sqrt(n-2)* ((TestK3- (1/2)^2)/sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2)))



###n=20
n=50
critVals= qnorm(0.025,sd=(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2)))/(sqrt(n-2)),mean=(1/2)^2)*((n-2))
#20= -0.148,  20=4.4

Grid_AR1_Simple=Grid_AR1_Simple[-(which(Grid_AR1_Simple==0))]

MeanK3=vector()
for(i in 1:length(Grid_AR1_Simple)){
  VZvec3=vector() 
  for(j in 1:1000){
    sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=n)
    sumK3=vector()
    for(k in 1:(n-2)){
      sumK3=c(sumK3,(as.numeric(sim_data[k]*(-1)>0)*as.numeric(sim_data[k+1]*(1)>0)*as.numeric(sim_data[k+2]*(-1)>0) + as.numeric(sim_data[k]*(1)>0)*as.numeric(sim_data[k+1]*(-1)>0)*as.numeric(sim_data[k+2]*(1)>0)))
       }
     VZvec3=c(VZvec3,sum(sumK3))
  }
  MeanK3=c(MeanK3,mean(VZvec3))
}

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab=1.7, cex.axis=1.7)
plot(Grid_AR1_Simple,MeanK3,type='p',pch=20, xlab=TeX('$\\rho_{1}$'), ylab='Anzahl der 3-VZW', xaxt='n', yaxt='n', lwd=1.5)
abline(v=0,col='red',lty=2)

magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')




###K=4
sumK4=vector()
for(i in 1:(n-3)){
  sumK4=c(sumK4,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)))
}
TestK4= (1/(n-3)) * sum(sumK4)
StatK4= sqrt(n-3)* ((TestK4- (1/2)^3)/(sqrt((1/2)^3*(3-(1/2)^2*3-3*(1/2)^3))))


MeanK4=vector()
for(i in 1:length(Grid_AR1_Simple)){
  VZvec4=vector() 
  for(j in 1:100){
    sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=n)
    sumK4=vector()
    for(k in 1:(n-3)){
      sumK4=c(sumK4,(as.numeric(sim_data[k]*(-1)>0)*as.numeric(sim_data[k+1]*(1)>0)*as.numeric(sim_data[k+2]*(-1)>0)*as.numeric(sim_data[k+3]*(1)>0) + as.numeric(sim_data[k]*(1)>0)*as.numeric(sim_data[k+1]*(-1)>0)*as.numeric(sim_data[k+2]*(1)>0)*as.numeric(sim_data[k+3]*(-1)>0)))
    }
    VZvec4=c(VZvec4,sum(sumK4))
  }
  MeanK4=c(MeanK4,mean(VZvec4))
}






###K=5
sumK5=vector()
for(i in 1:(n-4)){
  sumK5=c(sumK5,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0)*as.numeric(sim_data[i+3]*(1)>0)*as.numeric(sim_data[i+4]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)*as.numeric(sim_data[i+3]*(-1)>0)*as.numeric(sim_data[i+4]*(1)>0)))
}
TestK5= (1/(n-4)) * sum(sumK5)
StatK5= sqrt(n-4)* ((TestK4- (1/2)^4)/(sqrt((1/2)^4*(3-(1/2)^3*4-3*(1/2)^4))))



MeanK5=vector()
for(i in 1:length(Grid_AR1_Simple)){
  VZvec5=vector() 
  for(j in 1:100){
    sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=n)
    sumK5=vector()
    for(k in 1:(n-4)){
      sumK5=c(sumK5,(as.numeric(sim_data[k]*(-1)>0)*as.numeric(sim_data[k+1]*(1)>0)*as.numeric(sim_data[k+2]*(-1)>0)*as.numeric(sim_data[k+3]*(1)>0)*as.numeric(sim_data[k+4]*(-1)>0) + as.numeric(sim_data[k]*(1)>0)*as.numeric(sim_data[k+1]*(-1)>0)*as.numeric(sim_data[k+2]*(1)>0)*as.numeric(sim_data[k+3]*(-1)>0)*as.numeric(sim_data[k+4]*(1)>0)))
    }
    VZvec5=c(VZvec5,sum(sumK5))
  }
  MeanK5=c(MeanK5,mean(VZvec5))
}

##### Verteilung Simplified n=500


windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))
plot(Grid_AR1_Simple,MeanK3,type='p',pch=20, xlab=TeX('$\\rho_{1}$'), ylab='Anzahl der K-VZW', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
points(Grid_AR1_Simple,MeanK4,type='p',pch=20, col='red')
points(Grid_AR1_Simple,MeanK5,type='p',pch=20, col='blue')
abline(v=0,col='red',lty=2)
legend("topright", inset=.05,
       c('3-VZW','4-VZW','5-VZW'), lwd=2, lty=c(1, 1, 1), col=c('black','red','blue'))
magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')


##### Kerndichteschtzer

###K=3
n=500
DVZW=vector()
for(j in 1:10000){
  sim_data=rnorm(1000)
  sumK3=vector()
  for(i in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[i]*(-1)>0)*as.numeric(sim_data[i+1]*(1)>0)*as.numeric(sim_data[i+2]*(-1)>0) + as.numeric(sim_data[i]*(1)>0)*as.numeric(sim_data[i+1]*(-1)>0)*as.numeric(sim_data[i+2]*(1)>0)))
  }
  DVZW=c(DVZW,sum(sumK3))
}

plot(density(DVZW))


###K=4

DVZW4=vector()
for(j in 1:10000){
  sim_data=rnorm(1000)
  sumK4=vector()
  for(k in 1:(n-2)){
    sumK4=c(sumK4,(as.numeric(sim_data[k]*(-1)>0)*as.numeric(sim_data[k+1]*(1)>0)*as.numeric(sim_data[k+2]*(-1)>0)*as.numeric(sim_data[k+3]*(1)>0) + as.numeric(sim_data[k]*(1)>0)*as.numeric(sim_data[k+1]*(-1)>0)*as.numeric(sim_data[k+2]*(1)>0)*as.numeric(sim_data[k+3]*(-1)>0)))
  }
  DVZW4=c(DVZW4,sum(sumK4))
}

plot(density(DVZW4))


####### Turning-Point-Verteilung


#### AR(1)
Tpvector=vector()
for(i in 1:length(Grid_AR1_Simple)){
  sumvector=vector()
  for(j in 1:100){
 sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=20)

    sumvector=c(sumvector,turnpoints(sim_data)$nturns)
  }
  Tpvector= c(Tpvector,mean(sumvector))
}

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1))
plot(Grid_AR1_Simple,Tpvector,type='p',pch=20, xlab=TeX('$\\rho_{1}$'), ylab='Anzahl der Turning-Points', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
abline(h=0,col='red',lty=2)

magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



#### MA(1)
Tpvector=vector()
for(i in 1:length(Grid_MA)){
  sumvector=vector()
  for(j in 1:1000){
    sim_data=arima.sim(list(order=c(0,0,1), ma=Grid_MA[i],mean=0), n=100)
    
    sumvector=c(sumvector,turnpoints(sim_data)$nturns)
  }
  Tpvector= c(Tpvector,mean(sumvector))
}

windows(width=7, height=5)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab= 1.7,cex.axis=1.3)
plot(Grid_MA,Tpvector,type='p',ylim=c(45,75),xlim=c(-5,5),pch=20, xlab=TeX('$\\nu_{1}$'), ylab='Anzahl der Turning-Points', xaxt='n', yaxt='n', cex.lab=1.3, lwd=1.5)
abline(v=0,col='red',lty=2)

abline(h=qnorm(0.025,mean=2/3*98,sd=sqrt((16*100-29)/90)),col='blue',lty=2)
abline(h=qnorm(0.975,mean=2/3*98,sd=sqrt((16*100-29)/90)),col='blue',lty=2)



magaxis(side = 1:2, majorn = 10, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')


##### Tiefe Verteilung

VZWvector=vector()
for(i in 1:length(Grid_AR1_Simple)){
  sumvector=vector()
  for(j in 1:100){
    sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=100)
    
    sumvector=c(sumvector,calcDepth(sim_data,K=3, transform=T)*choose(100,3))
  }
  VZWvector= c(VZWvector,mean(sumvector))
}






#### Vergleich Turning-Points und V3-VZT:

### Orginal Zeitreihen

TP_3VZ= rbind(AR1_20_Simple$Rej[6,],AR1_20_Simp$Rej[7,],AR1_50_Simple$Rej[6,],AR1_50_Simp$Rej[7,],AR1_100_Simple$Rej[6,],AR1_100_Simp$Rej[7,],AR1_500_Simple$Rej[6,],AR1_500_Simp$Rej[7,])

rownames(TP_3VZ)<- c('TP mit N=20','3-VZW mit N=20','TP mit N=50','3-VZW mit N=50','TP mit N=100','3-VZW mit N=100','TP mit N=500','3-VZW mit N=500')
colnames(TP_3VZ) <- c(seq(-0.99,0.99,by=0.01))


TP_3VZ_Levelplot=levelplot(t(TP_3VZ),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(TP_3VZ_Levelplot)
update(TP_3VZ_Levelplot, aspect=0.5)

###Differenziert




#### Ablehnung + Konsistenzeigenschaften ####
###K=3

### n=50

n=500
DVZW=vector()

for(i in 1:length(Grid_AR1_Simple)){
sumcount=vector()
for(j in 1:100){
  
   sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple[i],mean=0), n=n)  
   sumK3=vector()
  for(k in 1:(n-2)){
    sumK3=c(sumK3,(as.numeric(sim_data[k]*(-1)>0)*as.numeric(sim_data[k+1]*(1)>0)*as.numeric(sim_data[k+2]*(-1)>0) + as.numeric(sim_data[k]*(1)>0)*as.numeric(sim_data[k+1]*(-1)>0)*as.numeric(sim_data[k+2]*(1)>0)))
  }
   sumcount=c(sumcount,sum(sumK3))
}
  DVZW=c(DVZW,mean(sumcount))
}




SimpK3_025=((qnorm(0.025)/sqrt(n-2))*(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))) + (1/2)^2) *(n-2)
SimpK3_975=((qnorm(0.975)/sqrt(n-2))*(sqrt((1/2)^2*(3-(1/2)^1*2-3*(1/2)^2))) + (1/2)^2) *(n-2)

windows(width=10,height=7)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(4,2,1),mar=c(5.1, 5.5, 4.1, 2.1), cex.lab=2.2, cex.axis=2.2)
plot(Grid_AR1_Simple,DVZW,type='p',pch=20, xlab=TeX('$\\rho_{1}$'), ylab='Anzahl der 3-VZW', xaxt='n', yaxt='n')
abline(h=SimpK3_025,col='red',lty=2)
abline(h=SimpK3_975,col='red',lty=2)

magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,1,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')



#### 3- Vorzeichentiefe
Grid_VZW_Simple=seq(-0.9,0.9,by=0.01)
Depthvec=vector()
for(i in 1:length(Grid_VZW_Simple)){
  sumcount=vector()
  for(j in 1:100){
    
    sim_data=arima.sim(list(order=c(1,0,0), ar=Grid_VZW_Simple[i],mean=0), n=n)  
 
      sumcount=c(sumcount,(calcDepth(sim_data, K=3, transform=FALSE, exact=TRUE))*choose(n,3))

  }
  Depthvec=c(Depthvec,mean(sumcount))
}


UQuant=((qdepth(0.025,K=3,transform=TRUE,N=n)/n)+0.25)*choose(n,3)
OQuant=((qdepth(0.975,K=3,transform=TRUE,N=n)/n)+0.25)*choose(n,3) 
  

windows(width=10,height=7)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(4,2,1),mar=c(5.1, 6, 4.1, 2.1), cex.lab=2.2, cex.axis=2.2)
plot(Grid_VZW_Simple,Depthvec/100000,type='p',pch=20, xlab=TeX('$\\rho_{1}$'), ylab='Alternierende 3-Tupel x 100000 ', xaxt='n', yaxt='n')
abline(h=UQuant/100000,col='red',lty=2)
abline(h=OQuant/100000,col='red',lty=2)

magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,1,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')

###n=500








########################################################################## Bedingte Verteilung Verinfachte Tiefe. ####

getQuantilDepthPos <- function(N = 100, simNumber = 1e5, K = 3, p) {
  data <- numeric(simNumber)
  for (n in 1:simNumber) {
    # Positionen, wo sich  (unter H0 ueberall gleich wahrscheinlich)
    positions <- sort(sample(1:N, p, replace = FALSE))
    res <- rep(-1, N)
    res[positions] <- 1
    data[n] <- calcSimpDepth(res, k = K)
  }
  return(data)
}


resPos <- function(N, p) {
  positions <- sort(sample(1:N, p, replace = FALSE))
  res <- rep(-1,N)
  res[positions] <- 1
  return(res)
}



### 2-er Tiefe
Grid_AR1_Simple_2=seq(-0.99,0.99,by=0.01)



###n=100
VZWvec=vector()
for(i in 1:length(Grid_AR1_Simple_2)){
  CounterSimp=vector()
  for(j in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=100) 
    Depth1= calcSimpDepth(sim_data,k=2)
    dataH0_2temp <- replicate(10000, calcSimpDepth(resPos(N=100, p = length(which(sim_data>0))), 2))
    Quant=quantile(dataH0_2temp, c(0.025, 0.975))
    
    CounterSimp= c(CounterSimp, as.numeric(Depth1>Quant[2]||Depth1<Quant[1]))
  }
  VZWvec=c(VZWvec,mean(CounterSimp))
  
}






###n=20

VZWvec20=vector()
for(i in 1:length(Grid_AR1_Simple_2)){
  CounterSimp20=vector()
  for(j in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=20) 
    Depth120= calcSimpDepth(sim_data,k=2)
    dataH0_2temp20 <- replicate(10000, calcSimpDepth(resPos(N=20, p = length(which(sim_data>0))), 2))
    Quant20=quantile(dataH0_2temp20, c(0.025, 0.975))
    
    CounterSimp20= c(CounterSimp20, as.numeric(Depth120>Quant20[2]||Depth120<Quant20[1]))
  }
  VZWvec20=c(VZWvec20,mean(CounterSimp20))
  
}


###n=50

VZWvec50=vector()
for(i in 1:length(Grid_AR1_Simple_2)){
  CounterSimp50=vector()
  for(j in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=50) 
    Depth150= calcSimpDepth(sim_data,k=2)
    dataH0_2temp50 <- replicate(10000, calcSimpDepth(resPos(N=50, p = length(which(sim_data>0))), 2))
    Quant50=quantile(dataH0_2temp50, c(0.025, 0.975))
    
    CounterSimp50= c(CounterSimp50, as.numeric(Depth150>Quant50[2]||Depth150<Quant50[1]))
  }
  VZWvec50=c(VZWvec50,mean(CounterSimp50))
  
}


###n=500

VZWvec500=vector()
for(i in 1:length(Grid_AR1_Simple_2)){
  CounterSimp500=vector()
  for(j in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=500) 
    Depth1500= calcSimpDepth(sim_data,k=2)
    dataH0_2temp500 <- replicate(10000, calcSimpDepth(resPos(N=500, p = length(which(sim_data>0))), 2))
    Quant500=quantile(dataH0_2temp500, c(0.025, 0.975))
    
    CounterSimp500= c(CounterSimp500, as.numeric(Depth1500>Quant500[2]||Depth1500<Quant500[1]))
  }
  VZWvec500=c(VZWvec500,mean(CounterSimp500))
  
}



#### Plot
SimpBedingt= t(rbind(VZWvec20,AR1_20_Simple$Rej[5,],AR1_20_Simp$Rej[6,],VZWvec50,AR1_50_Simple$Rej[5,],AR1_50_Simp$Rej[6,],VZWvec,AR1_100_Simple$Rej[5,],AR1_100_Simp$Rej[6,],VZWvec500,AR1_500_Simple$Rej[5,],AR1_500_Simp$Rej[6,]))

colnames(SimpBedingt)= c('Bed. 2-VZ, N=20','Runs, N=20','2-VZ, N=20','Bed. 2-VZ, N=50','Runs, N=50','2-VZ, N=50','Bed. 2-VZ, N=100', 'Runs, N=100','2-VZ, N=100','Bed. 2-VZ, N=500', 'Runs, N=500','2-VZ, N=500')
rownames(SimpBedingt)=seq(-0.99,0.99,by=0.01)

L_SimpBedingt= levelplot(SimpBedingt,panel = function(...){
  panel.levelplot(...)
  panel.abline(h = 3.5,lwd=4, col='white')
  panel.abline(h = 6.5,lwd=4, col='white')
  panel.abline(h = 9.5,lwd=4, col='white')
},colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

panel.levelplot
panel.abline

windows(width=10,height=7)
plot(L_SimpBedingt)
update(L_SimpBedingt,aspect=0.5)





#### Untersuchung : extreme Korrelationen bei 2-VZT: ####
MeanChange=vector()
for(i in 1:length(Grid_AR1_Simple_2)){
Changes=vector()
for(j in 1:1000){
sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=50) 

Signchange=vector()
for(k in 1: (length(sim_data)-1)){
  Signchange=c(Signchange,sign(sim_data[k]) - sign(sim_data[k+1]))
}
Changes=c(Changes, length(which(Signchange !=0)))
}
MeanChange=c(MeanChange,mean(Changes))
}



dataH0_2temp50 <- replicate(10000, calcSimpDepth(resPos(N=50, p = length(which(sim_data>0))), 2))
Quant50=quantile(dataH0_2temp50, c(0.025, 0.975))

#### Extreme positive Korrelationen fhren oft zu keinen Vorzeichenwechseln




################################################### Untersuchung: Verteilung in Differenzierten Zeitreihen ####

#n=20

n=20
Dif2KDepth=vector()
for ( i in 1:10000){
  sim_data=rnorm(n)
  sim_data= diff(sim_data)
  Dif2KDepth=c(Dif2KDepth,calcSimpDepth(sim_data,2))
}

QuantDif20=quantile(Dif2KDepth,probs=c(0.025,0.975))


Dif2VZT20=vector()
for(i in 1:length(Grid_AR1_Simple)){
  CountDif2=vector()
  for(k in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=20) 
    sim_data= diff(sim_data)
    CountDif2=c(CountDif2, as.numeric(calcSimpDepth(sim_data,2)<QuantDif20[1]||calcSimpDepth(sim_data,2)>QuantDif20[2]))
  }
  Dif2VZT20=c(Dif2VZT20,mean(CountDif2))
  
}


#n=50

n=50
Dif2KDepth=vector()
for ( i in 1:10000){
  sim_data=rnorm(n)
  sim_data= diff(sim_data)
  Dif2KDepth=c(Dif2KDepth,calcSimpDepth(sim_data,2))
}

QuantDif50=quantile(Dif2KDepth,probs=c(0.025,0.975))


Dif2VZT50=vector()
for(i in 1:length(Grid_AR1_Simple)){
  CountDif2=vector()
  for(k in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=50) 
    sim_data= diff(sim_data)
    CountDif2=c(CountDif2, as.numeric(calcSimpDepth(sim_data,2)<QuantDif50[1]||calcSimpDepth(sim_data,2)>QuantDif50[2]))
  }
  Dif2VZT50=c(Dif2VZT50,mean(CountDif2))
  
}

#n=100

n=100
Dif2KDepth=vector()
for ( i in 1:10000){
sim_data=rnorm(n)
sim_data= diff(sim_data)
Dif2KDepth=c(Dif2KDepth,calcSimpDepth(sim_data,2))
}

QuantDif100=quantile(Dif2KDepth,probs=c(0.025,0.975))


Dif2VZT100=vector()
for(i in 1:length(Grid_AR1_Simple)){
  CountDif2=vector()
  for(k in 1:100){
  sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=100) 
  sim_data= diff(sim_data)
  CountDif2=c(CountDif2, as.numeric(calcSimpDepth(sim_data,2)<QuantDif100[1]||calcSimpDepth(sim_data,2)>QuantDif100[2]))
  }
  Dif2VZT100=c(Dif2VZT100,mean(CountDif2))
  
}


###n=500

n=500
Dif2KDepth=vector()
for ( i in 1:10000){
  sim_data=rnorm(n)
  sim_data= diff(sim_data)
  Dif2KDepth=c(Dif2KDepth,calcSimpDepth(sim_data,2))
}

QuantDif500=quantile(Dif2KDepth,probs=c(0.025,0.975))


Dif2VZT500=vector()
for(i in 1:length(Grid_AR1_Simple)){
  CountDif2=vector()
  for(k in 1:100){
    sim_data= arima.sim(list(order=c(1,0,0), ar=Grid_AR1_Simple_2[i],mean=0), n=500) 
    sim_data= diff(sim_data)
    CountDif2=c(CountDif2, as.numeric(calcSimpDepth(sim_data,2)<QuantDif500[1]||calcSimpDepth(sim_data,2)>QuantDif500[2]))
  }
  Dif2VZT500=c(Dif2VZT500,mean(CountDif2))
  
}


#### Vergleichsplot:

TPDif2VZW= cbind(Dif2VZ20,AR1_20_Simple$Rej[6,],AR1_20_Simp$Rej[7,],Dif2VZT50,AR1_50_Simple$Rej[6,],AR1_50_Simp$Rej[7,],Dif2VZT100,AR1_100_Simple$Rej[6,],AR1_100_Simp$Rej[7,],Dif2VZT500,AR1_500_Simple$Rej[6,],AR1_500_Simp$Rej[7,])

colnames(TPDif2VZW)= c('Dif. 2-VZ, N=20', 'TP, N=20','3-VZ, N=20','Dif. 2V-Z, N=50', 'TP, N=50','3-VZ, N=50','Dif. 2-VZ, N=100', 'TP, N=100','3-VZ, N=100', 'Dif. 2-VZ, N=500', 'TP, N=500','3-VZ, N=500')
rownames(TPDif2VZW)=seq(-0.99,0.99,by=0.01)

L_TPDif2VZW= levelplot(TPDif2VZW,,panel = function(...){
  panel.levelplot(...)
  panel.abline(h = 3.5,lwd=4,col='white')
  panel.abline(h = 6.5,lwd=4,col='white')
  panel.abline(h = 9.5,lwd=4,col='white')
},colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))


panel.levelplot
panel.abline

windows(width=10,height=7)
plot(L_TPDif2VZW)
update(L_TPDif2VZW,aspect=0.5)





################ AR(2) fr vereinfachte Versionen: ####
#############################################################################
###n=20

AR2_Simp_20_DW=Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_Simp_20_V2VZ=Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK2')

AR2_Simp_20_V3VZ=Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK3')

AR2_Simp_20_V4VZ=Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK4')

AR2_Simp_20_V5VZ=Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK5')

AR2_Simp_20_Sign= Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_Simp_20_TP= Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_Simp_20_LB= Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_Simp_20_VNR= Rejrates2Simp(reps=100, n=20,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')




L_AR2_Simp_20_DW=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_LB=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                        main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_TP=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                      main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_V2VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_V2VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 2-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_V3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_V3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Simp. 3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_V4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_V4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Simp. 4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_20_V5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_20_V5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                       main="Simo. 5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)





windows(width=10, height=10)
grid.arrange(L_AR2_Simp_20_DW,L_AR2_Simp_20_LB,L_AR2_Simp_20_Sign,L_AR2_Simp_20_TP,L_AR2_Simp_20_VNR,L_AR2_Simp_20_V2VZ,L_AR2_Simp_20_V3VZ,L_AR2_Simp_20_V4VZ,L_AR2_Simp_20_V5VZ,ncol=3)




###n=50

AR2_Simp_50_DW=Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_Simp_50_V2VZ=Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK2')

AR2_Simp_50_V3VZ=Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK3')

AR2_Simp_50_V4VZ=Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK4')

AR2_Simp_50_V5VZ=Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK5')

AR2_Simp_50_Sign= Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_Simp_50_TP= Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_Simp_50_LB= Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_Simp_50_VNR= Rejrates2Simp(reps=100, n=50,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')




L_AR2_Simp_50_DW=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_LB=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_TP=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_V2VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_V2VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 2-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_V3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_V3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_V4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_V4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_50_V5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_50_V5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)





windows(width=10, height=10)
grid.arrange(L_AR2_Simp_50_DW,L_AR2_Simp_50_LB,L_AR2_Simp_50_Sign,L_AR2_Simp_50_TP,L_AR2_Simp_50_VNR,L_AR2_Simp_50_V2VZ,L_AR2_Simp_50_V3VZ,L_AR2_Simp_50_V4VZ,L_AR2_Simp_50_V5VZ,ncol=3)



###n=100

AR2_Simp_100_DW=Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_Simp_100_V2VZ=Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK2')

AR2_Simp_100_V3VZ=Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK3')

AR2_Simp_100_V4VZ=Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK4')

AR2_Simp_100_V5VZ=Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK5')

AR2_Simp_100_Sign= Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_Simp_100_TP= Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_Simp_100_LB= Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_Simp_100_VNR= Rejrates2Simp(reps=100, n=100,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')




L_AR2_Simp_100_DW=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_LB=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_TP=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_V2VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_V2VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 2-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_V3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_V3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_V4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_V4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_100_V5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_100_V5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simo. 5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)





windows(width=10, height=10)
grid.arrange(L_AR2_Simp_100_DW,L_AR2_Simp_100_LB,L_AR2_Simp_100_Sign,L_AR2_Simp_100_TP,L_AR2_Simp_100_VNR,L_AR2_Simp_100_V2VZ,L_AR2_Simp_100_V3VZ,L_AR2_Simp_100_V4VZ,L_AR2_Simp_100_V5VZ,ncol=3)


###n=500

AR2_Simp_500_DW=Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Durbin-Watson')

AR2_Simp_500_V2VZ=Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK2')

AR2_Simp_500_V3VZ=Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK3')

### Break
AR2_Simp_500_V4VZ=Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK4')

AR2_Simp_500_V5VZ=Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='SimpVZTK5')

AR2_Simp_500_Sign= Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Runs')

AR2_Simp_500_TP= Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Turning-Point')

AR2_Simp_500_LB= Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='Ljung-Box')

AR2_Simp_500_VNR= Rejrates2Simp(reps=100, n=500,order=c(2,0,0),testgrid= Grid_AR2, test='VonNeumannRang')



L_AR2_Simp_500_DW=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_DW  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Durbin-Watson",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_LB=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_LB  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Ljung-Box",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_Sign=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_Sign  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Runs",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_TP=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_TP  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                           main="Turning-Point",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_VNR=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_VNR  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                            main="Von-Neumann",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_V2VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_V2VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 2-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_V3VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_V3VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 3-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_V4VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_V4VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 4-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)

L_AR2_Simp_500_V5VZ=levelplot(Rej ~ rho1*rho2, data=AR2_Simp_500_V5VZ  ,pretty=T,layers=1,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.3), ylab=list(label=TeX('$\\rho_{2}$'),cex=1.3),
                             main="Simp. 5-VZ",col.regions=magma,scales=list(x=list(font=2,cex=1),y=list(font=2,cex=1)),  at=seq(0,1,by=0.05),colorkey=FALSE)





windows(width=10, height=10)
grid.arrange(L_AR2_Simp_500_DW,L_AR2_Simp_500_LB,L_AR2_Simp_500_Sign,L_AR2_Simp_500_TP,L_AR2_Simp_500_VNR,L_AR2_Simp_500_V2VZ,L_AR2_Simp_500_V3VZ,L_AR2_Simp_500_V4VZ,L_AR2_Simp_500_V5VZ,ncol=3)




############################################# Simplified Sarima ####
#############################

AR1_20_Simp_VVZT3=RejratesSimpS(reps=100, n=20,testgrid= Grid_Sarima)

AR1_50_Simp_VVZT3=RejratesSimpS(reps=100, n=50,testgrid= Grid_Sarima)

AR1_100_Simp_VVZT3=RejratesSimpS(reps=100, n=100,testgrid= Grid_Sarima)

AR1_500_Simp_VVZT3=RejratesSimpS(reps=100, n=500,testgrid= Grid_Sarima)



###n=50

### Season1

Season1=(AR1_50_Simp_VVZT3[,(seq(1,dim(AR1_50_Simp_VVZT3)[2],by=6))]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season1) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season1) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')

L_Season1= levelplot(t(Season1),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season1)
update(L_Season1,aspect=0.5)



### Season2
Season2=(AR1_50_Simp_VVZT3[,seq(2,dim(AR1_50_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season2) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season2) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')
L_Season2= levelplot(t(Season2),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season2)
update(L_Season2,aspect=0.5)




### Season3
Season3=(AR1_50_Simp_VVZT3[,seq(3,dim(AR1_50_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season3) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season3) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')

L_Season3= levelplot(t(Season3),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season3)
update(L_Season3,aspect=0.5)




### Season4
Season4=(AR1_50_Simp_VVZT3[,seq(4,dim(AR1_50_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season4) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season4) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK4', 'SimpVZTK4','SimpVZTK5')

L_Season4= levelplot(t(Season4),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season4)
update(L_Season4,aspect=0.5)



### Season5
Season5=(AR1_50_Simp_VVZT3[,seq(5,dim(AR1_50_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season5) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season5) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK5', 'SimpVZTK5','SimpVZTK5')

L_Season5= levelplot(t(Season5),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season5)
update(L_Season5,aspect=0.5)


### Season6
Season6=(AR1_50_Simp_VVZT3[,seq(6,dim(AR1_50_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season6) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season6) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')

L_Season6= levelplot(t(Season6),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season6)
update(L_Season6,aspect=0.5)


#### Einzelne Tests

###DW
Sarima_Simp_50_DW=list()
Sarima_Simp_50_DW$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_DW$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_DW$Rej=c(Season1[1,],Season2[1,],Season3[1,],Season4[1,],Season5[1,],Season6[1,]) 

L_Sarima_Simp_50_DW= levelplot(Rej~rho*season,data=Sarima_Simp_50_DW,colorkey=FALSE,main="Durbin-Watson", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


######VNR
Sarima_Simp_50_VNR=list()
Sarima_Simp_50_VNR$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_VNR$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_VNR$Rej=c(Season1[2,],Season2[2,],Season3[2,],Season4[2,],Season5[2,],Season6[2,]) 

L_Sarima_Simp_50_VNR= levelplot(Rej~rho*season,data=Sarima_Simp_50_VNR,colorkey=FALSE,main="Von-Neumann", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###LB
Sarima_Simp_50_LB=list()
Sarima_Simp_50_LB$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_LB$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_LB$Rej=c(Season1[3,],Season2[3,],Season3[3,],Season4[3,],Season5[3,],Season6[3,]) 

L_Sarima_Simp_50_LB= levelplot(Rej~rho*season,data=Sarima_Simp_50_LB,colorkey=FALSE,main="Ljung-Box", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###Runs
Sarima_Simp_50_Runs=list()
Sarima_Simp_50_Runs$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_Runs$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_Runs$Rej=c(Season1[4,],Season2[4,],Season3[4,],Season4[4,],Season5[4,],Season6[4,]) 

L_Sarima_Simp_50_Runs= levelplot(Rej~rho*season,data=Sarima_Simp_50_Runs,colorkey=FALSE,main="Runs", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###TP
Sarima_Simp_50_TP=list()
Sarima_Simp_50_TP$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_TP$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_TP$Rej=c(Season1[5,],Season2[5,],Season3[5,],Season4[5,],Season5[5,],Season6[5,]) 

L_Sarima_Simp_50_TP= levelplot(Rej~rho*season,data=Sarima_Simp_50_TP,colorkey=FALSE,main="Turning-Point", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###2VZ
Sarima_Simp_50_2VZ=list()
Sarima_Simp_50_2VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_2VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_2VZ$Rej=c(Season1[6,],Season2[6,],Season3[6,],Season4[6,],Season5[6,],Season6[6,]) 

L_Sarima_Simp_50_2VZ= levelplot(Rej~rho*season,data=Sarima_Simp_50_2VZ,colorkey=FALSE,main="Simp. 2-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###3VZ
Sarima_Simp_50_3VZ=list()
Sarima_Simp_50_3VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_3VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_3VZ$Rej=c(Season1[7,],Season2[7,],Season3[7,],Season4[7,],Season5[7,],Season6[7,]) 

L_Sarima_Simp_50_3VZ= levelplot(Rej~rho*season,data=Sarima_Simp_50_3VZ,colorkey=FALSE,main="Simp. 3-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###4VZ
Sarima_Simp_50_4VZ=list()
Sarima_Simp_50_4VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_4VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_4VZ$Rej=c(Season1[8,],Season2[8,],Season3[8,],Season4[8,],Season5[8,],Season6[8,]) 

L_Sarima_Simp_50_4VZ= levelplot(Rej~rho*season,data=Sarima_Simp_50_4VZ,colorkey=FALSE,main="Simp. 4-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###5VZ
Sarima_Simp_50_5VZ=list()
Sarima_Simp_50_5VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_50_5VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_50_5VZ$Rej=c(Season1[9,],Season2[9,],Season3[9,],Season4[9,],Season5[9,],Season6[9,]) 

L_Sarima_Simp_50_5VZ= levelplot(Rej~rho*season,data=Sarima_Simp_50_5VZ,colorkey=FALSE,main="Simp. 5-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))




windows(width=10,height=10)
grid.arrange(L_Sarima_Simp_50_DW,L_Sarima_Simp_50_LB,L_Sarima_Simp_50_Runs,L_Sarima_Simp_50_TP,L_Sarima_Simp_50_VNR,L_Sarima_Simp_50_2VZ,L_Sarima_Simp_50_3VZ,L_Sarima_Simp_50_4VZ,L_Sarima_Simp_50_5VZ,ncol=3)




###n=500

### Season1

Season1=(AR1_500_Simp_VVZT3[,(seq(1,dim(AR1_500_Simp_VVZT3)[2],by=6))]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season1) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season1) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')

L_Season1= levelplot(t(Season1),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season1)
update(L_Season1,aspect=0.5)



### Season2
Season2=(AR1_500_Simp_VVZT3[,seq(2,dim(AR1_500_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season2) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season2) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')
L_Season2= levelplot(t(Season2),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season2)
update(L_Season2,aspect=0.5)




### Season3
Season3=(AR1_500_Simp_VVZT3[,seq(3,dim(AR1_500_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season3) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season3) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK3', 'SimpVZTK4','SimpVZTK5')

L_Season3= levelplot(t(Season3),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season3)
update(L_Season3,aspect=0.5)




### Season4
Season4=(AR1_500_Simp_VVZT3[,seq(4,dim(AR1_500_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season4) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season4) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK4', 'SimpVZTK4','SimpVZTK5')

L_Season4= levelplot(t(Season4),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season4)
update(L_Season4,aspect=0.5)



### Season5
Season5=(AR1_500_Simp_VVZT3[,seq(5,dim(AR1_500_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season5) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season5) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','SimpVZTK2', 'SimpVZTK5', 'SimpVZTK5','SimpVZTK5')

L_Season5= levelplot(t(Season5),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season5)
update(L_Season5,aspect=0.5)


### Season6
Season6=(AR1_500_Simp_VVZT3[,seq(6,dim(AR1_500_Simp_VVZT3)[2],by=6)]/100)[c(1,2,4,5,10,6,7,8,9),]
colnames(Season6) <- c(seq(-0.99,0.99,by=0.01))
rownames(Season6) <- c('Durbin-Watson','VonNeumannRang','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')

L_Season6= levelplot(t(Season6),colorkey=FALSE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))
plot(L_Season6)
update(L_Season6,aspect=0.5)


#### Einzelne Tests

###DW
Sarima_Simp_500_DW=list()
Sarima_Simp_500_DW$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_DW$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_DW$Rej=c(Season1[1,],Season2[1,],Season3[1,],Season4[1,],Season5[1,],Season6[1,]) 

L_Sarima_Simp_500_DW= levelplot(Rej~rho*season,data=Sarima_Simp_500_DW,colorkey=FALSE,main="Durbin-Watson", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


######VNR
Sarima_Simp_500_VNR=list()
Sarima_Simp_500_VNR$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_VNR$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_VNR$Rej=c(Season1[2,],Season2[2,],Season3[2,],Season4[2,],Season5[2,],Season6[2,]) 

L_Sarima_Simp_500_VNR= levelplot(Rej~rho*season,data=Sarima_Simp_500_VNR,colorkey=FALSE,main="Von-Neumann", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###LB
Sarima_Simp_500_LB=list()
Sarima_Simp_500_LB$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_LB$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_LB$Rej=c(Season1[3,],Season2[3,],Season3[3,],Season4[3,],Season5[3,],Season6[3,]) 

L_Sarima_Simp_500_LB= levelplot(Rej~rho*season,data=Sarima_Simp_500_LB,colorkey=FALSE,main="Ljung-Box", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###Runs
Sarima_Simp_500_Runs=list()
Sarima_Simp_500_Runs$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_Runs$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_Runs$Rej=c(Season1[4,],Season2[4,],Season3[4,],Season4[4,],Season5[4,],Season6[4,]) 

L_Sarima_Simp_500_Runs= levelplot(Rej~rho*season,data=Sarima_Simp_500_Runs,colorkey=FALSE,main="Runs", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###TP
Sarima_Simp_500_TP=list()
Sarima_Simp_500_TP$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_TP$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_TP$Rej=c(Season1[5,],Season2[5,],Season3[5,],Season4[5,],Season5[5,],Season6[5,]) 

L_Sarima_Simp_500_TP= levelplot(Rej~rho*season,data=Sarima_Simp_500_TP,colorkey=FALSE,main="Turning-Point", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###2VZ
Sarima_Simp_500_2VZ=list()
Sarima_Simp_500_2VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_2VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_2VZ$Rej=c(Season1[6,],Season2[6,],Season3[6,],Season4[6,],Season5[6,],Season6[6,]) 

L_Sarima_Simp_500_2VZ= levelplot(Rej~rho*season,data=Sarima_Simp_500_2VZ,colorkey=FALSE,main="Simp. 2-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###3VZ
Sarima_Simp_500_3VZ=list()
Sarima_Simp_500_3VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_3VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_3VZ$Rej=c(Season1[7,],Season2[7,],Season3[7,],Season4[7,],Season5[7,],Season6[7,]) 

L_Sarima_Simp_500_3VZ= levelplot(Rej~rho*season,data=Sarima_Simp_500_3VZ,colorkey=FALSE,main="Simp. 3-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###4VZ
Sarima_Simp_500_4VZ=list()
Sarima_Simp_500_4VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_4VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_4VZ$Rej=c(Season1[8,],Season2[8,],Season3[8,],Season4[8,],Season5[8,],Season6[8,]) 

L_Sarima_Simp_500_4VZ= levelplot(Rej~rho*season,data=Sarima_Simp_500_4VZ,colorkey=FALSE,main="Simp. 4-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))


###5VZ
Sarima_Simp_500_5VZ=list()
Sarima_Simp_500_5VZ$season=c(rep(1,199),rep(2,199),rep(3,199),rep(4,199),rep(5,199),rep(6,199))
Sarima_Simp_500_5VZ$rho=rep(seq(-0.99,0.99,by=0.01),6)
Sarima_Simp_500_5VZ$Rej=c(Season1[9,],Season2[9,],Season3[9,],Season4[9,],Season5[9,],Season6[9,]) 

L_Sarima_Simp_500_5VZ= levelplot(Rej~rho*season,data=Sarima_Simp_500_5VZ,colorkey=FALSE,main="Simp. 5-VZ", ylab=list(label='Saison [S]',cex=1.3),pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(y=list(font=2,cex=1),x=list(font=2,cex=1)), at=seq(0,1,by=0.05))




windows(width=10,height=10)
grid.arrange(L_Sarima_Simp_500_DW,L_Sarima_Simp_500_LB,L_Sarima_Simp_500_Runs,L_Sarima_Simp_500_TP,L_Sarima_Simp_500_VNR,L_Sarima_Simp_500_2VZ,L_Sarima_Simp_500_3VZ,L_Sarima_Simp_500_4VZ,L_Sarima_Simp_500_5VZ,ncol=3)




############### Simp MA-Prozesse ############
####################################

###n=20
Ma1_Simp_20=RejratesMASimp(reps=100, n=20,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_Simp_20 = Ma1_Simp_20$Rej[c(1,2,4,5,10,6,7,8,9),]
rownames(Gem_Ma1_Simp_20)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')
colnames(Gem_Ma1_Simp_20) <- seq(-5,5,by=0.1)


Gem_Ma1_Simp_20_Levelplot=levelplot(t(Gem_Ma1_Simp_20),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_Simp_20_Levelplot)
update(Gem_Ma1_Simp_20_Levelplot, aspect=0.5)

###n=50
Ma1_Simp_50=RejratesMASimp(reps=100, n=50,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_Simp_50 = Ma1_Simp_50$Rej[c(1,2,4,5,10,6,7,8,9),]
rownames(Gem_Ma1_Simp_50)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')
colnames(Gem_Ma1_Simp_50) <- seq(-5,5,by=0.1)


Gem_Ma1_Simp_50_Levelplot=levelplot(t(Gem_Ma1_Simp_50),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_Simp_50_Levelplot)
update(Gem_Ma1_Simp_50_Levelplot, aspect=0.5)

###n=100
Ma1_Simp_100=RejratesMASimp(reps=100, n=100,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_Simp_100 = Ma1_Simp_100$Rej[c(1,2,4,5,10,6,7,8,9),]
rownames(Gem_Ma1_Simp_100)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')
colnames(Gem_Ma1_Simp_100) <- seq(-5,5,by=0.1)


Gem_Ma1_Simp_100_Levelplot=levelplot(t(Gem_Ma1_Simp_100),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_Simp_100_Levelplot)
update(Gem_Ma1_Simp_100_Levelplot, aspect=0.5)

###n=500
Ma1_Simp_500=RejratesMASimp(reps=100, n=500,order=c(0,0,1),testgrid= Grid_MA)
Gem_Ma1_Simp_500 = Ma1_Simp_500$Rej[c(1,2,4,5,10,6,7,8,9),]
rownames(Gem_Ma1_Simp_500)<- c('Durbin-Watson','Von-Neumann','Ljung-Box', 'Runs', 'Turning-Point','Simp. 2-VZ', 'Simp. 3-VZ', 'Simp. 4-VZ','Simp. 5-VZ')
colnames(Gem_Ma1_Simp_500) <- seq(-5,5,by=0.1)


Gem_Ma1_Simp_500_Levelplot=levelplot(t(Gem_Ma1_Simp_500),ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\nu_{1}$'),cex=1.7),scales=list(x=list(font=2,at=c(1,seq(11,length(Grid_AR1_Simple),by=10)),labels=(seq(-5,5,by=1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(Gem_Ma1_Simp_500_Levelplot)
update(Gem_Ma1_Simp_500_Levelplot, aspect=0.5)



####### Abweichungen Vereinfachte Tiefen#####


#### Trend

Grid_AR1_Drift=as.data.frame(CJ(rho=c(-0.99,seq(-0.95,0.95,by=0.05),0.99),drift= seq(-5,5,by=0.1)))


### 2VZT
AR1_500_Drift_V2VZ=RejratesD2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Drift, test=c("SimpVZTK2","SimpVZTK3","SimpVZTK4","SimpVZTK5"))

L_AR1_500_V2VZ_Drift=levelplot(RejSimpVZTK2 ~ rho*drift,main="Simp. 2-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1),labels=seq(-5,5,by=1)/500)),  data=AR1_500_Drift_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.5), at=seq(0,1,by=0.05))


### 3VZT
L_AR1_500_V3VZ_Drift=levelplot(RejSimpVZTK3 ~ rho*drift,main="Simp. 3-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1),labels=seq(-5,5,by=1)/500)),  data=AR1_500_Drift_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.5), at=seq(0,1,by=0.05))


### 4VZT

L_AR1_500_V4VZ_Drift=levelplot(RejSimpVZTK4 ~ rho*drift,main="Simp. 4-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1),labels=seq(-5,5,by=1)/500)),  data=AR1_500_Drift_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.5), at=seq(0,1,by=0.05))


### 5VZT

L_AR1_500_V5VZ_Drift=levelplot(RejSimpVZTK5 ~ rho*drift,main="Simp. 5-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1),labels=seq(-5,5,by=1)/500)),  data=AR1_500_Drift_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Steigung des Trends',cex=1.5), at=seq(0,1,by=0.05))



windows(width=10,height=10)
grid.arrange(L_AR1_500_V2VZ_Drift,L_AR1_500_V3VZ_Drift,L_AR1_500_V4VZ_Drift,L_AR1_500_V5VZ_Drift)



#### Sprung

Grid_AR1_Sprung= as.data.frame(CJ(rho1=c(-0.99,seq(from=-0.95,to=0.95,by=0.05),0.99),hhe= seq(-5,5,by=0.1)))


### 2VZT
AR1_500_Sprung_V2VZ=RejratesSprung2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_AR1_Sprung, test=c("SimpVZTK2","SimpVZTK3","SimpVZTK4","SimpVZTK5"))

L_AR1_500_V2VZ_Sprung=levelplot(RejSimpVZTK2 ~ rho1*hhe,main="Simp. 2-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Sprung_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Sprunghhe',cex=1.5), at=seq(0,1,by=0.05))


### 3VZT

L_AR1_500_V3VZ_Sprung=levelplot(RejSimpVZTK3 ~ rho1*hhe,main="Simp. 3-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Sprung_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Sprunghhe',cex=1.5), at=seq(0,1,by=0.05))


### 4VZT
L_AR1_500_V4VZ_Sprung=levelplot(RejSimpVZTK4 ~ rho1*hhe,main="Simp. 4-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Sprung_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Sprunghhe',cex=1.5), at=seq(0,1,by=0.05))


### 5VZT
L_AR1_500_V5VZ_Sprung=levelplot(RejSimpVZTK5 ~ rho1*hhe,main="Simp. 5-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Sprung_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Sprunghhe',cex=1.5), at=seq(0,1,by=0.05))





windows(width=10,height=10)
grid.arrange(L_AR1_500_V2VZ_Sprung,L_AR1_500_V3VZ_Sprung,L_AR1_500_V4VZ_Sprung,L_AR1_500_V5VZ_Sprung)



#### Oszillation: viele Oszillationen

### 2VZT
AR1_500_Osz1_V2VZ=RejratesO(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test=c("SimpVZTK2","SimpVZTK3","SimpVZTK4","SimpVZTK5"))

L_AR1_500_V2VZ_Osz1=levelplot(RejSimpVZTK2 ~ rho*Amp,main="Simp. 2-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz1_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V2VZ_Osz1)

### 3VZT
L_AR1_500_V3VZ_Osz1=levelplot(RejSimpVZTK3 ~ rho*Amp,main="Simp. 3-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz1_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V3VZ_Osz1)

### 4VZT
L_AR1_500_V4VZ_Osz1=levelplot(RejSimpVZTK4 ~ rho*Amp,main="Simp. 4-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz1_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V4VZ_Osz1)

### 5VZT
L_AR1_500_V5VZ_Osz1=levelplot(RejSimpVZTK5 ~ rho*Amp,main="Simp. 5-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz1_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V5VZ_Osz1)


windows(width=10, height=10)
grid.arrange(L_AR1_500_V2VZ_Osz1,L_AR1_500_V3VZ_Osz1,L_AR1_500_V4VZ_Osz1,L_AR1_500_V5VZ_Osz1,ncol=2)


#### Oszillation: eine Oszillationen

### 2VZT
AR1_500_Osz2_V2VZ=RejratesO2(reps=100, n=500,order=c(1,0,0),testgrid= Grid_Osz, test=c("SimpVZTK2","SimpVZTK3","SimpVZTK4","SimpVZTK5"))



L_AR1_500_V2VZ_Osz2=levelplot(RejSimpVZTK2 ~ rho*Amp,main="Simp. 2-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz2_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V2VZ_Osz2)

### 3VZT
L_AR1_500_V3VZ_Osz2=levelplot(RejSimpVZTK3 ~ rho*Amp,main="Simp. 3-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz2_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V3VZ_Osz2)

### 4VZT
L_AR1_500_V4VZ_Osz2=levelplot(RejSimpVZTK4 ~ rho*Amp,main="Simp. 4-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz2_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V4VZ_Osz2)

### 5VZT
L_AR1_500_V5VZ_Osz2=levelplot(RejSimpVZTK5 ~ rho*Amp,main="Simp. 5-VZ",colorkey=FALSE,scales=list(x=list(font=2,at=seq(-9,9,by=3)/10,cex=1),y=list(font=2,cex=1,at=seq(-5,5,by=1))),  data=AR1_500_Osz2_V2VZ,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),ylab=list(label='Amplitude',cex=1.7), at=seq(0,1,by=0.05))
windows(width=10,height=7)
plot(L_AR1_500_V5VZ_Osz2)


windows(width=10, height=10)
grid.arrange(L_AR1_500_V2VZ_Osz2,L_AR1_500_V3VZ_Osz2,L_AR1_500_V4VZ_Osz2,L_AR1_500_V5VZ_Osz2,ncol=2)








#### Weiteres zu GARCH:

####Beispielhafte Zeitreihen

#Generieren + Residuen +Signs
spec = garchSpec(model = list(alpha = 0.001, beta = 0.5))
sim_data=as.numeric(garchSim(spec, n = 5000))


windows(width=10,height=7)
op <- par(family='serif', las=1, tcl=0.3, mgp=c(2,2,1), cex.lab= 1.7,cex.axis=1.5)
plot(sim_data,type='l', xlab='Index', ylab='', xaxt='n', yaxt='n', lwd=1.5)


magaxis(side = 1:2, majorn = 5, minorn = 'auto', tcl = 0.3, ratio = 0.5, labels = TRUE,
        unlog = 'auto', mgp = c(2,0.5,0), mtline = 2, xlab = NULL, ylab = NULL, crunch = TRUE,
        logpretty = FALSE, prettybase = 10, powbase = 10, hersh = FALSE, family = 'serif')




spec = garchSpec(model = list(alpha = 0.05, beta = 0.5))
sim_data=as.numeric(garchSim(spec, n = 5000))

plot(sim_data,type='l')


####


CJARGarchBDS= CJ(alpha=seq(0,0.1,by=0.005),beta= seq(0.85,1,by=0.005))

Grid_GARCHBDS <- as.data.frame(CJARGarchBDS[alpha+beta<1])

GARCH_5000_BDS_2= RejratesGARCH(reps=100, n=5000,testgrid= Grid_GARCHBDS, test='BDS')

L_GARCH_5000_BDS_2=levelplot(Rej ~ alpha*beta,scales=list(x=list(font=2,cex=1.3),y=list(font=2,cex=1.3)), data=GARCH_5000_BDS_2  ,colorkey=list(labels=list(cex=1.3,font=2)),pretty=T,layers=1,xlab=list(label=TeX('$\\alpha}$'),cex=2), ylab=list(label=TeX('$\\beta$'),cex=2),
                         main="",col.regions=magma, at=seq(0,1,by=0.05))


windows(width=10,height=7)
plot(L_GARCH_5000_BDS_2)


###### Vereinfachte Tiefen: ABlehnung ####
K=5
n=100
critVals= qnorm(0.025,sd=sqrt((1/2)^(K-1)*(3-(1/2)^(K-2)*(K-1)-3*(1/2)^(K-1))),mean=(1/2)^(K-1)*(n-K+1))
critVals


(qnorm(0.025)/sqrt(n-K))*(sqrt((1/2)^(K)*(3-((1/2)^(K-1))*(K)-3*(1/2)^(K)))) + ((1/2)^(K))*(n-K)











################## Nochmal vereinfachte


## n=20
Gem_AR1_20_Simp_K2 = AR1_20_Simp$Rej[rev(c(13,12,11,9,8,7,6,5)),]
rownames(Gem_AR1_20_Simp_K2)<- rev(c('5-VZ','4-VZ','3-VZ','Simp. 5-VZ ','Simp. 4-VZ','Simp. 3-VZ','Simp. 2-VZ', 'Runs'))
colnames(Gem_AR1_20_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_20_Simp_K2_Levelplot=levelplot(t(Gem_AR1_20_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_20_Simp_K2_Levelplot)
update(AR1_20_Simp_K2_Levelplot, aspect=0.5)




## n=50
Gem_AR1_50_Simp_K2 = AR1_50_Simp$Rej[rev(c(13,12,11,9,8,7,6,5)),]
rownames(Gem_AR1_50_Simp_K2)<- rev(c('5-VZ','4-VZ','3-VZ','Simp. 5-VZ ','Simp. 4-VZ','Simp. 3-VZ','Simp. 2-VZ', 'Runs'))
colnames(Gem_AR1_50_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_50_Simp_K2_Levelplot=levelplot(t(Gem_AR1_50_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_50_Simp_K2_Levelplot)
update(AR1_50_Simp_K2_Levelplot, aspect=0.5)





## n=100
Gem_AR1_100_Simp_K2 = AR1_100_Simp$Rej[rev(c(13,12,11,9,8,7,6,5)),]
rownames(Gem_AR1_100_Simp_K2)<- rev(c('5-VZ','4-VZ','3-VZ','Simp. 5-VZ ','Simp. 4-VZ','Simp. 3-VZ','Simp. 2-VZ', 'Runs'))
colnames(Gem_AR1_100_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_100_Simp_K2_Levelplot=levelplot(t(Gem_AR1_100_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_100_Simp_K2_Levelplot)
update(AR1_100_Simp_K2_Levelplot, aspect=0.5)




## n=500
Gem_AR1_500_Simp_K2 = AR1_500_Simp$Rej[rev(c(13,12,11,9,8,7,6,5)),]
rownames(Gem_AR1_500_Simp_K2)<- rev(c('5-VZ','4-VZ','3-VZ','Simp. 5-VZ ','Simp. 4-VZ','Simp. 3-VZ','Simp. 2-VZ', 'Runs'))
colnames(Gem_AR1_500_Simp_K2) <- c(seq(-0.99,0.99,by=0.01))


AR1_500_Simp_K2_Levelplot=levelplot(t(Gem_AR1_500_Simp_K2),colorkey=TRUE,ylab=NULL,pretty=T,col.regions=magma,xlab=list(label=TeX('$\\rho_{1}$'),cex=1.7),scales=list(x=list(font=2,at=seq(10,length(Grid_AR1_Simple),by=10),labels=(seq(-0.9,0.9,by=0.1)),cex=1),y=list(font=2,cex=1)) , at=seq(0,1,by=0.05))

windows(width=10,height=7)                                                                                  
plot(AR1_500_Simp_K2_Levelplot)
update(AR1_500_Simp_K2_Levelplot, aspect=0.5)


